local assets = {
  [ "copywin.lua" ] = {
    id = 22,
    content = "local sl = shapescape.getSlides()\
self.window = sl[1].win\
self.window.redraw()",
    name = "copywin.lua",
  },
  [ "load.lua" ] = {
    id = 17,
    content = "local function potato()\
    local fp = lUtils.explorer(\"User\",\"SelFile\")\
    local sl = shapescape.getSlides()\
    sl.loadImage(fp)\
end\
local ok,err = pcall(potato)\
if not ok then\
    lUtils.popup(\"OH NO\",err,40,20,{\"OK\"})\
end",
    name = "load.lua",
  },
  [ "preview.lua" ] = {
    id = 13,
    content = "local s = shapescape.getSlide()\
local sl = shapescape.getSlides()\
--lOS.spritedebuglog = {}\
local function genSpr(spr,renderinvalid)\
	local id\
	for f=1,#sl.frames do\
		if spr == sl.frames[f][1] then\
			id = f\
			break\
		end\
	end\
	local tSprite = {}\
	local function tc(char,num)\
		--table.insert(lOS.spritedebuglog,char[num])\
		if not char or not char[num] then\
			return false\
		end\
		local ch = char[num]\
		if ch == 0 then\
			return false\
		else\
			return lUtils.toBlit(ch)\
		end\
	end\
	local function max(tbl)\
		local m = {}\
		for key,value in pairs(tbl) do\
			if not m[1] and not m[2] then\
				m[1] = key\
			elseif not m[2] then\
				if value > tbl[m[1]] then\
					table.insert(m,1,key)\
				else\
					m[2] = key\
				end\
			elseif value > tbl[m[1]] then\
				table.insert(m,1,key)\
				m[3] = nil\
			elseif value > tbl[m[2]] then\
				m[2] = key\
			end\
		end\
		return m\
	end\
	for l=1,#spr,3 do\
		tSprite[math.ceil(l/3)] = {\"\",\"\",\"\"}\
		local line = tSprite[math.ceil(l/3)]\
		if not spr[l] then spr[l] = {} end\
		if not spr[l+1] then spr[l+1] = {} end\
		if not spr[l+2] then spr[l+2] = {} end\
		for c=1,#spr[l],2 do\
			if sl.chars[id] and sl.chars[id][math.ceil(c/2)..\",\"..math.ceil(l/3)] then\
				local pix = sl.chars[id][math.ceil(c/2)..\",\"..math.ceil(l/3)]\
				line[1] = line[1]..pix[1]\
				line[2] = line[2]..pix[2]\
				line[3] = line[3]..pix[3]\
			else\
				local s1 = spr[l]\
				local s2 = spr[l+1]\
				local s3 = spr[l+2]\
				local pix = {tc(s1,c),tc(s1,c+1),tc(s2,c),tc(s2,c+1),tc(s3,c),tc(s3,c+1)}\
				local cols = {[\" \"]=0}\
				local variation = 0\
				for t=1,#pix do\
					if pix[t] == false or pix[t] == \"\" then\
						if cols[\" \"] == 0 then\
							variation = variation+1\
						end\
						cols[\" \"] = cols[\" \"]+1\
					else\
						if not cols[pix[t]] or cols[pix[t]] == 0 then\
							variation = variation+1\
							cols[pix[t]] = 0\
						end\
						cols[pix[t]] = cols[pix[t]]+1\
					end\
				end\
				if variation > 2 then\
					sl.invalid[math.ceil(c/2)][math.ceil(l/3)] = true\
				else\
					sl.invalid[math.ceil(c/2)][math.ceil(l/3)] = false\
				end\
				local color = max(cols)\
				if not color[1] then\
					color[1] = \" \"\
				end\
				if #color == 1 then\
					color[2] = color[1]\
				end\
				for t=1,#pix do\
					if pix[t] == false then\
						pix[t] = \" \"\
					end\
					if pix[t] == color[2] then\
						pix[t] = false\
					else\
						pix[t] = true\
					end\
				end\
				if variation > 2 and renderinvalid then\
					line[1] = line[1]..\"X\"\
					line[2] = line[2]..\"f\"\
					line[3] = line[3]..\"e\"\
				else\
					local p = lUtils.getDrawingCharacter(unpack(pix))\
					line[1] = line[1]..p.char\
					if p.inverted then\
						color[1],color[2] = color[2],color[1]\
					end\
					if not color[1] or not color[2] then\
						error(textutils.serialize(color))\
					end\
					line[2] = line[2]..color[1]\
					line[3] = line[3]..color[2]\
				end\
			end\
		end\
	end\
	return tSprite\
end\
s.var.genSpr = genSpr\
local function clear()\
	local w,h = term.getSize()\
	term.setBackgroundColor(colors.black)\
	term.setTextColor(colors.red)\
	for y=1,h do\
		term.setCursorPos(1,y)\
		term.write(string.rep(\"\\127\",w))\
	end\
end\
s.var.previewcolor = colors.black\
local function renderSpr(tSprite)\
	lOS.debugsprite = tSprite\
	clear()\
	term.setCursorPos(1,1)\
	if tSprite then\
		for t=1,#tSprite do\
			term.setCursorPos(1,t)\
			local bl = {}\
			bl[1] = tSprite[t][1]\
			bl[2] = string.gsub(tSprite[t][2],\" \",lUtils.toBlit(s.var.previewcolor))\
			bl[3] = string.gsub(tSprite[t][3],\" \",lUtils.toBlit(s.var.previewcolor))\
			--print(textutils.serialize(bl))\
			term.blit(unpack(bl))\
		end\
	end\
end\
local preview\
local tID\
local frame = 1\
os.sleep(0.5)\
os.queueEvent(\"squarepaint_preview\")\
local o = s.var.cvsobj\
while true do\
	local e = {os.pullEvent()}\
	if e[1] == \"squarepaint_preview\" then\
		preview = {}\
		for k,v in pairs(sl.frames) do\
			preview[k] = genSpr(v[1],true)\
			if s.var.fps == 0 and v == sl.frame then\
				frame = k\
			end\
		end\
		renderSpr(preview[frame])\
	elseif e[1] == \"timer\" and e[2] == tID then\
		if s.var.fps == 0 then\
			for k,v in pairs(sl.frames) do\
				if v == sl.frame then\
					frame = k\
					break\
				end\
			end\
			renderSpr(preview[frame])\
			tID = nil\
		else\
			frame = frame+1\
			if not preview[frame] then\
				frame = 1\
			end\
			renderSpr(preview[frame])\
			tID = os.startTimer(1/s.var.fps)\
		end\
	end\
	if s.var.fps > 0 and not tID then\
		tID = os.startTimer(1/s.var.fps)\
	end\
end",
    name = "preview.lua",
  },
  [ "lua.lua" ] = {
    id = 4,
    content = "local tArgs = { ... }\
if #tArgs > 0 then\
    print(\"This is an interactive Lua prompt.\")\
    print(\"To run a lua program, just type its name.\")\
    return\
end\
\
local pretty = require and require \"cc.pretty\" or dofile \"/rom/modules/main/cc/expect.lua\"\
\
local bRunning = true\
local tCommandHistory = {}\
local tEnv = {\
    [\"exit\"] = setmetatable({}, {\
        __tostring = function() return \"Call exit() to exit.\" end,\
        __call = function() bRunning = false end,\
    }),\
    [\"_echo\"] = function(...)\
        return ...\
    end,\
}\
setmetatable(tEnv, { __index = _ENV })\
\
-- Replace our package.path, so that it loads from the current directory, rather\
-- than from /rom/programs. This makes it a little more friendly to use and\
-- closer to what you'd expect.\
if shell then\
    local dir = shell.dir()\
    if dir:sub(1, 1) ~= \"/\" then dir = \"/\" .. dir end\
    if dir:sub(-1) ~= \"/\" then dir = dir .. \"/\" end\
\
    local strip_path = \"?;?.lua;?/init.lua;\"\
    local path = package.path\
    if path:sub(1, #strip_path) == strip_path then\
        path = path:sub(#strip_path + 1)\
    end\
\
    package.path = dir .. \"?;\" .. dir .. \"?.lua;\" .. dir .. \"?/init.lua;\" .. path\
end\
\
if term.isColour() then\
    term.setTextColour(colours.yellow)\
end\
print(_G._CCPC_DEBUGGER_ACTIVE and \"Entering debugger.\" or \"Interactive Lua prompt.\")\
print(\"Call exit() to exit.\")\
term.setTextColour(colours.white)\
\
while bRunning do\
    --if term.isColour() then\
    --    term.setTextColour( colours.yellow )\
    --end\
    write(_G._CCPC_DEBUGGER_ACTIVE and \"lua_debug> \" or \"lua> \")\
    --term.setTextColour( colours.white )\
\
    local s = read(nil, tCommandHistory, function(sLine)\
        if settings.get(\"lua.autocomplete\") then\
            local nStartPos = string.find(sLine, \"[a-zA-Z0-9_%.:]+$\")\
            if nStartPos then\
                sLine = string.sub(sLine, nStartPos)\
            end\
            if #sLine > 0 then\
                return textutils.complete(sLine, tEnv)\
            end\
        end\
        return nil\
    end)\
    if s:match(\"%S\") and tCommandHistory[#tCommandHistory] ~= s then\
        table.insert(tCommandHistory, s)\
    end\
    if settings.get(\"lua.warn_against_use_of_local\") and s:match(\"^%s*local%s+\") then\
        if term.isColour() then\
            term.setTextColour(colours.yellow)\
        end\
       print(\"To access local variables in later inputs, remove the local keyword.\")\
       term.setTextColour(colours.white)\
    end\
\
    local nForcePrint = 0\
    local func, e = load(s, \"=lua\", \"t\", tEnv)\
    local func2 = load(\"return _echo(\" .. s .. \");\", \"=lua\", \"t\", tEnv)\
    if not func then\
        if func2 then\
            func = func2\
            e = nil\
            nForcePrint = 1\
        end\
    else\
        if func2 then\
            func = func2\
        end\
    end\
\
    if func then\
        local tResults = table.pack(pcall(func))\
        if tResults[1] then\
            local n = 1\
            while n < tResults.n or n <= nForcePrint do\
                local value = tResults[n + 1]\
                local ok, serialised = pcall(pretty.pretty, value, {\
                    function_args = settings.get(\"lua.function_args\"),\
                    function_source = settings.get(\"lua.function_source\"),\
                })\
                if ok then\
                    pretty.print(serialised)\
                else\
                    print(tostring(value))\
                end\
                n = n + 1\
            end\
        else\
            printError(tResults[2])\
        end\
    else\
        printError(e)\
    end\
\
end",
    name = "lua.lua",
  },
  [ "framelist.lua" ] = {
    id = 2,
    content = "local function dostuff()\
local s = shapescape.getSlide()\
local sl = shapescape.getSlides()\
local sel\
local sel2\
local sel3\
local drag\
local pos = {}\
os.sleep(0.5)\
local fr = sl.frames\
local bg = colors.lightGray\
local fg = colors.gray\
local function render(y)\
    pos = {}\
    term.setBackgroundColor(bg)\
    term.clear()\
    local w,h = term.getSize()\
    local max = #fr\
    if drag then max = max+1 end\
    for f=1,max do\
        local id = f\
        local ry = y+(f-1)*7\
        if f > #fr then\
            id = drag.id\
            ry = drag.y-4\
        end\
        if not fr[id].id then\
            fr[id].id = id\
        end\
        if drag and drag.id == f then\
            term.setTextColor(colors.orange)\
            term.setBackgroundColor(bg)\
            lUtils.border(1,ry-1,w,ry+5,nil,1)\
        else\
            if sl.frame == fr[id] then\
                term.setTextColor(colors.orange)\
            else\
                term.setTextColor(fg)\
            end\
            term.setBackgroundColor(bg)\
            lUtils.border(1,ry-1,w,ry+5,\"fill\",1)\
            --[[term.setBackgroundColor(colors.black)\
            term.setTextColor(colors.black)\
            lUtils.border(2,ry,w-1,ry+4,\"fill\")]]\
            local oterm = term.current()\
            if not fr[id].preview then\
                s.var.redraw()\
                local win3 = blittle.createWindow(term.current(),2,ry,w-2,5)\
                local win2 = window.create(term.current(),1,1,({win3.getSize()})[1],({win3.getSize()})[2],false)\
                local win1 = window.create(term.current(),1,1,s.var.w,s.var.h,false)\
                term.redirect(win1)\
                local cvs = fr[id][1]\
                for y1=1,s.var.h do\
                    if cvs[y1] then\
                        term.setCursorPos(1,y1)\
                        for x1=1,s.var.w do\
                            term.blit(\" \",\"f\",lUtils.toBlit(cvs[y1][x1]) or \"f\")\
                        end\
                    end\
                end\
                term.redirect(win2)\
                lUtils.littlewin(win1,term.getSize()).render(1,1)\
                term.redirect(oterm)\
                for l=1,math.floor(({win2.getSize()})[2]) do\
                    --term.setCursorPos(1,1)\
                    --term.write(l..\"/\"..({lWin.getSize()})[2])\
                    win3.setCursorPos(1,l)\
                    win3.blit(win2.getLine(l))\
                end\
                fr[id].preview = win3\
            else\
                fr[id].preview.reposition(2,ry,w-2,5)\
                fr[id].preview.redraw()\
            end\
            if f <= #fr then\
                pos[f] = {x1=2,y1=ry,x2=w-1,y2=ry+4}\
            end\
            term.setCursorPos(2,ry)\
            term.setBackgroundColor(fg)\
            term.setTextColor(colors.white)\
            term.write(id)\
            if sel == id then\
                if #fr > 1 then\
                    term.setCursorPos(w-1,ry)\
                    if sel3 == 1 then\
                        term.setTextColor(bg)\
                    else\
                        term.setTextColor(colors.white)\
                    end\
                    term.write(\"×\")\
                    term.setCursorPos(2,ry+4)\
                    if sel3 == 2 then\
                        term.setTextColor(bg)\
                    else\
                        term.setTextColor(colors.white)\
                    end\
                    term.write(\"\\18\")\
                end\
                term.setCursorPos(w-1,ry+4)\
                if sel3 == 3 then\
                    term.setTextColor(bg)\
                else\
                    term.setTextColor(colors.white)\
                end\
                term.write(\"+\")\
            end\
        end\
    end\
    term.setBackgroundColor(bg)\
    if sel == -1 then\
        term.setTextColor(colors.orange)\
    else\
        term.setTextColor(fg)\
    end\
    local ry = y+#fr*7-1\
    lUtils.border(1,ry,w,ry+4,nil,1)\
    term.setCursorPos(3,ry+2)\
    if sel3 == -1 then\
        term.setTextColor(fg)\
    else\
        term.setTextColor(colors.white)\
    end\
    term.write(\"+ New\")\
    pos[-1] = {x1=2,y1=ry+1,x2=w-1,y2=ry+3}\
end\
local y = 2\
render(y)\
while true do\
    local e = {os.pullEvent()}\
    local w,h = term.getSize()\
    for k,v in pairs(sl.frames) do\
        v.id = k\
    end\
    if e[1] == \"mouse_move\" or e[1] == \"mouse_up\" or e[1] == \"mouse_click\" or e[1] == \"mouse_drag\" or e[1] == \"mouse_scroll\" then\
        local osel = sel\
        local osel2 = sel2\
        local osel3 = sel3\
        if e[1] == \"mouse_move\" then\
            sel = nil\
        end\
        if drag and e[1] == \"mouse_drag\" then\
            drag.x,drag.y = e[3],e[4]\
            render(y)\
        end\
        if e[3] and e[4] and e[3] >= 1 and e[4] >= 1 and e[3] <= w and e[4] <= h then\
            if e[1] == \"mouse_scroll\" and (y-e[2]) <= 2 and (pos[-1].y2-e[2]) >= h-1 then\
                y = y-e[2]\
                render(y)\
            end\
            for k,v in pairs(pos) do\
                if e[3] >= v.x1 and e[4] >= v.y1 and e[3] <= v.x2 and e[4] <= v.y2 then\
                    if e[1] == \"mouse_move\" or e[1] == \"mouse_up\" then\
                        sel = k\
                    end\
                    if drag and e[1] == \"mouse_drag\" then\
                        if drag.id ~= k and k > 0 then\
                            if not sl.frames[drag.id] then\
                                error(\"No sl.frames[drag.id (\"..tostring(drag.id)..\")]\")\
                            elseif not sl.frames[k] then\
                                error(\"No sl.frames[k (\"..tostring(k)..\")]\")\
                            end\
                            sl.frames[drag.id],sl.frames[k] = sl.frames[k],sl.frames[drag.id]\
                            if not sl.frames[drag.id] then\
                                error(\"No sl.frames[drag.id (\"..tostring(drag.id)..\")]\")\
                            elseif not sl.frames[k] then\
                                error(\"No sl.frames[k (\"..tostring(k)..\")]\")\
                            end\
                            sl.frames[drag.id].id = drag.id\
                            sl.frames[k].id = k\
                            drag.id = k\
                            sel = k\
                            render(y)\
                            os.queueEvent(\"squarepaint_preview\")\
                        end\
                    elseif sel == k and (e[1] == \"mouse_click\" or e[1] == \"mouse_up\") then\
                        if k >= 1 then\
                            if e[3] == v.x2 and e[4] == v.y1 and #fr > 1 then -- click x symbol\
                                if e[1] == \"mouse_click\" then\
                                    sel3 = 1\
                                elseif e[1] == \"mouse_up\" and sel3 == 1 then\
                                    if sl.frame == fr[k] then\
                                        local nframe\
                                        if fr[k+1] then\
                                            nframe = fr[k+1]\
                                        else\
                                            nframe = fr[k-1]\
                                        end\
                                        s.var.cvs = nframe[1]\
                                        sl.frame = nframe\
                                    end\
                                    table.remove(fr,k)\
                                    render(y)\
                                    s.var.redraw()\
                                    os.queueEvent(\"squarepaint_preview\")\
                                end\
                            elseif e[3] == v.x1 and e[4] == v.y2 and #fr > 1 then\
                                if e[1] == \"mouse_click\" then\
                                    sel3 = 2\
                                    drag = {id=k,x=e[3],y=e[4]}\
                                end\
                            elseif e[3] == v.x2 and e[4] == v.y2 then\
                                if e[1] == \"mouse_click\" then\
                                    sel3 = 3\
                                elseif e[1] == \"mouse_up\" and sel3 == 3 then\
                                    table.insert(fr,k+1,lUtils.instantiate(fr[k]))\
                                    sl.frame = fr[k+1]\
                                    sl.frame.preview = nil\
                                    s.var.cvs = fr[k+1][1]\
                                    render(y)\
                                    s.var.redraw()\
                                    os.queueEvent(\"squarepaint_preview\")\
                                end\
                            elseif sl.frame ~= fr[k] then\
                                if e[1] == \"mouse_click\" then\
                                    sel3 = 0\
                                elseif e[1] == \"mouse_up\" and sel3 == 0 then\
                                    sl.frame = fr[k]\
                                    s.var.cvs = fr[k][1]\
                                    render(y)\
                                    s.var.redraw()\
                                    os.queueEvent(\"squarepaint_preview\")\
                                end\
                            end\
                        else\
                            if e[1] == \"mouse_click\" then\
                                sel3 = -1\
                            elseif e[1] == \"mouse_up\" and sel3 == -1 then\
                                table.insert(fr,{{}})\
                                sl.frame = fr[#fr]\
                                s.var.cvs = fr[#fr][1]\
                                render(y)\
                                s.var.redraw()\
                                os.queueEvent(\"squarepaint_preview\")\
                            end\
                        end\
                    end\
                    break\
                end\
            end\
        end\
        if e[1] == \"mouse_up\" then\
            sel2 = nil\
            sel3 = nil\
            drag = nil\
            local o = s.var.cvsobj\
            local tx,ty = e[3]+(self.x1-1),e[4]+(self.y1-1)\
            if tx >= o.x1 and ty >= o.y1 and tx <= o.x2 and ty <= o.y2 then\
                render(y)\
                os.queueEvent(\"squarepaint_preview\")\
            end\
        end\
        if sel ~= osel or sel2 ~= osel2 or sel3 ~= osel3 then\
            render(y)\
        end\
    elseif e[1] == \"key\" then\
        if lUtils.isHolding(keys.leftCtrl) then\
            if e[2] == keys.up then\
                s.var.h = s.var.h-1\
            elseif e[2] == keys.down then\
                s.var.h = s.var.h+1\
            elseif e[2] == keys.right then\
                s.var.w = s.var.w+1\
            elseif e[2] == keys.left then\
                s.var.w = s.var.w-1\
            end\
            os.queueEvent(\"squarepaint_preview\")\
        elseif e[2] == keys.up and sl.frame.id > 1 then\
            sl.frame = sl.frames[sl.frame.id-1]\
            s.var.cvs = sl.frame[1]\
            render(y)\
            s.var.redraw()\
            os.queueEvent(\"squarepaint_preview\")\
        elseif e[2] == keys.down and sl.frames[sl.frame.id+1] then\
            sl.frame = sl.frames[sl.frame.id+1]\
            s.var.cvs = sl.frame[1]\
            render(y)\
            s.var.redraw()\
            os.queueEvent(\"squarepaint_preview\")\
        end\
    end\
end\
end\
local ok,err = pcall(dostuff)\
if not ok then lOS.thedebugerrorstuff = err term.setBackgroundColor(colors.black) term.clear() end",
    name = "framelist.lua",
  },
  [ "tool.lua" ] = {
    id = 8,
    content = "local s = shapescape.getSlide()\
if not s.var.toolobjs then s.var.toolobjs = {} end\
table.insert(s.var.toolobjs,self)",
    name = "tool.lua",
  },
  [ "squarerender.lua" ] = {
    id = 1,
    content = "term.setTextColor(self.border.color)\
term.setBackgroundColor(colors.lightGray)\
lUtils.border(self.x1,self.y1,self.x2,self.y2,\"transparent\",2)",
    name = "squarerender.lua",
  },
  [ "canvas.lua" ] = {
    id = 0,
    content = "local function setBackgroundColor(t,c)\
	if not c then error(\"No value\",2)\
	elseif c == -1 then error(\"Invalid value '-1'\",2)\
	else\
		t.setBackgroundColor(c)\
	end\
end\
local function setTextColor(t,c)\
	if not c then error(\"No value\",2)\
	else\
		t.setTextColor(c)\
	end\
end\
function thething(...)\
local tArgs = {...}\
local obg = colors.gray\
local ofg = colors.black\
local sbg = colors.lightGray\
local sfg = colors.gray\
--local selcol = colors.red\
local s = shapescape.getSlide()\
local sl = shapescape.getSlides()\
if not s.var then s.var = {} end\
s.var.colsel = 1\
s.var.colsel2 = 0\
s.var.w = 32\
s.var.h = 32\
s.var.cvs = {}\
s.var.cvsobj = self\
sl.frames = {{s.var.cvs,id=1}}\
sl.chars = {{}}\
sl.frame = sl.frames[1]\
sl.invalid = {}\
do\
	local orig = {}\
	setmetatable(sl.invalid,{__index=function(t,k) if not orig[k] then orig[k] = {} end return orig[k] end})\
end\
local cols = {}\
local colref = {}\
for k,v in pairs(colors) do\
	if type(v) == \"number\" then\
		colref[v] = k\
	end\
end\
for i=0,15 do\
	cols[i+1] = colref[2^i]\
end\
cols[0] = 0\
s.var.cols = cols\
_G.debugcols = cols\
local selpix\
setBackgroundColor(term,obg)\
setTextColor(term,ofg)\
local w,h = term.getSize()\
function swap()\
	local bg = term.getBackgroundColor()\
	local fg = term.getTextColor()\
	setBackgroundColor(term,fg)\
	setTextColor(term,bg)\
end\
local cvs = s.var.cvs\
if tArgs[1] and fs.exists(tArgs[1]) then\
	local tCvs = textutils.unserialize(lUtils.fread(tArgs[1]))\
	if tCvs then cvs = tCvs end\
end\
local sel = {0,0}\
local function bterm(b,t)\
	b.bg = t.getBackgroundColor()\
	b.fg = t.getTextColor()\
	b.x,b.y = t.getCursorPos()\
	b.oldTerm = lUtils.instantiate(t)\
	-- hm maybe dont\
end\
local function drawPixel(x,y,sel)\
	if ((x-1)%4 < 2 and (y-1)%6 < 3) or ((x-1)%4 >= 2 and (y-1)%6 >= 3) then -- change in drawPixel too\
		obg = colors.black\
		ofg = colors.black\
	else\
		obg = colors.gray\
		ofg = colors.black\
	end\
	if not cvs[y] then\
		cvs[y] = {}\
	end\
	if cvs[y][x] == 0 then\
		if sel then\
			if y%2 == 0 then\
				setBackgroundColor(term,sbg)\
				setTextColor(term,sfg)\
			else\
				setBackgroundColor(term,sfg)\
				setTextColor(term,sbg)\
			end\
		else\
			if y%2 == 0 then\
				setBackgroundColor(term,obg)\
				setTextColor(term,ofg)\
			else\
				setBackgroundColor(term,ofg)\
				setTextColor(term,obg)\
			end\
		end\
	else\
		if not cvs[y][x] then\
			error(\"No cvs[\"..y..\"][\"..x..\"]\",2)\
		end\
		setBackgroundColor(term,cvs[y][x])\
		setTextColor(term,cvs[y][x])\
	end\
	if x%2 == 0 then\
		term.setCursorPos(math.floor(x*1.5)-1,y)\
		if sel or cvs[y][x] ~= 0 or cvs[y][x-1] ~= 0 then\
			local tfg,tbg = term.getTextColor(),term.getBackgroundColor()\
			if not cvs[y][x-1] then\
				cvs[y][x-1] = 0\
			end\
			if cvs[y][x-1] ~= 0 then\
				setTextColor(term,cvs[y][x-1])\
			else\
				setTextColor(term,obg)\
			end\
			if cvs[y][x] ~= 0 then\
				setBackgroundColor(term,cvs[y][x])\
			elseif sel then\
				setBackgroundColor(term,sbg)\
			else\
				setBackgroundColor(term,obg)\
			end\
			term.write(\"\\149\")\
			setBackgroundColor(term,tbg)\
			setTextColor(term,tfg)\
		else\
			term.write(\"\\153\")\
		end\
	else\
		term.setCursorPos(math.floor(x*1.5),y)\
	end\
	if cvs[y][x] ~= 0 and sel then\
		if cvs[y][x] == colors.lightGray then\
			setTextColor(term,colors.white)\
		else\
			setTextColor(term,colors.lightGray)\
		end\
		if x%2 == 0 then\
			term.write(\"\\132\")\
		else\
			term.write(\"\\136\")\
		end\
	else\
		term.write(\"\\153\")\
	end\
	if x%2 == 1 and cvs[y][x+1] then\
		if sel or cvs[y][x] ~= 0 or cvs[y][x+1] ~= 0 then\
			if cvs[y][x+1] ~= 0 then\
				setBackgroundColor(term,cvs[y][x+1])\
			else\
				setBackgroundColor(term,obg)\
			end\
			if cvs[y][x] ~= 0 then\
				setTextColor(term,cvs[y][x])\
			elseif sel then\
				setTextColor(term,sbg)\
			else\
				setTextColor(term,obg)\
			end\
			term.write(\"\\149\")\
		else\
			term.write(\"\\153\")\
		end\
	end\
end\
\
function drawCvs()\
	cvs = s.var.cvs\
	local w,h = term.getSize()\
	setBackgroundColor(term,colors.gray)\
	term.clear()\
	local colsel = s.var.colsel\
	local selcol = colors[cols[colsel]]\
	for y=1,s.var.h do\
		if not cvs[y] then cvs[y] = {} end\
		term.setCursorPos(1,y)\
		if #cvs[y] > s.var.w then\
			for tx=s.var.w+1,#cvs[y] do\
				cvs[y][tx] = nil\
			end\
		end\
		local x = 1\
		while ({term.getCursorPos()})[1] <= w and x <= s.var.w do\
			if not cvs[y][x] then cvs[y][x] = 0 end\
			if cvs[y][x] == -1 then\
				if sl.chars[sl.frame.id] and sl.chars[sl.frame.id][((x+1)/2)..\",\"..((y+2)/3)] then\
					bigfont.bigBlit(table.unpack(sl.chars[sl.frame.id][((x+1)/2)..\",\"..((y+2)/3)]))\
				end\
				x = x+2\
				--term.setCursorPos(x,y)\
			else\
				local oobg = term.getBackgroundColor()\
				local oofg = term.getTextColor()\
				if ((x-1)%4 < 2 and (y-1)%6 < 3) or ((x-1)%4 >= 2 and (y-1)%6 >= 3) then -- alternating px colors\
					obg = colors.black\
					ofg = colors.black\
				else\
					obg = colors.gray\
					ofg = colors.black\
				end\
				if y%2 == 0 then\
					setBackgroundColor(term,obg)\
					setTextColor(term,ofg)\
				else\
					setBackgroundColor(term,ofg)\
					setTextColor(term,obg)\
				end\
				if cvs[y][x] ~= 0 then\
					setBackgroundColor(term,cvs[y][x])\
					term.write(\" \")\
					swap()\
				else\
					term.write(\"\\153\")\
				end\
				x = x+1\
				if x <= s.var.w then\
					if not cvs[y][x] then cvs[y][x] = 0 end\
					if cvs[y][x] ~= 0 then\
						setBackgroundColor(term,cvs[y][x])\
					end\
					if cvs[y][x] ~= 0 or cvs[y][x-1] ~= 0 then\
						if cvs[y][x] == 0 then\
							setBackgroundColor(term,obg)\
						elseif cvs[y][x-1] == 0 then\
							setTextColor(term,obg)\
						end\
						term.write(\"\\149\")\
					else\
						term.write(\"\\153\")\
					end\
					setTextColor(term,oobg)\
					if cvs[y][x] ~= 0 then\
						term.write(\" \")\
						setBackgroundColor(term,oofg)\
					else\
						if y%2 == 0 then\
							setBackgroundColor(term,obg)\
							setTextColor(term,ofg)\
						else\
							setBackgroundColor(term,ofg)\
							setTextColor(term,obg)\
						end\
						term.write(\"\\153\")\
					end\
					x = x+1\
				end\
			end\
		end\
		swap()\
	end\
	if #cvs > s.var.h then\
		for ty=s.var.h+1,#cvs do\
			cvs[ty] = nil\
		end\
	end\
	setBackgroundColor(term,obg)\
	setTextColor(term,ofg)\
end\
drawCvs()\
function collide(e)\
	local e = lUtils.instantiate(e)\
	e[3] = e[3]+(self.x1-1)\
	e[4] = e[4]+(self.y1-1)\
	for t=#s.objs,1,-1 do\
		local o = s.objs[t]\
		if o ~= self and e[3] >= o.x1 and e[4] >= o.y1 and e[3] <= o.x2 and e[4] <= o.y2 then\
			return true\
		elseif o == self then\
			return false\
		end\
	end\
end\
local movepos\
local function move(x,y,commit)\
	local cvs = s.var.cvs\
	local ox,oy = x-(movepos.x),y-(movepos.y)\
	movepos.ox,movepos.oy = movepos.ox+ox,movepos.oy+oy\
	local ocvs = lUtils.instantiate(cvs)\
	local minY = math.min(1,1+movepos.oy)\
	local maxY = math.max(s.var.h,s.var.h+movepos.oy)\
	local minX = math.min(1,1+movepos.ox)\
	local maxX = math.max(s.var.w,s.var.w+movepos.ox)\
	for y=minY,maxY do\
		if not ocvs[y-oy] then\
			ocvs[y-oy] = {}\
		end\
		for x=minX,maxX do\
			if not ocvs[y-oy][x-ox] then\
				ocvs[y-oy][x-ox] = 0\
			end\
			if commit and (x < 1 or x > s.var.w or y < 1 or y > s.var.h) then\
				if cvs[y] then\
					cvs[y][x] = nil\
					if y < 1 or y > s.var.h then\
						cvs[y] = nil\
					end\
				end\
			else\
				if not cvs[y] then\
					cvs[y] = {}\
				end\
				cvs[y][x] = ocvs[y-oy][x-ox]\
			end\
		end\
	end\
	s.var.changed = true\
end\
s.var.collide = collide\
local redraw = false\
function s.var.redraw()\
	redraw = true\
end\
\
while true do\
	local oldcol = s.var.colsel\
	local oldcol2 = s.var.colsel2\
	local ow,oh = term.getSize()\
	local e = {os.pullEvent()}\
	if redraw then\
		setBackgroundColor(term,obg)\
		setTextColor(term,ofg)\
		drawCvs()\
		redraw = false\
	end\
	cvs = s.var.cvs\
	if oldcol ~= s.var.colsel or oldcol2 ~= s.var.colsel2 then\
		setBackgroundColor(term,obg)\
		setTextColor(term,ofg)\
		drawCvs()\
	end\
	local w,h = term.getSize()\
	if w ~= ow or h ~= oh then\
		setBackgroundColor(term,obg)\
		setTextColor(term,ofg)\
		drawCvs()\
	end\
	local selcol = colors[cols[s.var.colsel]] or 0\
	local selcol2 = colors[cols[s.var.colsel2]] or 0\
	if (e[1] == \"mouse_click\" or e[1] == \"mouse_drag\") and not collide(e) then\
		sel = {math.floor(((e[3]+1)/3)*2),e[4]}\
		local x,y = math.floor(((e[3]+1)/3)*2),e[4]\
		local tool = s.var.tools[s.var.tool]\
		if cvs[y] and cvs[y][x] then\
			if tool == \"Pencil\" or tool == \"Eraser\" or (tool == \"Dither\" and ((x%2 == 0 and y%2 == 0) or (x%2 == 1 and y%2 == 1))) then\
				if tool == \"Eraser\" then\
					cvs[y][x] = 0\
				elseif e[2] == 1 then\
					cvs[y][x] = selcol\
				else\
					cvs[y][x] = selcol2\
				end\
				if selpix and cvs[selpix[2]] and cvs[selpix[2]][selpix[1]] then\
					drawPixel(selpix[1],selpix[2],false)\
					selpix = nil\
					s.var.mousepos = nil\
				end\
				s.var.changed = true\
			elseif tool == \"Color Picker\" then\
				if e[1] == \"mouse_click\" then\
					if e[2] == 1 then\
						selcol = cvs[y][x]\
						if selcol == 0 then\
							s.var.colsel = 0\
						else\
							for c=1,#cols do\
								if colors[cols[c]] == selcol then\
									s.var.colsel = c\
								end\
							end\
						end\
					elseif e[2] == 2 then\
						selcol2 = cvs[y][x]\
						if selcol2 == 0 then\
							s.var.colsel2 = 0\
						else\
							for c=1,#cols do\
								if colors[cols[c]] == selcol2 then\
									s.var.colsel2 = c\
								end\
							end\
						end\
					end\
					s.var.tool = 1\
				end\
			elseif tool == \"Fill\" and e[1] == \"mouse_click\" then\
				local scol\
				if e[2] == 1 then\
					scol = selcol\
				else\
					scol = selcol2\
				end\
				local fcol = cvs[y][x]\
				local frontier = {{x,y}}\
				local directions = {{1,0},{-1,0},{0,1},{0,-1}}\
				if fcol ~= scol then\
					cvs[y][x] = scol\
					while #frontier > 0 do\
						local nfrontier = {}\
						for k,v in ipairs(frontier) do\
							for dir=1,#directions do\
								local d = directions[dir]\
								local cx,cy = v[1]+d[1],v[2]+d[2]\
								if cvs[cy] and cvs[cy][cx] and cvs[cy][cx] == fcol then\
									table.insert(nfrontier,{cx,cy})\
									cvs[cy][cx] = scol\
								end\
							end\
						end\
						frontier = nfrontier\
					end\
					s.var.changed = true\
				end\
				drawCvs()\
			elseif tool == \"Move\" then\
				if e[1] == \"mouse_click\" then\
					movepos = {x=x,y=y,ox=0,oy=0}\
				elseif e[1] == \"mouse_drag\" and movepos then\
					move(x,y)\
					drawCvs()\
					movepos.x,movepos.y = x,y\
				end\
			end\
			drawPixel(x,y)\
			sl.frame.preview = nil\
		end\
	elseif e[1] == \"mouse_move\" or e[1] == \"mouse_up\" and e[3] and e[4] then\
		local x,y = math.floor(((e[3]+1)/3)*2),e[4]\
		if e[1] == \"mouse_up\" and movepos then\
			move(x,y,true)\
			drawCvs()\
			movepos = nil\
		elseif e[1] == \"mouse_move\" then\
			movepos = nil\
		end\
		if selpix and cvs[selpix[2]] and cvs[selpix[2]][selpix[1]] then\
			local tx,ty = selpix[1],selpix[2]\
			drawPixel(tx,ty,false)\
		end\
		if cvs[y] and cvs[y][x] then\
			drawPixel(x,y,true)\
			selpix = {x,y}\
			s.var.mousepos = selpix\
		end\
	elseif e[1] == \"mouse_scroll\" and e[3] >= 1 and e[4] >= 1 and e[3] <= w and e[4] <= h then\
		if e[2] == 1 then\
			if cols[s.var.colsel+1] then\
				s.var.colsel = s.var.colsel+1\
			else\
				s.var.colsel = 1\
			end\
		else\
			if cols[s.var.colsel-1] then\
				s.var.colsel = s.var.colsel-1\
			else\
				s.var.colsel = #cols\
			end\
		end\
		setBackgroundColor(term,obg)\
		setTextColor(term,ofg)\
		drawCvs()\
	end\
end\
end\
local ok,err = pcall(thething)\
if not ok then\
	setBackgroundColor(term,colors.black)\
	term.clear()\
	setTextColor(term,colors.red)\
	term.setCursorPos(1,1)\
	print(err)\
	lOS.somestupiderror = err\
end",
    name = "canvas.lua",
  },
  [ "ac_txt.lua" ] = {
    id = 23,
    content = "local sl = shapescape.getSlides()\
local cols = {}\
for k,v in pairs(colors) do\
	if type(v) == \"number\" then\
		cols[math.log(v,2)] = k\
	end\
end\
local cCol\
while true do\
	if sl.colsel ~= cCol then\
		self.txt = \"Adjusting color \"..(sl.colsel-1)..\" (\"..cols[sl.colsel-1]..\")\"\
		cCol = sl.colsel\
	end\
end",
    name = "ac_txt.lua",
  },
  [ "new.lua" ] = {
    id = 21,
    content = "lOS.execute(LevelOS.self.window.path)",
    name = "new.lua",
  },
  [ "save.lua" ] = {
    id = 19,
    content = "local function ex()\
local sl = shapescape.getSlides()\
local s = sl[1]\
if lUtils.isHolding(keys.leftShift) or not s.var.path then\
    local a = {lUtils.inputbox(\"Squarepaint\",\"Please input a new file path to save the file:\",27,11,{\"Save\",\"Cancel\"})}\
    if a[2] and a[4] == \"Save\" and a[1] ~= \"\" then\
        local filetype = lUtils.getFileType(a[1])\
        if filetype == \"\" then\
            a[1] = a[1]..\".bimg\"\
        end\
        if fs.exists(a[1]) then\
            if fs.isDir(a[1]) then\
                lUtils.popup(\"Error\",\"This filepath leads to a folder.\",23,9,{\"Cancel\"})\
                return\
            elseif fs.isReadOnly(a[1]) then\
                lUtils.popup(\"Error\",\"This filepath is read-only.\",23,9,{\"Cancel\"})\
                return\
            else\
                local b = {lUtils.popup(\"Squarepaint\",\"This filepath already exists. Do you want to overwrite it?\",27,11,{\"Overwrite\",\"Cancel\"})}\
                if not (b[1] and b[3] == \"Overwrite\") then\
                    return\
                end\
            end\
        end\
    else\
        return\
    end\
    s.var.path = a[1]\
end\
local p = s.var.path\
local filetype = lUtils.getFileType(p)\
if filetype == \".limg\" or filetype == \".bimg\" then\
    local export = {}\
    for k,v in pairs(sl.frames) do\
        export[k] = s.var.genSpr(v[1])\
    end\
    lUtils.asset.save(export,p)\
elseif filetype == \".asqr\" then\
    for k,v in pairs(sl.frames) do\
        v.preview = nil\
    end\
    lUtils.asset.save(sl.frames,p)\
elseif filetype == \".sqr\" then\
    if #sl.frames > 1 then\
        lUtils.popup(\"Error\",\"This file format does not support multiple frames.\",23,9,{\"Cancel\"})\
        return\
    else\
        lUtils.asset.save(sl.frames[1][1],p)\
    end\
end\
s.var.changed = false\
lOS.notification(\"Squarepaint\",\"Sprite saved to \"..p..\"!\")\
end\
local ok,err = pcall(ex)\
if not ok then\
    lUtils.popup(\"Error\",err,40,20,{\"OK\"})\
end",
    name = "save.lua",
  },
  [ "fpsslider.lua" ] = {
    id = 11,
    content = "local x = 1\
local w,h = term.getSize()\
local sel = false\
local function render()\
    term.setBackgroundColor(colors.gray)\
    term.setTextColor(colors.lightGray)\
    term.setCursorPos(1,1)\
    term.write(string.rep(\"\\140\",w))\
    term.setCursorPos(x,1)\
    if sel then\
        term.setTextColor(colors.white)\
    else\
        term.setTextColor(colors.gray)\
    end\
    term.setBackgroundColor(colors.lightGray)\
    term.write(\"\\7\")\
end\
render()\
local s = shapescape.getSlide()\
s.var.fps = (x-1)*2\
while true do\
    local e = {os.pullEvent()}\
    if e[1] == \"mouse_click\" or e[1] == \"mouse_drag\" then\
        if e[3] >= 1 and e[3] <= w and e[4] == 1 then\
            if e[1] == \"mouse_click\" then\
                sel = true\
                x = e[3]\
                render()\
            elseif e[1] == \"mouse_drag\" and sel then\
                x = e[3]\
                render()\
            end\
        end\
        s.var.fps = (x-1)*2\
    elseif e[1] == \"mouse_up\" and sel then\
        sel = false\
        render()\
    end\
end",
    name = "fpsslider.lua",
  },
  [ "title.lua" ] = {
    id = 10,
    content = "local s = shapescape.getSlide()\
term.setBackgroundColor(self.color)\
term.clear()\
term.setTextColor(self.border.color)\
local otxt\
os.sleep(0.5)\
while true do\
    local e = {os.pullEvent()}\
    local txt = \"\"\
    if s.var.path then\
        txt = lUtils.getFileName(s.var.path)\
    else\
        txt = \"New Sprite\"\
    end\
    if s.var.changed then\
        txt = txt..\"*\"\
    end\
    if txt ~= otxt or e[1] == \"term_resize\" then\
        term.clear()\
        bigfont.writeOn(term.current(),1,txt)\
        LevelOS.setTitle(txt..\" - Squarepaint\")\
        otxt = txt\
    end\
end",
    name = "title.lua",
  },
  [ "seltool.lua" ] = {
    id = 7,
    content = "local s = shapescape.getSlide()\
local sl = shapescape.getSlides()\
s.var.tool = 1\
if not s.var.tools then\
    s.var.tools = {\"Pencil\",\"Line\",\"Fill\",\"Eraser\",\"Dither\",\"Color Picker\",\"Move\",\"Select\",\"Mirror\",\"Rotate\",\"Center\",\"Settings\",\"Resize\",\"Save\",\"Export\",\"Open\"}\
end\
local keybinds = {[keys.p]=1,[keys.l]=2,[keys.b]=3,[keys.e]=4,[keys.d]=5,[keys.o]=6,[keys.m]=7,[keys.s]=8}\
local shortcuts = {[keys.s]=13}\
if not s.var.toolobjs then\
    s.var.toolobjs = {}\
end\
local function mirror(cvs)\
    local ocvs = lUtils.instantiate(cvs)\
    for y=1,s.var.h do\
        if not ocvs[y] then\
            ocvs[y] = {}\
        end\
        for x=1,s.var.w do\
            if not ocvs[y][x] then\
                ocvs[y][x] = 0\
            end\
            if lUtils.isHolding(keys.leftCtrl) then\
                cvs[s.var.h-(y-1)][x] = ocvs[y][x]\
            else\
                cvs[y][s.var.w-(x-1)] = ocvs[y][x]\
            end\
        end\
    end\
end\
local function rotate(cvs)\
    local ocvs = lUtils.instantiate(cvs)\
    for y=1,s.var.h do\
        if not ocvs[y] then\
            ocvs[y] = {}\
        end\
        for x=1,s.var.w do\
            if not ocvs[y][x] then\
                ocvs[y][x] = 0\
            end\
            cvs[s.var.h-(x-1)][y] = ocvs[y][x]\
        end\
    end\
end\
while true do\
    local e = {os.pullEvent()}\
    if (e[1] == \"mouse_click\" or e[1] == \"mouse_up\" or e[1] == \"mouse_move\") and e[3] and e[4] then\
        local psel = s.var.tool\
        for k,v in pairs(s.var.toolobjs) do\
            if e[3] >= v.x1 and e[4] >= v.y1 and e[3] <= v.x2 and e[4] <=  v.y2 then\
                if e[1] == \"mouse_click\" then\
                    v.sel = true\
                elseif e[1] == \"mouse_up\" and v.sel then\
                    if k <= 8 then\
                        s.var.tool = k\
                    else\
                        local tool = s.var.tools[k]\
                        if tool == \"Mirror\" then\
                            if lUtils.isHolding(keys.leftShift) then\
                                for k,v in ipairs(sl.frames) do\
                                    mirror(v[1])\
                                end\
                            else\
                                mirror(sl.frame[1])\
                            end\
                            s.var.redraw()\
                            os.queueEvent(\"squarepaint_preview\")\
                        elseif tool == \"Rotate\" then\
                            if lUtils.isHolding(keys.leftShift) then\
                                for k,v in ipairs(sl.frames) do\
                                    rotate(v[1])\
                                end\
                            else\
                                rotate(sl.frame[1])\
                            end\
                            s.var.redraw()\
                            os.queueEvent(\"squarepaint_preview\")\
                        end\
                    end\
                end\
            end\
            if s.var.tool == k then\
                s.var.toolobjs[psel].border.color = colors.lightGray\
                v.border.color = colors.orange\
            else\
                v.border.color = colors.lightGray\
            end\
            if e[1] == \"mouse_up\" then\
                v.sel = nil\
            end\
            if v.sel then\
                v.color = colors.lightGray\
            else\
                v.color = colors.gray\
            end\
        end\
    elseif e[1] == \"key\" or e[1] == \"key_up\" then\
        local kb\
        if lUtils.isHolding(keys.leftCtrl) then\
            kb = shortcuts\
        else\
            kb = keybinds\
        end\
        if kb[e[2]] then\
            local o = s.var.toolobjs[kb[e[2]]+2]\
            if e[1] == \"key\" then\
                os.queueEvent(\"mouse_click\",1,o.x1,o.y1)\
            elseif e[1] == \"key_up\" then\
                os.queueEvent(\"mouse_up\",1,o.x1,o.y1)\
            end\
        end\
    end\
end",
    name = "seltool.lua",
  },
  [ "export.lua" ] = {
    id = 20,
    content = "local function ex()\
local sl = shapescape.getSlides()\
local s = sl[1]\
local a = {lUtils.inputbox(\"Squarepaint\",\"Please input a new file path to export the file:\",27,11,{\"Save\",\"Cancel\"})}\
if a[2] and a[4] == \"Save\" and a[1] ~= \"\" then\
    if fs.exists(a[1]) then\
        if fs.isDir(a[1]) then\
            lUtils.popup(\"Error\",\"This filepath leads to a folder.\",23,9,{\"Cancel\"})\
            return\
        elseif fs.isReadOnly(a[1]) then\
            lUtils.popup(\"Error\",\"This filepath is read-only.\",23,9,{\"Cancel\"})\
            return\
        else\
            local b = {lUtils.popup(\"Squarepaint\",\"This filepath already exists. Do you want to overwrite it?\",27,11,{\"Overwrite\",\"Cancel\"})}\
            if not (b[1] and b[3] == \"Overwrite\") then\
                return\
            end\
        end\
    end\
else\
    return\
end\
local p = a[1]\
local filetype = lUtils.getFileType(p)\
if filetype == \"\" then\
    filetype = \".bimg\"\
end\
if filetype == \".limg\" or filetype == \".bimg\" then\
    local export = {}\
    for k,v in pairs(sl.frames) do\
        export[k] = s.var.genSpr(v[1])\
    end\
    lUtils.asset.save(export,p)\
elseif filetype == \".asqr\" then\
    for k,v in pairs(sl.frames) do\
        v.preview = nil\
    end\
    lUtils.asset.save(sl.frames,p)\
elseif filetype == \".sqr\" then\
    if #sl.frames > 1 then\
        lUtils.popup(\"Error\",\"This file format does not support multiple frames.\",23,9,{\"Cancel\"})\
        return\
    else\
        lUtils.asset.save(sl.frames[1][1],p)\
    end\
end\
lOS.notification(\"Squarepaint\",\"Sprite exported to \"..p..\"!\")\
end\
local ok,err = pcall(ex)\
if not ok then\
    lUtils.popup(\"Error\",err,40,20,{\"OK\"})\
end",
    name = "export.lua",
  },
  [ "sizeinfo.lua" ] = {
    id = 18,
    content = "local s = shapescape.getSlide()\
if s.var then\
    self.txt = \"[\"..s.var.w..\"x\"..s.var.h..\"]\"\
    if s.var.mousepos then\
        self.txt = self.txt..\" \"..s.var.mousepos[1]..\":\"..s.var.mousepos[2]\
    end\
end",
    name = "sizeinfo.lua",
  },
  [ "centercanvas.lua" ] = {
    id = 5,
    content = "local s = shapescape.getSlide()\
if not s.var or not s.var.cvsobj then return end\
local x,y = self.x1,self.y1\
local w,h = self.x2-(x-1),self.y2-(y-1)\
local o = s.var.cvsobj\
local w1,h1 = math.ceil(s.var.w*1.5),s.var.h\
local x1,y1 = (x-1)+math.ceil(w/2)-math.floor(w1/2),(y-1)+math.ceil(h/2)-math.floor(h1/2)\
o.x1,o.y1 = x1,y1\
o.x2,o.y2 = x1+(w1-1),y1+(h1-1)",
    name = "centercanvas.lua",
  },
  [ "previewcolors.lua" ] = {
    id = 14,
    content = "term.setCursorPos(1,1)\
for i = 0, 15 do\
    if i < 15 then\
        term.blit(\"\\143\",lUtils.toBlit(2^i),\"8\")\
    else\
        term.blit(\"\\143\",lUtils.toBlit(2^i),\"1\")\
    end\
end\
local s = shapescape.getSlide()\
local w,h = term.getSize()\
while true do\
    local e = {os.pullEvent()}\
    if e[1] == \"mouse_click\" and e[3] >= 1 and e[3] <= w and e[4] == 1 then\
        s.var.previewcolor = 2^(e[3]-1)\
        os.queueEvent(\"squarepaint_preview\")\
        term.setCursorPos(1,1)\
        for i = 0, 15 do\
            if s.var.previewcolor == 2^i then\
                term.blit(\"\\143\",lUtils.toBlit(2^i),\"1\")\
            else\
                term.blit(\"\\143\",lUtils.toBlit(2^i),\"8\")\
            end\
        end\
    end\
end",
    name = "previewcolors.lua",
  },
  [ "init.lua" ] = {
    id = 9,
    content = "os.loadAPI(\"blittle\")\
LevelOS.maximize()\
local sl = shapescape.getSlides()\
local s = sl[1]\
local function toPixels(char)\
	local n = char:byte()\
	local t = {}\
	for i = 0, 4 do t[i+1] = bit32.btest(n, 2^i) end\
	t[6] = false\
	return t\
end\
local function loadImage(fp)\
	if fp and fs.exists(fp) then\
		-- check for changes\
		local f = lUtils.asset.load(fp)\
		for t=1,#sl.frames do\
			sl.frames[t] = nil\
		end\
		local fType = lUtils.getFileType(fp)\
		if fType == \".asqr\" then\
			s.var.w = #f[1][1]\
			s.var.h = #f[1][1][1]\
			for t=1,#f do\
				sl.frames[t] = lUtils.instantiate(f[t])\
				sl.frames[t].id = t\
			end\
		elseif fType == \".sqr\" then\
			s.var.w = #f\
			s.var.h = #f[1]\
			sl.frames[1] = {id=1,lUtils.instantiate(f)}\
		elseif fType == \".limg\" or fType == \".bimg\" then\
			s.var.h = #f[1]*3\
			s.var.w = #f[1][1][1]*2\
			for t=1,#f do\
				sl.frames[t] = {id=t,{}}\
				sl.chars[t] = {}\
				local cvs = sl.frames[t][1]\
				for y=1,s.var.h do\
					cvs[y] = {}\
					for x=1,s.var.w do\
						cvs[y][x] = 0\
					end\
				end\
				for y=1,#f[t] do\
					for x=1,#f[t][y][1] do\
						local cols = {}\
						local ch = f[t][y][1]:sub(x,x)\
						local fg = f[t][y][2]:sub(x,x)\
						local bg = f[t][y][3]:sub(x,x)\
						cols[true] = lUtils.toColor(fg) or 0\
						cols[false] = lUtils.toColor(bg) or 0\
						if (ch:byte() >= 128 and ch:byte() <= 160) or ch == \" \" then\
							local c = toPixels(ch)\
							for a=1,#c do\
								if not cvs[(y-1)*3+math.ceil(a/2)] then\
									error(\"No cvs[\"..((y-1)*3+math.ceil(a/2))..\"] on y=\"..y..\" and a=\"..a)\
								end\
								cvs[(y-1)*3+math.ceil(a/2)][2+(x-1)*2-a%2] = cols[c[a]]\
							end\
						else\
							-- add char to a separate table ugh fking bs shit\
							sl.chars[t][x..\",\"..y] = {ch,fg,bg}\
							for a=1,6 do\
								cvs[(y-1)*3+math.ceil(a/2)][2+(x-1)*2-a%2] = -1\
							end\
						end\
					end\
				end\
			end\
		else\
			lUtils.popup(\"Error\",\"This filetype is not supported.\",23,9,{\"OK\"})\
			return\
		end\
		sl.frame = sl.frames[1]\
		s.var.cvs = sl.frame[1]\
		s.var.path = fp\
		s.var.changed = false\
		os.queueEvent(\"squarepaint_preview\")\
	end\
end\
sl.loadImage = loadImage\
local tArgs = {...}\
if tArgs[1] then\
	os.sleep(0.5)\
	loadImage(tArgs[1])\
end",
    name = "init.lua",
  },
  [ "tooltip.lua" ] = {
    id = 16,
    content = "",
    name = "tooltip.lua",
  },
  [ "showfps.lua" ] = {
    id = 12,
    content = "local s = shapescape.getSlide()\
self.txt = tostring(s.var.fps or \"-1\")",
    name = "showfps.lua",
  },
  [ "cvscolors.lua" ] = {
    id = 15,
    content = "local s = shapescape.getSlide()\
local sl = shapescape.getSlides()\
local w,h = term.getSize()\
local cpos\
local ocol1\
local ocol2\
local function render()\
    local cols = s.var.cols\
    cpos = {}\
    local selcol = colors[cols[s.var.colsel]] or 0\
    local selcol2 = colors[cols[s.var.colsel2]] or 0\
    ocol1 = s.var.colsel\
    ocol2 = s.var.colsel2\
    term.setBackgroundColor(colors.lightGray)\
    term.clear()\
    local x,y = 1,1\
    for i = 0, 15 do\
        local col = 2^i\
        local c = lUtils.toBlit(col)\
        term.setCursorPos(x,y)\
        term.blit(\"   \",\"111\",c..c..c)\
        term.setCursorPos(x,y+1)\
        if selcol ~= col and selcol2 ~= col then\
            term.blit(\"   \",\"111\",c..c..c)\
        else\
            local fg = \"1\"\
            if col == colors.orange or col == colors.pink then\
                fg = \"0\"\
            end\
            if selcol == col then\
                term.blit(\"\\139 \",c..\"1\",fg..c)\
            else\
                term.blit(\"  \",\"11\",c..c)\
            end\
            if selcol2 == col then\
                term.blit(\"\\135\",c,fg)\
            else\
                term.blit(\" \",\"1\",c)\
            end\
        end\
        cpos[col] = {x1=x,y1=y,x2=x+2,y2=y+1,i=i+1}\
        x = x+3\
        if x+2 > w then\
            y = y+2\
            x = 1\
        end\
    end\
end\
os.sleep(0.5)\
render()\
while true do\
    local e = {os.pullEvent()}\
    if e[1] == \"mouse_click\" and e[3] >= 1 and e[4] >= 1 and e[3] <= w and e[4] <= h then\
        for k,v in pairs(cpos) do\
            if e[3] >= v.x1 and e[4] >= v.y1 and e[3] <= v.x2 and e[4] <= v.y2 then\
                if e[2] == 1 then\
                    s.var.colsel = v.i\
                elseif e[2] == 2 then\
                    s.var.colsel2 = v.i\
                elseif e[2] == 3 then\
                	sl.colsel = v.i\
                	shapescape.setSlide(2)\
                end\
            end\
        end\
    end\
    if s.var.colsel ~= ocol1 or s.var.colsel2 ~= ocol2 then\
        render()\
        ocol1 = s.var.colsel\
        ocol2 = s.var.colsel2\
    end\
end",
    name = "cvscolors.lua",
  },
  [ "showtool.lua" ] = {
    id = 6,
    content = "local s = shapescape.getSlide()\
if s.var.tool then\
    self.txt = s.var.tools[s.var.tool]\
end",
    name = "showtool.lua",
  },
  [ "coldisplay.lua" ] = {
    id = 3,
    content = "local s = shapescape.getSlide()\
term.setBackgroundColor(colors.lightGray)\
term.clear()\
local function rcol(x,y,w,h,col,l)\
	local bg,fg\
	if col == 0 then\
		bg = colors.lightGray\
		fg = colors.white\
	else\
		bg = colors[s.var.cols[col]] or colors.red\
		fg = colors[s.var.cols[col]] or colors.red\
	end\
	local tx,ty = x,y\
	local tw,th = w,h-1\
	if l == 1 then\
		tx = tx+1\
		ty = ty+1\
		tw = tw-2\
		th = th-2\
	end\
	for y1=ty,ty+th do\
		if y1%2 == 0 then\
			term.setTextColor(fg)\
			term.setBackgroundColor(bg)\
		else\
			term.setTextColor(bg)\
			term.setBackgroundColor(fg)\
		end\
		term.setCursorPos(tx,y1)\
		term.write(string.rep(\"\\153\",tw))\
	end\
	term.setTextColor(colors.gray)\
	term.setBackgroundColor(colors.lightGray)\
	lUtils.border(x,y,x+(w-1),y+(h-1),\"transparent\",l)\
end\
rcol(3,2,7,5,s.var.colsel2,1)\
rcol(1,1,6,4,s.var.colsel,3)\
local col1 = s.var.colsel\
local col2 = s.var.colsel2\
while true do\
	local e = {os.pullEvent()}\
	if col1 ~= s.var.colsel or col2 ~= s.var.colsel2 then\
		term.setBackgroundColor(colors.lightGray)\
		term.clear()\
		col1 = s.var.colsel\
		col2 = s.var.colsel2\
		rcol(3,2,7,5,s.var.colsel2,1)\
		rcol(1,1,6,4,s.var.colsel,3)\
	end\
end",
    name = "coldisplay.lua",
  },
}

local nAssets = {}
for key,value in pairs(assets) do nAssets[key] = value nAssets[assets[key].id] = assets[key] end
assets = nAssets
nAssets = nil

local slides = {
  {
    y = 10,
    h = 40,
    x = 52,
    objs = {
      {
        color = 128,
        y2 = 40,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 23,
        type = "rect",
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 9,
          },
          update = {
            [ 2 ] = 5,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        ox2 = 22,
        x2 = 54,
        y1 = 4,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap left",
          Bottom = "Snap bottom",
        },
        oy2 = 0,
      },
      {
        type = "window",
        color = 32768,
        y2 = 28,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 24,
        y1 = 4,
        x2 = 53,
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap top",
        },
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 0,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
      },
      {
        color = 256,
        y2 = 40,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 1,
        type = "rect",
        oy2 = 0,
        x2 = 22,
        y1 = 4,
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap bottom",
        },
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 7,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
      },
      {
        x2 = 6,
        y2 = 15,
        border = {
          color = 2,
          type = 1,
        },
        x1 = 2,
        image = {
          {
            "",
            "T0T",
            "0T0",
          },
          {
            "",
            "T00",
            "0TT",
          },
        },
        oy1 = 8,
        type = "rect",
        oy2 = 5,
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        input = false,
        color = 128,
        snap = {
          Top = "Snap center",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap center",
        },
        y1 = 12,
      },
      {
        x2 = 11,
        y2 = 15,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 7,
        image = {
          {
            "",
            "T00",
            "0TT",
          },
          {
            "",
            "TTT",
            "000",
          },
        },
        oy1 = 8,
        type = "rect",
        oy2 = 5,
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        input = false,
        color = 128,
        snap = {
          Top = "Snap center",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap center",
        },
        y1 = 12,
      },
      {
        x2 = 6,
        y2 = 19,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 2,
        image = {
          {
            "",
            "T0T",
            "0T0",
          },
          {
            "",
            "000",
            "TTT",
          },
        },
        oy1 = 4,
        type = "rect",
        oy2 = 1,
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        input = false,
        color = 128,
        snap = {
          Top = "Snap center",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap center",
        },
        y1 = 16,
      },
      {
        x2 = 11,
        y2 = 19,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 7,
        image = {
          {
            "",
            "TT0",
            "T0T",
          },
          {
            "",
            "TT0",
            "00T",
          },
        },
        oy1 = 4,
        type = "rect",
        oy2 = 1,
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        input = false,
        color = 128,
        snap = {
          Top = "Snap center",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap center",
        },
        y1 = 16,
      },
      {
        x2 = 6,
        y2 = 23,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 2,
        image = {
          {
            "",
            "TTT",
            "000",
          },
          {
            "",
            "000",
            "TTT",
          },
        },
        oy1 = 0,
        type = "rect",
        oy2 = -3,
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        input = false,
        color = 128,
        snap = {
          Top = "Snap center",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap center",
        },
        y1 = 20,
      },
      {
        x2 = 11,
        y2 = 23,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 7,
        image = {
          {
            "",
            "T0T",
            "TT0",
          },
          {
            "",
            "T00",
            "0TT",
          },
        },
        oy1 = 0,
        type = "rect",
        oy2 = -3,
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        input = false,
        color = 128,
        snap = {
          Top = "Snap center",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap center",
        },
        y1 = 20,
      },
      {
        x2 = 6,
        y2 = 27,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 2,
        image = {
          {
            "",
            "0TT",
            "T00",
          },
          {
            "",
            "TT0",
            "00T",
          },
        },
        oy1 = -4,
        type = "rect",
        oy2 = -7,
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        input = false,
        color = 128,
        snap = {
          Top = "Snap center",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap center",
        },
        y1 = 24,
      },
      {
        x2 = 11,
        y2 = 27,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 7,
        image = {
          {
            "",
            "00T",
            "TT0",
          },
          {
            "",
            "000",
            "TTT",
          },
        },
        oy1 = -4,
        type = "rect",
        oy2 = -7,
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        input = false,
        color = 128,
        snap = {
          Top = "Snap center",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap center",
        },
        y1 = 24,
      },
      {
        x2 = 11,
        y2 = 34,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 3,
        oy1 = -9,
        type = "window",
        oy2 = -14,
        color = 128,
        y1 = 29,
        snap = {
          Top = "Snap center",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap center",
        },
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 3,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
      },
      {
        color = 32768,
        y2 = 40,
        y1 = 4,
        x1 = 13,
        type = "window",
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 2,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        x2 = 21,
        input = false,
        border = {
          color = 0,
          type = 1,
        },
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap bottom",
        },
        oy2 = 0,
      },
      {
        x2 = 76,
        y2 = 40,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 55,
        ox1 = 21,
        type = "rect",
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        ox2 = 0,
        oy2 = 0,
        color = 256,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap bottom",
        },
        y1 = 4,
      },
      {
        color = 0,
        y2 = 11,
        x1 = 2,
        oy1 = 9,
        txt = "loading...",
        type = "text",
        oy2 = 9,
        txtcolor = 1,
        border = {
          color = 0,
          type = 1,
        },
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = 6,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        input = false,
        x2 = 11,
        snap = {
          Top = "Snap center",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap center",
        },
        y1 = 11,
      },
      {
        x2 = 71,
        y2 = 15,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 56,
        ox1 = 20,
        type = "window",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 13,
          },
        },
        ox2 = 5,
        color = 32768,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        y1 = 5,
      },
      {
        color = 128,
        y2 = 16,
        y1 = 16,
        x1 = 56,
        ox1 = 20,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        ox2 = 5,
        x2 = 71,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        border = {
          color = 0,
          type = 1,
        },
      },
      {
        x2 = 60,
        y2 = 16,
        x1 = 58,
        ox1 = 18,
        txt = "FPS",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        ox2 = 16,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        input = false,
        y1 = 16,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        txtcolor = 1,
      },
      {
        x2 = 70,
        y2 = 16,
        y1 = 16,
        x1 = 62,
        ox1 = 14,
        type = "window",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 11,
          },
        },
        ox2 = 6,
        color = 32768,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        border = {
          color = 0,
          type = 1,
        },
      },
      {
        x2 = 57,
        y2 = 16,
        x1 = 56,
        ox1 = 20,
        txt = "99",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = 12,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        txtcolor = 1,
        ox2 = 19,
        y1 = 16,
        input = false,
        color = 0,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        border = {
          color = 0,
          type = 1,
        },
      },
      {
        color = 16384,
        y2 = 17,
        border = {
          color = 32,
          type = 1,
        },
        x1 = 56,
        ox1 = 20,
        type = "window",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 14,
          },
        },
        ox2 = 5,
        x2 = 71,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        y1 = 17,
      },
      {
        color = 128,
        y2 = 23,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 56,
        ox1 = 20,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
        },
        ox2 = 16,
        y1 = 20,
        input = false,
        x2 = 60,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        image = {
          {
            "",
            "TTT",
            "T0T",
          },
          {
            "",
            "T0T",
            "TTT",
          },
        },
      },
      {
        color = 128,
        y2 = 23,
        y1 = 20,
        x1 = 61,
        ox1 = 15,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        ox2 = 11,
        border = {
          color = 256,
          type = 1,
        },
        input = false,
        x2 = 65,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        image = {
          {
            "",
            "00T",
            "TT0",
          },
          {
            "",
            "TT0",
            "00T",
          },
        },
      },
      {
        color = 128,
        y2 = 23,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 66,
        ox1 = 10,
        type = "rect",
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
        },
        ox2 = 6,
        y1 = 20,
        input = false,
        x2 = 70,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        image = {
          {
            "",
            "0TT",
            "T00",
          },
          {
            "",
            "TTT",
            "000",
          },
        },
      },
      {
        color = 0,
        y2 = 19,
        x1 = 56,
        ox1 = 20,
        txt = "Transform",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        ox2 = 12,
        y1 = 19,
        x2 = 64,
        input = false,
        border = {
          color = 0,
          type = 1,
        },
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        txtcolor = 1,
      },
      {
        x2 = 64,
        y2 = 25,
        x1 = 56,
        ox1 = 20,
        txt = "Colors",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        txtcolor = 1,
        ox2 = 12,
        color = 0,
        input = false,
        border = {
          color = 0,
          type = 1,
        },
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        y1 = 25,
      },
      {
        color = 128,
        y2 = 15,
        x1 = 72,
        ox1 = 4,
        oy1 = 8,
        type = "rect",
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        ox2 = 0,
        oy2 = 5,
        y1 = 12,
        x2 = 76,
        input = false,
        border = {
          color = 256,
          type = 1,
        },
        snap = {
          Top = "Snap center",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap center",
        },
        image = {
          {
            "",
            "T00",
            "0TT",
          },
          {
            "",
            "T00",
            "0TT",
          },
        },
      },
      {
        x2 = 76,
        y2 = 19,
        x1 = 72,
        ox1 = 4,
        oy1 = 4,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
        },
        ox2 = 0,
        border = {
          color = 256,
          type = 1,
        },
        oy2 = 1,
        color = 128,
        input = false,
        y1 = 16,
        snap = {
          Top = "Snap center",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap center",
        },
        image = {
          {
            "",
            "TTT",
            "T00",
          },
          {
            "",
            "T0T",
            "0TT",
          },
        },
      },
      {
        x2 = 76,
        y2 = 23,
        x1 = 72,
        ox1 = 4,
        oy1 = 0,
        type = "rect",
        oy2 = -3,
        ox2 = 0,
        event = {
          mouse_up = {
            [ 2 ] = 19,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        border = {
          color = 256,
          type = 1,
        },
        color = 128,
        input = false,
        y1 = 20,
        snap = {
          Top = "Snap center",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap center",
        },
        image = {
          {
            "",
            "TTT",
            "000",
          },
          {
            "",
            "00T",
            "TT0",
          },
        },
      },
      {
        x2 = 76,
        y2 = 27,
        x1 = 72,
        ox1 = 4,
        oy1 = -4,
        type = "rect",
        oy2 = -7,
        ox2 = 0,
        y1 = 24,
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = 20,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
        },
        color = 128,
        input = false,
        border = {
          color = 256,
          type = 1,
        },
        snap = {
          Top = "Snap center",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap center",
        },
        image = {
          {
            "",
            "0TT",
            "T00",
          },
          {
            "",
            "TTT",
            "000",
          },
        },
      },
      {
        x2 = 76,
        y2 = 31,
        x1 = 72,
        ox1 = 4,
        oy1 = -8,
        type = "rect",
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 8,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = 17,
          },
        },
        ox2 = 0,
        oy2 = -11,
        y1 = 28,
        color = 128,
        input = false,
        border = {
          color = 256,
          type = 1,
        },
        snap = {
          Top = "Snap center",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap center",
        },
        image = {
          {
            "",
            "TTT",
            "000",
          },
          {
            "",
            "0TT",
            "T00",
          },
        },
      },
      {
        x2 = 70,
        y2 = 33,
        y1 = 26,
        x1 = 56,
        ox1 = 20,
        type = "window",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 15,
          },
        },
        ox2 = 6,
        color = 32768,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        border = {
          color = 0,
          type = 1,
        },
      },
      {
        color = 32768,
        y2 = 3,
        y1 = 1,
        x1 = 1,
        type = "window",
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 10,
          },
          update = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        ox2 = 0,
        input = false,
        x2 = 76,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap left",
          Bottom = "Snap top",
        },
        border = {
          color = 2,
          type = 1,
        },
      },
      {
        color = 0,
        y2 = 3,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 73,
        ox1 = 3,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 21,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
        },
        ox2 = 0,
        y1 = 1,
        x2 = 76,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap top",
        },
        image = {
          {
            "",
            "TTT1",
            "111T",
          },
          {
            "",
            "T1f1",
            "1f1T",
          },
          {
            "",
            "1111",
            "TTTT",
          },
        },
      },
      {
        color = 0,
        y2 = 40,
        x1 = 56,
        ox1 = 20,
        oy1 = 0,
        txt = "[00x00] 00:00",
        type = "text",
        oy2 = 0,
        ox2 = 5,
        y1 = 40,
        border = {
          color = 0,
          type = 1,
        },
        x2 = 71,
        input = false,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = 18,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        snap = {
          Top = "Snap bottom",
          Right = "Snap right",
          Left = "Snap right",
          Bottom = "Snap bottom",
        },
        txtcolor = 2,
      },
    },
    w = 76,
    c = 1,
  },
  {
    y = 10,
    x = 52,
    h = 40,
    w = 76,
    objs = {
      {
        x2 = 76,
        y2 = 40,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 1,
        type = "window",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 22,
          },
        },
        ox2 = 0,
        color = 32768,
        y1 = 1,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap left",
          Bottom = "Snap bottom",
        },
        oy2 = 0,
      },
      {
        color = 128,
        y2 = 27,
        border = {
          color = 256,
          type = 1,
        },
        x1 = 21,
        ox1 = 17,
        oy1 = 5,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        ox2 = -18,
        oy2 = -7,
        x2 = 56,
        snap = {
          Top = "Snap center",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap center",
        },
        y1 = 15,
      },
      {
        color = 0,
        y2 = 16,
        x1 = 23,
        ox1 = 15,
        oy1 = 4,
        txt = "Adjusting color 00 (none)",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 23,
          },
          update = {
            [ 2 ] = -1,
          },
        },
        ox2 = -17,
        y1 = 16,
        border = {
          color = 0,
          type = 1,
        },
        x2 = 55,
        input = false,
        txtcolor = 1,
        snap = {
          Top = "Snap center",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap center",
        },
        oy2 = 4,
      },
      {
        x2 = 24,
        y2 = 19,
        x1 = 23,
        ox1 = 15,
        oy1 = 1,
        txt = "R:",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        ox2 = 14,
        y1 = 19,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        input = false,
        txtcolor = 1,
        snap = {
          Top = "Snap center",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap center",
        },
        oy2 = 1,
      },
      {
        color = 0,
        y2 = 21,
        x1 = 23,
        ox1 = 15,
        oy1 = -1,
        txt = "G:",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        txtcolor = 1,
        ox2 = 14,
        border = {
          color = 0,
          type = 1,
        },
        x2 = 24,
        input = false,
        y1 = 21,
        snap = {
          Top = "Snap center",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap center",
        },
        oy2 = -1,
      },
      {
        x2 = 24,
        y2 = 23,
        x1 = 23,
        ox1 = 15,
        oy1 = -3,
        txt = "B:",
        type = "text",
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
        },
        txtcolor = 1,
        ox2 = 14,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        input = false,
        y1 = 23,
        snap = {
          Top = "Snap center",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap center",
        },
        oy2 = -3,
      },
      {
        color = 1,
        y1 = 19,
        x1 = 26,
        scrollX = 0,
        ox1 = 12,
        txt = "",
        opt = {
          overflowX = "scroll",
          overflowY = "none",
          cursorColor = 1,
          indentChar = " ",
          tabSize = 4,
          minWidth = 9,
          overflow = "scroll",
          minHeight = 1,
        },
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        blit = {},
        snap = {
          Top = "Snap center",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap center",
        },
        lines = {
          "",
        },
        x2 = 36,
        y2 = 19,
        border = {
          color = 0,
          type = 1,
        },
        scr = 0,
        oy1 = 1,
        type = "input",
        oy2 = 1,
        txtcolor = 32768,
        changed = false,
        history = {},
        cursor = {
          y = 1,
          x = 1,
          a = 1,
        },
        dLines = {
          "",
        },
        state = false,
        ref = {
          1,
          1,
        },
        rhistory = {},
        ox2 = 2,
      },
      {
        color = 1,
        y1 = 21,
        x1 = 26,
        scrollX = 0,
        ox1 = 12,
        txt = "",
        opt = {
          overflowX = "scroll",
          overflowY = "none",
          cursorColor = 1,
          indentChar = " ",
          tabSize = 4,
          minWidth = 9,
          overflow = "scroll",
          minHeight = 1,
        },
        rhistory = {},
        state = false,
        snap = {
          Top = "Snap center",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap center",
        },
        lines = {
          "",
        },
        x2 = 36,
        y2 = 21,
        border = {
          color = 0,
          type = 1,
        },
        scr = 0,
        oy1 = -1,
        type = "input",
        blit = {},
        ox2 = 2,
        changed = false,
        dLines = {
          "",
        },
        cursor = {
          y = 1,
          x = 1,
          a = 1,
        },
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        history = {},
        ref = {
          1,
          1,
        },
        oy2 = -1,
        txtcolor = 32768,
      },
      {
        color = 1,
        y1 = 23,
        x1 = 26,
        scrollX = 0,
        ox1 = 12,
        txt = "",
        opt = {
          overflowX = "scroll",
          overflowY = "none",
          cursorColor = 1,
          indentChar = " ",
          tabSize = 4,
          minWidth = 9,
          overflow = "scroll",
          minHeight = 1,
        },
        rhistory = {},
        state = false,
        snap = {
          Top = "Snap center",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap center",
        },
        lines = {
          "",
        },
        x2 = 36,
        y2 = 23,
        border = {
          color = 0,
          type = 1,
        },
        scr = 0,
        oy1 = -3,
        type = "input",
        dLines = {
          "",
        },
        ox2 = 2,
        changed = false,
        history = {},
        cursor = {
          y = 1,
          x = 1,
          a = 1,
        },
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
        },
        blit = {},
        ref = {
          1,
          1,
        },
        txtcolor = 32768,
        oy2 = -3,
      },
      {
        x2 = 52,
        y2 = 25,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 41,
        ox1 = -3,
        oy1 = 2,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        ox2 = -14,
        oy2 = -5,
        color = 32768,
        snap = {
          Top = "Snap center",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap center",
        },
        y1 = 18,
      },
    },
    c = 2,
  },
}

for s=1,#slides do
	local slide = slides[s]
	for o=1,#slide.objs do
		local obj = slide.objs[o]
		for key,value in pairs(obj.event) do
			if assets[ value[2] ] then
				lUtils.shapescape.addScript(obj,value[2],key,assets,LevelOS,slides)
			else
				obj.event[key] = {function() end,-1}
			end
		end
	end
end

	local tArgs = {...}
if tArgs[1] and tArgs[1] == "load" then
	return {assets=assets,slides=slides}
end


return lUtils.shapescape.run(slides,...)