local assets = {
  opendoor = {
    id = 0,
    content = "shapescape.setSlide(2)",
    name = "opendoor",
  },
  closedoor = {
    id = 1,
    content = "shapescape.setSlide(1)",
    name = "closedoor",
  },
}

local nAssets = {}
for key,value in pairs(assets) do nAssets[key] = value nAssets[assets[key].id] = assets[key] end
assets = nAssets
nAssets = nil

local slides = {
  {
    y = 20,
    x = 61,
    h = 19,
    w = 51,
    objs = {
      {
        type = "rect",
        x2 = 51,
        y2 = 19,
        border = {
          color = 32768,
          type = 1,
        },
        x1 = 1,
        y1 = 1,
        color = 128,
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap top",
        },
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
      },
      {
        type = "rect",
        color = 2048,
        y2 = 14,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 0,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 8,
        x2 = 24,
        border = {
          color = 2048,
          type = 1,
        },
        y1 = 5,
      },
      {
        type = "rect",
        color = 2048,
        y2 = 10,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 32,
        x2 = 39,
        border = {
          color = 1,
          type = 1,
        },
        y1 = 8,
      },
      {
        type = "rect",
        color = 8,
        y2 = 16,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 6,
        y1 = 15,
        x2 = 26,
        border = {
          color = 512,
          type = 1,
        },
      },
      {
        txt = "Door",
        type = "text",
        color = 0,
        y2 = 9,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 0,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 14,
        y1 = 9,
        x2 = 22,
        border = {
          color = 0,
          type = 1,
        },
        input = false,
        txtcolor = 16384,
      },
      {
        txt = "Closed",
        type = "text",
        color = 0,
        y2 = 8,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 33,
        y1 = 8,
        x2 = 41,
        border = {
          color = 0,
          type = 1,
        },
        input = false,
        txtcolor = 16384,
      },
    },
    c = 1,
  },
  {
    y = 20,
    x = 61,
    h = 19,
    w = 51,
    objs = {
      {
        type = "rect",
        color = 128,
        y2 = 20,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 1,
        y1 = 1,
        x2 = 51,
        border = {
          color = 32768,
          type = 1,
        },
      },
      {
        type = "rect",
        color = 8,
        y2 = 16,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 6,
        x2 = 26,
        border = {
          color = 512,
          type = 1,
        },
        y1 = 15,
      },
      {
        type = "rect",
        color = 2048,
        y2 = 14,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 8,
        x2 = 24,
        border = {
          color = 2048,
          type = 1,
        },
        y1 = 14,
      },
      {
        txt = "Door",
        type = "text",
        color = 0,
        y2 = 14,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 14,
        y1 = 14,
        x2 = 22,
        border = {
          color = 0,
          type = 1,
        },
        input = false,
        txtcolor = 8192,
      },
      {
        type = "rect",
        color = 2048,
        y2 = 10,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 32,
        x2 = 39,
        border = {
          color = 1,
          type = 1,
        },
        y1 = 8,
      },
      {
        txt = "Opened",
        type = "text",
        color = 0,
        y2 = 9,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 33,
        y1 = 9,
        x2 = 41,
        border = {
          color = 0,
          type = 1,
        },
        input = false,
        txtcolor = 8192,
      },
    },
    c = 2,
  },
}

for s=1,#slides do
		local slide = slides[s]
		for o=1,#slide.objs do
			local obj = slide.objs[o]
			for key,value in pairs(obj.event) do
				if assets[ value[2] ] then
					lUtils.shapescape.addScript(obj,value[2],key,assets,LevelOS,slides)
				else
					obj.event[key] = {function() end,-1}
				end
			end
		end
	end

		local tArgs = {...}
	if tArgs[1] and tArgs[1] == "load" then
		return {assets=assets,slides=slides}
	end

	
	lUtils.shapescape.run(slides)