---essentials---------------------
local expect = (require and require("cc.expect") or dofile("rom/modules/main/cc/expect.lua")).expect
local function wrap(text, width)
    expect(1, text, "string")
    expect(2, width, "number", "nil")
    width = width or term.getSize()


    local lines, lines_n, current_line = {}, 0, ""
    local function push_line()
        lines_n = lines_n + 1
        lines[lines_n] = current_line
        current_line = ""
    end

    local pos, length = 1, #text
    local sub, match = string.sub, string.match
    while pos <= length do
        local head = sub(text, pos, pos)
        if head == " " or head == "\t" then
            local whitespace = match(text, "^[ \t]+", pos)
            current_line = current_line .. whitespace
            pos = pos + #whitespace
        elseif head == "\n" then
            push_line()
            pos = pos + 1
        else
            local word = match(text, "^[^ \t\n]+", pos)
            pos = pos + #word
            if #word > width then
                -- Print a multiline word
                while #word > 0 do
                    local space_remaining = width - #current_line - 1
                    if space_remaining <= 0 then
                        push_line()
                        space_remaining = width
                    end

                    current_line = current_line .. sub(word, 1, space_remaining)
                    word = sub(word, space_remaining + 1)
                end
            else
                -- Print a word normally
                if width - #current_line < #word then push_line() end
                current_line = current_line .. word
            end
        end
    end

    push_line()

    -- Trim whitespace longer than width.
    for k, line in pairs(lines) do
        line = line:sub(1, width)
        lines[k] = line
    end

    return lines
end
local function ensure_width(line, width)
    expect(1, line, "string")
    expect(2, width, "number", "nil")
    width = width or term.getSize()

    line = line:sub(1, width)
    if #line < width then
        line = line .. (" "):rep(width - #line)
    end

    return line
end
local function split(s, delimiter)
	local parts, index = {}, 1
	for part in s:gmatch(delimiter) do
		parts[index] = part
		index = index + 1
	end

	return parts
end
local function writeFile(path,content)
    while not fs.exists(path) do
	    local file = fs.open(path,"w")
        if file then
	        file.write(content)
	        file.close()
        end
    end
end
local function readFile(path)
    while true do
	    local file = fs.open(path,"r")
        if file then
	        local variable = file.readAll()
	        file.close()
	        return variable
        end
    end
end
local function ensureDir(path)
    if not fs.exists(path) then fs.makeDir(path) end
end
local function generateTmpName()
    local t = ""
    local chartbl = {"0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"}
    for i = 1, 40 do
        t = t .. chartbl[math.random(1, #chartbl)]
    end
    t = t .. "-"
    for i = 1, 6 do
        t = t .. chartbl[math.random(1, #chartbl)]
    end
    t = t .. "-"
    for i = 1, 6 do
        t = t .. chartbl[math.random(1, #chartbl)]
    end
    return t
end
local function showPopup(title, msg, buttons)
    t = ""
    tTbl = wrap(msg, 25)
    return {lUtils.popup(title, msg, 27, #tTbl + 6, buttons, true)}
end
if not lOS and lUtils and not lOS.started then
    term.setTextColor(colors.white)
    term.setBackgroundColor(colors.black)
    term.setCursorPos(1, 1)
    term.clear()
    print("WARNING")
    print("You are running without LevelOS. You cannot run this unless you install it. Insert the installation media or install via command and try again.")
    sleep(5)
    print("Press any key to close this screen.")
    os.pullEvent("key_up")
    term.setTextColor(colors.white)
    term.setBackgroundColor(colors.black)
    term.setCursorPos(1, 1)
    term.clear()
    return
end
----------------------------------

--variables-----------------------
local nX,nY = LevelOS.self.window.win.getPosition()
local nNativeW,nNativeH = lOS.wAll.getSize()
local nTaskbarHeight = lOS.tbSize
local sScriptDir = fs.getDir(shell.getRunningProgram())
local tWin = LevelOS.self
local setWin = LevelOS.setWin
----------------------------------

--settings------------------------
local debugMode = false
----------------------------------
local function title(t)
    if LevelOS then
        LevelOS.setTitle(t)
    end
end
title("cash:loading")
term.setCursorPos(1, 1)
_ENV.CASH_SESSION_ID = generateTmpName()
if debugMode then
    print("SESSION ID: "..CASH_SESSION_ID)
end
title("cash")
shell.execute("/"..sScriptDir.."/cash.lua")
_ENV.CASH_SESSION_ID = nil