-------------------------------------------- DEPENDENCIES --------------------------------------------

local GameObject = require("gameobject")


-------------------------------------------- DEFINITIONS ---------------------------------------------

local math_floor = math.floor
local math_cos = math.cos
local math_sin = math.sin
local math_pi = math.pi

local Movable
local MovableMT


---------------------------------------------- MOVABLE -----------------------------------------------

Movable = {isMovable=true, class="Movable"}
setmetatable(Movable,{__index=GameObject})

MovableMT = {__index=Movable}

Movable.getVelocity = function(self, normalized)
	local speed = self.speed
	if normalized then
		speed = 1
	end
	local angle = self.direction * math_pi/180
	return math_cos(angle) * speed, math_sin(angle) * speed
end

return Movable