-------------------------------------------- DEFINITIONS ---------------------------------------------

local Graphics

local math_sqrt = math.sqrt
local math_ceil = math.ceil
local math_floor = math.floor
local math_abs = math.abs
local math_random = math.random
local math_pi = math.pi
local math_cos = math.cos
local math_sin = math.sin
local table_insert = table.insert
local string_rep = string.rep


---------------------------------------------- GRAPHICS ----------------------------------------------

Graphics = {}

Graphics.drawCircle = function(r,cX,cY)
	local w,h = term.getSize()
	if not (cX and cY) then
		cX,cY = math_floor(w/2)+1,math_floor(h/2)+1
	end
	for y=1,r do
		local off = math_sqrt(r^2-(y-r)^2)
		local offH = math_floor(off/2+0.5)
		term.setCursorPos(cX-offH,cY-math_floor(r/2)+math_floor(y/2))
		term.write(string_rep(" ",offH*2))
		term.setCursorPos(cX-offH,cY+math_floor(r/2)-math_floor(y/2))
		term.write(string_rep(" ",offH*2))
	end
end

Graphics.fontWrite = function(font, txt)
	local w = #font[1][1][1]+1
	local x,y = term.getCursorPos()
	local DOT = ("."):byte()
	local i = 0
	for char in txt:gmatch(".") do
		local c = char:byte()-DOT+1
		lUtils.renderImg(font[c],x+w*i,y,nil,true)
		i = i+1
	end
end

return Graphics