-------------------------------------------- DEFINITIONS ---------------------------------------------

local GameObject
local GameObjectMT

local math_sqrt = math.sqrt
local math_ceil = math.ceil
local math_floor = math.floor
local math_abs = math.abs
local math_random = math.random
local math_pi = math.pi
local math_cos = math.cos
local math_sin = math.sin
local math_atan2 = math.atan2
local math_deg = math.deg
local table_insert = table.insert
local string_rep = string.rep


-------------------------------------------- GAMEOBJECT -----------------------------------------------

GameObject = {class="GameObject"}
GameObjectMT = {__index=GameObject}

GameObject.new = function(world, x, y, properties)
	local gameobject = {x=x, y=y, world=world}
	for k,v in pairs(properties) do
		gameobject[k] = v
	end
	setmetatable(gameobject,GameObjectMT)
	
	local region = world:getRegion(x, y)
	region.objects[gameobject] = true
	
	return gameobject
end

GameObject.getDistanceTo = function(self,objX,objY)
	return math_sqrt((self.x-objX)^2+(self.y-objY)^2)
end

GameObject.getAngleTo = function(self,objX,objY)
	return (360-math_deg(math_atan2(objX-self.x, objY-self.y))+90)%360
end

return GameObject