-------------------------------------------- DEPENDENCIES --------------------------------------------

local Graphics = require("graphics")
local GameObject = require("gameobject")


-------------------------------------------- DEFINITIONS ---------------------------------------------

local Collectible
local CollectibleMT

local math_sqrt = math.sqrt


-------------------------------------------- COLLECTIBLE ---------------------------------------------

Collectible = {class="Collectible"}
setmetatable(Collectible, {__index=GameObject})

CollectibleMT = {__index=Collectible}

Collectible.new = function(world, x, y, score, size, color)
	
	local collectible = GameObject.new(world, x, y, {size=size or 1, color=color, score=score or 0, spawnTime=math.random(0,500)})
	setmetatable(collectible,CollectibleMT)
	
	return collectible
	
end

Collectible.isInside = function(self, objX, objY, objSize)
	
	if self:getDistanceTo(objX, objY) < self.size/2+(objSize*1.4)/2 then
		return true
	else
		return false
	end

end

Collectible.render = function(self, baseX, baseY)
	
	local zoom = self.world.zoom or 1
	
	term.setBackgroundColor(self.color or colors.white)
	local off = 0
	if (self.spawnTime+os.epoch("utc"))%500 > 250 then
		off = 1
		term.setBackgroundColor(colors.white)
	end
	Graphics.drawCircle(math.max(self.size*zoom,1), baseX+self.x*zoom+off, baseY+self.y*zoom)
	
end

Collectible.kill = function(self)
	
	local region = self.world:getRegion(self.x,self.y)
	region.objects[self] = nil
	
	if self.score == 1 then
		Collectible.new(self.world, math.random(1, world.width), math.random(1, world.height), 1, 1, colors.lightBlue)
	end
	
end

Collectible.collide = function(self, obj)
	
	obj.size = obj.size+self.score
	return self:kill()
	
end

return Collectible