if LevelOS then
    LevelOS.self.window.win = nil
end
local dim = 0
local drawBar = false
local cols = {}
if not fs.exists("blittle") then
    shell.run("pastebin get ujchRSnU blittle")
end
os.loadAPI("blittle")
local bar
for k,v in pairs(colors) do
    if type(v) == "number" then
        cols[#cols+1] = {v,{term.getPaletteColor(v)}}
    end
end
local otime
local function applyDim()
    drawBar = true
    otime = os.epoch("local")
    for c=1,#cols do
        local col = cols[c][2]
        for k,w in pairs(lOS.wins) do
            w.win.setPaletteColor(cols[c][1],col[1]*(1-dim*0.75),col[2]*(1-dim*0.75),col[3]*(1-dim*0.75))
        end
    end
end
local odim = 0
function LevelOS.overlay()
    if drawBar then
        if not bar then
            bar = blittle.createWindow(term.current(),4,3,1,5,false)
            bar.render = function() bar.setVisible(true) bar.setVisible(false) end
        end
        term.setBackgroundColor(colors.black)
        for y=1,8 do
            term.setCursorPos(2,1+y)
            term.write(string.rep(" ",5))
        end
        term.setCursorPos(4,8)
        term.setTextColor(colors.white)
        term.write("*")
        term.setCursorPos(2,9)
        --term.write(dim)
        if odim ~= dim then
            dim = math.floor(dim*20+0.5)/20
            local oterm = term.current()
            term.redirect(bar)
            term.setBackgroundColor(colors.gray)
            term.clear()
            term.setBackgroundColor(colors.white)
            theY = 1+math.floor((13*dim))
            term.setCursorPos(1,theY)
            term.write("  ")
            term.setCursorPos(1,1+theY)
            term.write("  ")
            term.redirect(oterm)
            odim = dim
        end
        bar.render()
        --[[term.setBackgroundColor(colors.black)
        term.setTextColor(colors.white)
        term.setCursorPos(2,9)
        term.write(dim..","..theY)]]
        if otime < os.epoch("local")-2000 then
            drawBar = false
        end
    end
end
while true do
    local e = {LevelOS.pullEvent()}
    if e[1] == "key" then
        if e[2] == keys.f5 and dim < 1 then
            dim = dim+0.05
            applyDim()
        elseif e[2] == keys.f6 and dim > 0 then
            dim = dim-0.05
            applyDim()
        end
    end
end