local assets = {
  [ "font.lua" ] = {
    id = 1,
    content = "local s = shapescape.getSlide()\
local path = fs.getDir(LevelOS.self.window.path)\
--error(path)\
if not s.font then\
    local a = string.byte(\"a\")\
    s.font = {width=3,height=2}\
    local fontImg = lUtils.asset.load(fs.combine(path,\"assets/font.limg\"))\
    if not fontImg then return end\
    for l=1,26 do\
        s.font[string.char(a+(l-1))] = fontImg[l]\
    end\
end\
local lineW = (#self.txt*s.font.width)-2\
local screenW,screenH = term.getSize()\
local x = math.ceil(screenW/2)-math.floor(lineW/2)\
self.x1 = x\
self.txtcolor = colors.black\
string.gsub(self.txt:lower(),\".\",function(char) term.setBackgroundColor(colors.black) lUtils.renderImg(s.font[char],x,self.y1) x = x+s.font.width end)\
term.setCursorPos(self.x1,self.y1)\
self.x2 = x+(lineW-1)\
self.y2 = self.y1+(s.font.height-1)",
    name = "font.lua",
  },
  [ "ball.lua" ] = {
    id = 4,
    content = "  dif = {}\
dif.Easy = {1,1,0.1}\
dif.Faster = {1,1,0.05}\
dif.Fastest = {2,2,0.05}\
local sl = shapescape.getSlides()\
local s = shapescape.getSlide()\
platform = {s.objs[2],s.objs[3]} \
local width,height = self.x2-(self.x1-1),self.y2-(self.y1-1)\
self.velX,self.velY,self.delay = unpack(dif[sl.difficulty])\
if lOS and lOS.sysUpdate then\
    lOS.sysUpdate(false)\
    function LevelOS.close()\
        lOS.sysUpdate(true)\
    end\
end\
local function move(x,y)\
    self.x1,self.y1 = x,y\
    self.x2,self.y2 = x+(width-1),y+(height-1)\
end\
while true do\
    os.sleep(self.delay)\
    local w,h = term.getSize()\
    if self.velY > 0 and self.y2+self.velY >= platform[2].y1 then\
        if self.x1 <= platform[2].x2 and self.x2 >= platform[2].x1 then\
            self.velY = self.velY*-1\
        else\
            move(math.ceil(w/2)-math.floor(width/2),math.ceil(h/2),math.floor(height/2))\
            self.velY = self.velY*-1\
        end\
    elseif  self.velY < 0 and self.y1+self.velY <= platform[1].y2 then\
        if self.x1 <= platform[1].x2 and self.x2 >= platform[1].x1 then\
            self.velY = self.velY*-1\
        else\
            move(math.ceil(w/2)-math.floor(width/2),math.ceil(h/2),math.floor(height/2))\
            self.velY = self.velY*-1\
        end\
    end\
    if self.x1+self.velX < 1 or self.x2+self.velX > w then\
        self.velX = self.velX*-1\
    end\
    move(self.x1+self.velX,self.y1+self.velY)\
end",
    name = "ball.lua",
  },
  [ "difficulty.lua" ] = {
    id = 3,
    content = "shapescape.getSlides().difficulty = self.txt\
shapescape.setSlide(2)",
    name = "difficulty.lua",
  },
  [ "platform.lua" ] = {
    id = 2,
    content = "local s = shapescape.getSlide()\
if not s.pNum then\
    s.pNum = 1\
end\
self.pNum = s.pNum\
s.pNum = s.pNum+1\
local width = self.x2-(self.x1-1)\
while true do\
    local e = {os.pullEvent()}\
    if e[1] == \"mouse_click\" or e[1] == \"mouse_drag\" then\
        local w,h = term.getSize()\
        local hH = math.ceil(h/2)\
        local y = 1+(hH*(self.pNum-1))\
        if e[4] >= y and e[4] <= y+hH then\
            self.x1 = e[3]-math.floor(width/2)\
            self.x2 = self.x1+(width-1)\
        end\
    end\
end",
    name = "platform.lua",
  },
  [ "title.lua" ] = {
    id = 0,
    content = "--print(shell.getRunningProgram())\
function shell.getRunningProgram() return LevelOS.self.window.path end\
if not fs.exists(fs.combine(fs.getDir(shell.getRunningProgram()),\"assets\")) then\
    shapescape.getSlides().difficulty = \"Normal\"\
    shapescape.setSlide(2)\
    return\
end\
local s = shapescape.getSlide()\
if not s.titleNum then\
    s.titleNum = 0\
    s.titleImg = lUtils.asset.load(fs.combine(fs.getDir(shell.getRunningProgram()),\"assets\",\"pong.nfg\"))\
end\
s.titleNum = s.titleNum+1\
self.image = s.titleImg[s.titleNum]",
    name = "title.lua",
  },
}

local nAssets = {}
for key,value in pairs(assets) do nAssets[key] = value nAssets[assets[key].id] = assets[key] end
assets = nAssets
nAssets = nil

local slides = {
  {
    y = 12,
    x = 64,
    h = 37,
    w = 44,
    objs = {
      {
        x2 = 44,
        y2 = 37,
        y1 = 1,
        x1 = 1,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        ox2 = 0,
        color = 32768,
        border = {
          color = 0,
          type = 1,
        },
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap left",
          Bottom = "Snap bottom",
        },
        oy2 = 0,
      },
      {
        color = 0,
        y2 = 12,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 3,
        ox1 = 19,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 0,
          },
        },
        ox2 = 11,
        x2 = 11,
        y1 = 3,
        snap = {
          Top = "Snap top",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap top",
        },
        image = "000000000\
000000000\
000   000\
000   000\
000000000\
000000000\
000      \
000      \
000      \
000      ",
      },
      {
        color = 0,
        y2 = 12,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 13,
        ox1 = 9,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 0,
          },
          update = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        ox2 = 1,
        x2 = 21,
        y1 = 3,
        snap = {
          Top = "Snap top",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap top",
        },
        image = "000000000\
000000000\
000   000\
000   000\
000000000\
000000000\
000      \
000      \
000      \
000      ",
      },
      {
        color = 0,
        y2 = 12,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 24,
        ox1 = -2,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 0,
          },
          update = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        ox2 = -10,
        x2 = 32,
        y1 = 3,
        snap = {
          Top = "Snap top",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap top",
        },
        image = "000000000\
000000000\
000   000\
000   000\
000000000\
000000000\
000      \
000      \
000      \
000      ",
      },
      {
        color = 0,
        y2 = 12,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 34,
        ox1 = -12,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 0,
          },
          update = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        ox2 = -20,
        x2 = 42,
        y1 = 3,
        snap = {
          Top = "Snap top",
          Right = "Snap center",
          Left = "Snap center",
          Bottom = "Snap top",
        },
        image = "000000000\
000000000\
000   000\
000   000\
000000000\
000000000\
000      \
000      \
000      \
000      ",
      },
      {
        x2 = 24,
        y2 = 19,
        y1 = 19,
        x1 = 21,
        txt = "Easy",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 3,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = 1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        txtcolor = 1,
        input = false,
        color = 0,
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap top",
        },
        border = {
          color = 0,
          type = 1,
        },
      },
      {
        color = 0,
        y2 = 24,
        y1 = 24,
        x1 = 20,
        txt = "Faster",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 3,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = 1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        txtcolor = 1,
        input = false,
        x2 = 25,
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap top",
        },
        border = {
          color = 0,
          type = 1,
        },
      },
      {
        color = 0,
        y2 = 29,
        y1 = 29,
        x1 = 20,
        txt = "Fastest",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 3,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = 1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          [ " update" ] = {
            [ 2 ] = -1,
          },
        },
        txtcolor = 1,
        input = false,
        x2 = 25,
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap top",
        },
        border = {
          color = 0,
          type = 1,
        },
      },
    },
    c = 1,
  },
  {
    y = 13,
    x = 64,
    h = 37,
    w = 44,
    objs = {
      {
        x2 = 44,
        y2 = 37,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 1,
        type = "rect",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
        },
        ox2 = 0,
        color = 32768,
        y1 = 1,
        snap = {
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap left",
          Bottom = "Snap bottom",
        },
        oy2 = 0,
      },
      {
        type = "rect",
        color = 1,
        y2 = 3,
        x1 = 2,
        border = {
          color = 0,
          type = 1,
        },
        x2 = 14,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 2,
          },
          update = {
            [ 2 ] = -1,
          },
        },
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap top",
        },
        y1 = 2,
      },
      {
        color = 1,
        y2 = 36,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 2,
        oy1 = 2,
        type = "rect",
        event = {
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 2,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
        },
        x2 = 14,
        y1 = 35,
        snap = {
          Top = "Snap bottom",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap bottom",
        },
        oy2 = 1,
      },
      {
        type = "rect",
        color = 1,
        y2 = 19,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 4,
          },
          update = {
            [ 2 ] = -1,
          },
        },
        x1 = 21,
        y1 = 18,
        x2 = 23,
        border = {
          color = 0,
          type = 1,
        },
      },
    },
    c = 2,
  },
}

for s=1,#slides do
		local slide = slides[s]
		for o=1,#slide.objs do
			local obj = slide.objs[o]
			for key,value in pairs(obj.event) do
				if assets[ value[2] ] then
					lUtils.shapescape.addScript(obj,value[2],key,assets,LevelOS,slides)
				else
					obj.event[key] = {function() end,-1}
				end
			end
		end
	end

		local tArgs = {...}
	if tArgs[1] and tArgs[1] == "load" then
		return {assets=assets,slides=slides}
	end

	
	lUtils.shapescape.run(slides)