local tArgs = {...}
if tArgs[1] == nil or fs.exists(tArgs[1]) == false then
	tFolder = ""
else
	tFolder = tArgs[1]
end
multisel = true
if tArgs[2] == nil then
	tMode = "Normal" -- can be Normal, SelFolder or SelFile
else
	tMode = tArgs[2]
	if tArgs[3] ~= nil then
		if tArgs[3] == "true" then
			multisel = true
		else
			multisel = false
		end
	end
end
sect = {}
w,h = term.getSize()
sect[1] = {name="Name",w=math.floor(w/2)-5}
sect[2] = {name="Type",w=13}
sect[3] = {name="Size",w=10}
tCol = {file=colors.white,folder=colors.yellow,bg=colors.black,bar=colors.gray,scroll=colors.black,txt=colors.white,sel=colors.gray}
--tCol = {file=colors.lightGray,folder=colors.yellow,bg=colors.white,bar=colors.lightGray,scroll=colors.gray,txt=colors.black,sel=colors.blue}
scrlF = 0 -- scroll files
selected = {}
local fTypes
if fs.exists("LevelOS/data/openwith.lconf") then
	fTypes = lUtils.asset.load("LevelOS/data/openwith.lconf")
else
	fTypes = {}
	fTypes[".lua"] = {"Lua script",{"Execute","Edit","Open with..."},{"Lua","rom/programs/edit.lua"}}
	fTypes[".txt"] = {"Text file",{"Edit","Open with..."},{"LevelOS/notepad.lua","LevelOS/notepad.lua"}}
	fTypes[".lconf"] = {"Config file",{"Edit"},{"LevelOS/notepad.lua","LevelOS/notepad.lua"}}
	fTypes[".config"] = {"Config file",{"Edit"},{"LevelOS/notepad.lua","LevelOS/notepad.lua"}}
	fTypes[".limg"] = {"lImg file",{"View"},{"LevelOS/imageviewer.lua"}}
	fTypes[".nfp"] = {"NFP file",{"View","Edit"},{"LevelOS/imageviewer.lua","rom/programs/fun/advanced/paint.lua"}}
	fTypes[".nfg"] = {"NFG file",{"View"},{"LevelOS/imageviewer.lua"}}
	lUtils.asset.save(fTypes,"LevelOS/data/openwith.lconf")
end
term.setBackgroundColor(tCol.bg)
--term.setPaletteColor(colors.gray,32/255,32/255,32/255)
--term.setPaletteColor(colors.yellow,1,0.9,0)
term.clear()
local disks = {peripheral.find("drive",function(name,object) return object.isDiskPresent() end)}
for t=1,#disks do
	disks[disks[t].getMountPath()] = disks[t]
end
if lOS.fClipboard == nil then
	lOS.fClipboard = {}
end
if lOS.fCut == nil then
	lOS.fCut = {}
end
to_colors, to_blit = {}, {}
for i = 1, 16 do
    to_blit[2^(i-1)] = ("0123456789abcdef"):sub(i, i)
    to_colors[("0123456789abcdef"):sub(i, i)] = 2^(i-1)
end
finalresult = {}
function _G.uFP(filepath2) -- unique filepath
	if fs.exists(filepath2) == true then
		t = 1
		while fs.exists(string.sub(filepath2,1,string.len(filepath2)-string.len(lUtils.getFileType(filepath2))).."_("..t..")"..lUtils.getFileType(filepath2)) == true do
			t = t+1
		end
		filepath2 = string.sub(filepath2,1,string.len(filepath2)-string.len(lUtils.getFileType(filepath2))).."_("..t..")"..lUtils.getFileType(filepath2)
	end
	return filepath2
end
function folderIco(filepath)
	for x=1,math.floor(w/8) do
        for y=1,math.floor((h-2)/5) do
            if lOS.icons[y][x].path ~= nil then
                if lOS.icons[y][x].path == filepath then
                    return false
                end
            else
                local fg = colors.black
                local bg = colors.yellow
                while bg == fg do
                    bg = 2^(math.random(0,15))
                end
                local fname = string.gsub(fs.getName(filepath),"%.%a+$","")
				local ylw = tostring(to_blit[colors.yellow])
				local orn = tostring(to_blit[colors.white])
				local blit1 = ylw..ylw..orn
				local blit2 = ylw..ylw..orn
				local blit3 = ylw..ylw..ylw
              	lOS.icons[y][x] = {fg=fg,bg=bg,iType="blit",ico={{"  \149",blit3,blit1},{"  \130",blit1,blit3},{"   ",blit3,blit3}},path="LevelOS/explorer.lua",args=filepath,name=string.upper(string.sub(fname,1,1))..string.sub(fname,2,7)}
				--lOS.icons[y][x] = {fg=fg,bg=bg,iType="blit",ico={{string.sub(fname,1,2).." ",blit1,blit1},{"  \148",blit3,blit2},{"  \149",blit3,blit2}},path="LevelOS/explorer.lua",args=filepath,name=string.upper(string.sub(fname,1,1))..string.sub(fname,2,7)}
				lOS.icons[y][x].args = filepath
                return true
            end
        end
    end
end
function txtIco(filepath)
	for x=1,math.floor(w/8) do
        for y=1,math.floor((h-2)/5) do
            if lOS.icons[y][x].path ~= nil then
                if lOS.icons[y][x].path == filepath then
                    return false
                end
            else
                local fg = colors.black
                local bg = colors.yellow
                while bg == fg do
                    bg = 2^(math.random(0,15))
                end
                local fname = string.gsub(fs.getName(filepath),"%.%a+$","")
				local blit1 = "880"
				local blit2 = "877"
				local blit3 = "888"
                lOS.icons[y][x] = {fg=fg,bg=bg,iType="blit",ico={{" \149\139",blit1,blit2},{"   ",blit3,blit3},{"   ",blit3,blit3}},path="LevelOS/notepad.lua",args=filepath,name=string.upper(string.sub(fname,1,1))..string.sub(fname,2,7)}
				lOS.icons[y][x].args = filepath
                return true
            end
        end
    end
end
function openfile(file)
	if fs.isDir(file) == true then
		local w,h = term.getSize()
		tFolder = file
		scrlF = 0
		selected = {}
		scanfiles()
		drawfiles(fX,fY,w-1,h-1)
		topbar()
	elseif tMode ~= "SelFile" and tMode ~= "Sel" then
		if lUtils.getFileType(file) == "" or lUtils.getFileType(file) == ".lua" then
			lOS.execute(file)
		elseif fTypes[lUtils.getFileType(file)] ~= nil and fTypes[lUtils.getFileType(file)][3] ~= nil and fTypes[lUtils.getFileType(file)][3][1] ~= nil then
			if fs.exists(file.."updater") == true then
				if fTypes[lUtils.getFileType(file)][3][1] == "LevelOS/notepad.lua" then
					lOS.execute("LevelOS/notepad.lua "..file.."updater true") -- make read only
				else
					lOS.execute(fTypes[lUtils.getFileType(file)][3][1].." "..file.."updater")
				end
			else
				lOS.execute(fTypes[lUtils.getFileType(file)][3][1].." "..file)
			end
		else
			if fs.exists(file.."updater") == true then
				lOS.execute("rom/programs/edit.lua "..file.."updater")
			else
				lOS.execute("rom/programs/edit.lua "..file)
			end
		end
	else
		finalresult = {file}
	end
end
function split(str, pat)
   local t = {}  -- NOTE: use {n = 0} in Lua-5.0
   local fpat = "(.-)" .. pat
   local last_end = 1
   local s, e, cap = str:find(fpat, 1)
   while s do
      if s ~= 1 or cap ~= "" then
         table.insert(t,cap)
      end
      last_end = e+1
      s, e, cap = str:find(fpat, last_end)
   end
   if last_end <= #str then
      cap = str:sub(last_end)
      table.insert(t, cap)
   end
   return t
end
function split_path(str)
   return split(str,'[\\/]+')
end
local tTerminate = false
function bottombar()
	local btns = {}
	if tMode == "Sel" or tMode == "SelFolder" or tMode == "SelFile" then
		local function gengui()
			local w,h = term.getSize()
			term.setBackgroundColor(tCol.bar)
			term.setTextColor(tCol.txt)
			term.setCursorPos(1,h-4)
			term.clearLine()
			term.setCursorPos(1,h-3)
			term.clearLine()
			term.setCursorPos(1,h-3)
			term.write("  File Name: ")
			term.setBackgroundColor(colors.white)
			term.setTextColor(colors.black)
			--if #selected > 1 then
				for t=1,#selected do
					local file = fs.combine(tFolder,tFiles[selected[t]])
					if not ((tMode == "SelFile" and fs.isDir(file) == true) or (tMode == "SelFolder" and fs.isDir(file) == false)) then
						if term.getCursorPos() <= w-2 then
							if #selected == 1 then
								term.write(" "..fs.getName(file))
							else
								term.write(string.sub(' "'..fs.getName(file)..'"',1,(w-2)-({term.getCursorPos()})[1]))
							end
						end
					end
				end
			--else
				--term.write(fs.getName(tFiles[selected[t]]))
			--end
			local writethis = ""
			for t=({term.getCursorPos()})[1],w-2 do
				writethis = writethis.." "
			end
			term.write(writethis)
			term.setCursorPos(1,h-2)
			term.setBackgroundColor(tCol.bar)
			term.clearLine()
			term.setCursorPos(1,h-1)
			term.clearLine()
			btns = {{"Cancel"},{"Select"}}
			local cX = w
			term.setBackgroundColor(colors.lightGray)
			term.setTextColor(colors.black)
			for t=1,#btns do
				btns[t].w = string.len(btns[t][1])+2
				cX = cX - (btns[t].w+1)
				btns[t].x = cX
				term.setCursorPos(cX,h-1)
				term.write(" "..btns[t][1].." ")
			end
			term.setCursorPos(1,h)
			term.setBackgroundColor(tCol.bar)
			term.clearLine()
		end
		gengui()
		local ow,oh = term.getSize()
		while true do
			local e = {os.pullEvent()}
			local w,h = term.getSize()
			if w ~= ow or h ~= oh then
				ow,oh = w,h
				gengui()
			end
			gengui()
			if e[1] == "mouse_click" or e[1] == "mouse_up" then
				for t=1,#btns do	
					if e[4] == h-1 and e[3] >= btns[t].x and e[3] <= btns[t].x+btns[t].w-1 then
						if e[1] == "mouse_click" then
							term.setCursorPos(btns[t].x,h-1)
							term.setBackgroundColor(colors.lightBlue)
							term.setTextColor(colors.black)
							term.write(" "..btns[t][1].." ")
						elseif e[1] == "mouse_up" then
							if btns[t][1] == "Select" then
								for t=1,#selected do
									local file = fs.combine(tFolder,tFiles[selected[t]])
									if not ((tMode == "SelFile" and fs.isDir(file) == true) or (tMode == "SelFolder" and fs.isDir(file) == false)) then
										finalresult[#finalresult+1] = file
										os.startTimer(0.2)
									end
								end
							elseif btns[t][1] == "Cancel" then
								tTerminate = true
								os.startTimer(0.2)
							end
						end
					end
					if e[1] == "mouse_up" then
						term.setCursorPos(btns[t].x,h-1)
						term.setBackgroundColor(colors.lightGray)
						term.setTextColor(colors.black)
						term.write(" "..btns[t][1].." ")
					end
				end
			end
		end
	end
end
function locateEntry(tTable,tEntry)
    for t=1,#tTable do
        if tTable[t] == tEntry then
            return true,t
        end
    end
    return false,0
end
function scanfiles()
	disks = {peripheral.find("drive",function(name,object) return object.isDiskPresent() end)}
	for t=1,#disks do
		disks[disks[t].getMountPath()] = disks[t]
	end
    tFiles = fs.list(tFolder)
    local afolders = 0
    for t=1,#tFiles do
        if fs.isDir(fs.combine(tFolder,tFiles[t])) == true then
            afolders = afolders+1
			local atemp = tFiles[t]
			table.remove(tFiles,t)
			table.insert(tFiles,afolders,atemp)
            --tFiles[t],tFiles[afolders] = tFiles[afolders],tFiles[t]
        end
    end
    for t=1,#tFiles do
        if tFiles[t] ~= nil then
            if fs.exists(fs.combine(tFolder,tFiles[t]).."updater") == true then
                table.remove(tFiles,t+1)
            end
        end
    end
end
function drawfiles(x,y,x2,y2)
	if tMode == "Sel" or tMode == "SelFile" or tMode == "SelFolder" then
		y2 = y2-4
	end
	term.setBackgroundColor(tCol.bg)
	emptyline = ""
	for t=x,x2 do
		emptyline = emptyline.." "
	end
	for t=y,y2 do
		term.setCursorPos(x,t)
		term.write(emptyline)
	end
    local cX = x
    term.setTextColor(colors.lightGray)
    term.setBackgroundColor(tCol.bg)
	term.setCursorPos(1,y)
	term.clearLine()
    for t=1,#sect do
		sect[t].x = cX
        term.setCursorPos(cX,y)
        term.write(sect[t].name)
        term.setCursorPos(cX+sect[t].w,y)
        term.write("\149")
        cX = cX+sect[t].w+1
    end
	emptyline = ""
	for t=x,(sect[#sect].x+sect[#sect].w) do
		emptyline = emptyline.." "
	end
	y = y+1
    for t=1,#tFiles do
        cX = x
        if t+scrlF > 0 and t+scrlF <= #tFiles and y+t <= y2 then
            local file = fs.combine(tFolder,tFiles[t+scrlF])
            term.setCursorPos(x,y+t)
            if locateEntry(selected,t+scrlF) == true then
                term.setBackgroundColor(tCol.sel)
                term.write(emptyline)
            else
                term.setBackgroundColor(tCol.bg)
                term.write(emptyline)
            end
            term.setCursorPos(x,y+t)
            if fs.isDir(file) == true then
				if disks[file] ~= nil then
					term.setTextColor(colors.blue)
				else
	                term.setTextColor(tCol.folder)
				end
                term.write("\143")
            elseif locateEntry(lOS.fCut,file) ~= true then
				if fs.exists(file.."updater") == true then
					term.setTextColor(colors.lime)
				--elseif fs.isReadOnly(file) == true then
					--term.setTextColor(colors.red)
				else
	                term.setTextColor(tCol.file)
				end
                term.write("\143")
			else
				term.write(" ")
            end
			if fs.isReadOnly(file) == true then
				term.setTextColor(colors.lightGray)
			elseif locateEntry(lOS.fCut,file) ~= true then
	            term.setTextColor(tCol.txt)
			else
				term.setTextColor(colors.lightGray)
			end
			if disks[file] ~= nil and disks[file].getDiskLabel() ~= nil then
	            term.write(string.sub(" "..string.gsub(fs.getName(file),"_"," ").." ("..disks[file].getDiskLabel()..")",1,sect[1].w-1))
			else
	            term.write(string.sub(" "..string.gsub(fs.getName(file),"_"," "),1,sect[1].w-1))
			end
            cX = cX+sect[1].w+1
            term.setCursorPos(cX,y+t)
            if fs.isDir(file) == true then
				if disks[file] ~= nil then
					term.write("Disk")
				else
	                term.write("Folder")
				end
            else
                filetype = lUtils.getFileType(file)
                if filetype == "" then
                    writethis = "File"
                elseif fTypes[filetype] ~= nil then
                    writethis = fTypes[filetype][1]
                else
                    writethis = string.upper(string.sub(filetype,2,string.len(filetype))).."-file"
                end
                if string.len(writethis) > sect[2].w then
                    writethis = string.sub(writethis,1,sect[2].w-3).."..."
                end
                term.write(writethis)
            end
            cX = cX+sect[2].w+1
            writethis = (math.floor(fs.getSize(file)/100+0.5)/10).." kB"
            term.setCursorPos((cX+sect[3].w-1)-string.len(writethis),y+t)
            if fs.isDir(file) == false then
                term.write(writethis)
            end
        end
    end
end
term.setCursorPos(1,h)
term.setBackgroundColor(tCol.bar)
term.clearLine()
tpY = 1 -- topbar Y
tblen = w-14
fY = 4 -- files Y
fX = 2 -- files X
function topbar()
	term.setCursorPos(1,tpY)
	term.setBackgroundColor(tCol.bg)
	term.clearLine()
	term.setCursorPos(1,tpY+1)
	term.clearLine()
	term.setCursorPos(1,tpY+2)
	term.clearLine()
	term.setCursorPos(1,tpY)
	term.setTextColor(tCol.txt)
	term.write("   ")
	term.setBackgroundColor(tCol.bar)
	term.setTextColor(tCol.bg)
	term.write("\151")
	term.setBackgroundColor(tCol.bg)
	term.setTextColor(tCol.bar)
	for t=1,tblen do
		term.write("\140")
	end
	term.write("\148")
	term.setCursorPos(1,tpY+1)
	term.setBackgroundColor(tCol.bg)
	term.setTextColor(tCol.txt)
	term.write(" \24 ")
	term.setBackgroundColor(tCol.bar)
	term.setTextColor(tCol.bg)
	term.write("\149")
	term.setBackgroundColor(tCol.bg)
	cPath = split_path(fs.combine("root",tFolder))
	local ix,iy = term.getCursorPos()
	for t=1,tblen do
		term.write(" ")
	end
	term.setCursorPos(ix+1,iy)
	for t=1,#cPath do
		term.setTextColor(tCol.txt)
		term.write(cPath[t])
		if cPath[t+1] ~= nil then
			term.setTextColor(colors.lightGray)
			term.write(" > ")
		end
	end
	term.setBackgroundColor(tCol.bg)
	term.setTextColor(tCol.bar)
	term.setCursorPos(tblen+5,tpY+1)
	term.write("\149")
	term.setCursorPos(4,tpY+2)
	term.write("\138")
	for t=1,tblen do
		term.write("\140")
	end
	term.write("\133")
end
scanfiles()
drawfiles(fX,fY,w-1,h-1)
topbar()
term.setBackgroundColor(tCol.bar)
term.setTextColor(tCol.txt)
term.setCursorPos(1,h)
term.write(#tFiles.." items |")
os.sleep(1)
drX = 0
dragging = false
_G.hold = {}
someweirdthing = coroutine.create(bottombar)
local e = {}
while true do
	oldw,oldh = w,h
	w,h = term.getSize()
	if oldw ~= w or oldh ~= h then
		term.setBackgroundColor(tCol.bg)
		term.clear()
		drawfiles(fX,fY,w-1,h-1)
		topbar()
		term.setCursorPos(1,h)
		term.setBackgroundColor(tCol.bar)
		term.clearLine()
		tblen = w-14
		os.startTimer(0.1)
	end
	if tMode == "Normal" then
		term.setBackgroundColor(tCol.bar)
		term.setTextColor(tCol.txt)
		term.setCursorPos(1,h)
		term.write(#tFiles.." items | "..scrlF.." | "..#lOS.fClipboard.." |                     ")
	else
		coroutine.resume(someweirdthing,unpack(e))
	end
	if #finalresult > 0 or tTerminate == true then
		return finalresult
	end
    e = {os.pullEvent()}
	if e[1] == "term_resize" then
		topbar()
	elseif e[1] == "mouse_click" then
		if e[2] == 1 and e[4] == fY then
			for t=1,#sect do
				if e[3] == sect[t].x+sect[t].w then
					dragging = true
					drX = e[3]
					drSect = sect[t]
					OGw = drSect.w
				end
			end
		elseif e[4] > fY+1 and ((tMode == "Normal" and e[4] <= h-1) or (tMode ~= "Normal" and e[4] <= h-5)) then
			local clickfile = false
		    for t=1,#tFiles do
		        if t+scrlF > 0 and t+scrlF <= #tFiles and fY+1+t == e[4] and e[3] <= (sect[#sect].x+sect[#sect].w) then
					local file = fs.combine(tFolder,tFiles[t+scrlF])
					clickfile = true
					if locateEntry(selected,t+scrlF) == false then
						if multisel == false or not (hold[keys.leftShift]) then
							selected = {}
						end
						selected[#selected+1] = t+scrlF
						drawfiles(fX,fY,w-1,h-1)
					elseif e[2] == 1 and hold[keys.leftShift] == true then
						table.remove(selected,({locateEntry(selected,t+scrlF)})[2])
						drawfiles(fX,fY,w-1,h-1)
					elseif e[2] == 1 and #selected == 1 then
						openfile(file)
					elseif e[2] == 1 then
						selected = {t+scrlF}
						drawfiles(fX,fY,w-1,h-1)
					end
					if e[2] == 2 then
						local options = {{},{"Cut","Copy"},{"Create Shortcut","Delete","Rename"}}
						local disabled = {}
						if fs.isReadOnly(file) == true then
							disabled = {Edit=true,Cut=true,Delete=true,Rename=true}
						elseif disks[file] ~= nil then
							disabled = {Edit=true,Cut=true,Delete=true,Rename=true}
							disabled["Create Shortcut"] = true
						end
						if fs.isDir(file) == true then
							options[1] = {"Open","Open in new window"}
						elseif fTypes[lUtils.getFileType(file)] ~= nil and fTypes[lUtils.getFileType(file)][2] ~= nil then
							options[1] = lUtils.instantiate(fTypes[lUtils.getFileType(file)][2])
						else
							options[1] = {"Open with...","Edit"}
						end
						if fs.isReadOnly(file) == true and locateEntry(options[1],"Edit") == true then
							options[1][({locateEntry(options[1],"Edit")})[2]] = "View"
						end
						if (tMode == "SelFolder" and fs.isDir(file) == true) or tMode == "Sel" then
							table.insert(options,1,"Select")
						elseif (tMode == "SelFile" and fs.isDir(file) == false) or tMode == "Sel" then
							table.insert(options,1,"Select")
						end
						b = {lUtils.clickmenu(e[3],e[4],30,options,nil,disabled)}
						if b[3] == "Execute" then
							lOS.execute(file)
						elseif b[3] == "Edit" or b[3] == "View" then
							local tProgram = "rom/programs/edit.lua"
							if fTypes[lUtils.getFileType(file)] ~= nil and fTypes[lUtils.getFileType(file)][3] ~= nil and fTypes[lUtils.getFileType(file)][3][2] ~= nil then
								tProgram = fTypes[lUtils.getFileType(file)][3][2]
							end
							if fs.exists(file.."updater") == true then
								if tProgram == "LevelOS/notepad.lua" then
									lOS.execute(tProgram.." "..file.."updater true")
								else
									lOS.execute(tProgram.." "..file.."updater")
								end
							else
								lOS.execute(tProgram.." "..file)
							end
						elseif b[3] == "Open" and fs.isDir(file) == true then
							tFolder = file
							scrlF = 0
							selected = {}
						elseif b[3] == "Open with..." then
							local tOptions = {"Lua"}
							if fTypes[lUtils.getFileType(file)] ~= nil and fTypes[lUtils.getFileType(file)][3] ~= nil then
								if locateEntry(fTypes[lUtils.getFileType(file)][3],"Lua") == true then
									tOptions = {}
								end
								for u=1,#fTypes[lUtils.getFileType(file)][3] do
									tOptions[#tOptions+1] = fTypes[lUtils.getFileType(file)][3][u]
								end
							end
							if not locateEntry(tOptions,"rom/programs/edit.lua") then
								table.insert(tOptions,2,"rom/programs/edit.lua")
							end
							local aOptions = {}
							for u=1,#tOptions do
								if not locateEntry(aOptions,string.upper(string.sub(fs.getName(tOptions[u]),1,1))..string.lower(string.sub(fs.getName(tOptions[u]),2,string.len(fs.getName(tOptions[u]))-string.len(lUtils.getFileType(fs.getName(tOptions[u])))))) then
									aOptions[u] = string.upper(string.sub(fs.getName(tOptions[u]),1,1))..string.lower(string.sub(fs.getName(tOptions[u]),2,string.len(fs.getName(tOptions[u]))-string.len(lUtils.getFileType(fs.getName(tOptions[u])))))
									tOptions[aOptions[u]] = tOptions[u]
								end
							end
							local xpos,ypos = e[3],e[4]
							ypos = ypos+1
							local w,h = term.getSize()
							if xpos + 29 < w then
								xpos = xpos + 29
							elseif xpos - 15 > 1 then
								xpos = xpos - 15
							end
							u = {lUtils.clickmenu(xpos,ypos,15,{aOptions},true)}
							if u[1] == true then
								if u[3] == "Lua" then
									lOS.execute(file)
								else
									lOS.execute(tOptions[u[3]].." "..file)
								end
							end
						elseif b[3] == "Delete" then
							for a=1,#selected do
								if fs.exists(fs.combine(tFolder,tFiles[selected[a]].."updater")) == true then
									fs.delete(fs.combine(tFolder,tFiles[selected[a]].."updater"))
								end
								fs.delete(fs.combine(tFolder,tFiles[selected[a]]))
							end
							selected = {}
						elseif b[3] == "Create Shortcut" then
							for a=1,#selected do
								if fs.isDir(fs.combine(tFolder,tFiles[selected[a]])) == true then
									folderIco(fs.combine(tFolder,tFiles[selected[a]]))
								elseif lUtils.getFileType(tFiles[selected[a]]) == ".lua" or lUtils.getFileType(tFiles[selected[a]]) == "" then
									lOS.genIco(fs.combine(tFolder,tFiles[selected[a]]))
								else
									txtIco(fs.combine(tFolder,tFiles[selected[a]]))
								end
							end
						elseif b[3] == "Cut" then
							lOS.fClipboard = {}
							lOS.fCut = {}
							for a=1,#selected do
								lOS.fClipboard[#lOS.fClipboard+1] = fs.combine(tFolder,tFiles[selected[a]])
								lOS.fCut[#lOS.fCut+1] = fs.combine(tFolder,tFiles[selected[a]])
							end
							selected = {}
						elseif b[3] == "Copy" then
							lOS.fClipboard = {}
							lOS.fCut = {}
							for a=1,#selected do
								lOS.fClipboard[#lOS.fClipboard+1] = fs.combine(tFolder,tFiles[selected[a]])
							end
						elseif b[3] == "Rename" then
							drawfiles(fX,fY,w-1,h-1)
							topbar()
							local oldmag = {term.getPaletteColor(colors.magenta)}
							local thebox = {width=sect[1].w-4,height=1,sTable={background={colors.magenta},text={colors.white},cursor={colors.red}},filepath="",lines={fs.getName(file)},changed=false}
							term.setPaletteColor(colors.magenta,0.15,0.15,0.15)
							lUtils.drawEditBox(thebox,4,e[4],0,0,string.len(fs.getName(file))+1,1,true,false)
							if fs.exists(fs.combine(tFolder,thebox.lines[1])) then
								if fs.combine(tFolder,thebox.lines[1]) ~= file then
									lUtils.popup("Error","File exists!",29,9,{"Cancel"})
								end
							else
								fs.move(file,fs.combine(tFolder,thebox.lines[1]))
							end
							term.setPaletteColor(colors.magenta,table.unpack(oldmag))
						end
						scanfiles()
						drawfiles(fX,fY,w-1,h-1)
						topbar()
					end
				end
			end
			if clickfile == false and e[2] == 2 then
				local abcdefg = false
				if #lOS.fClipboard < 1 then
					abcdefg = true
				end
				local abcd
				if ccemux then
					abcd = "Open External Explorer"
				end
				b = {lUtils.clickmenu(e[3],e[4],30,{"Refresh","Paste",{"New Folder","New File"},abcd},true,{Paste=abcdefg})}
				if b[3] == "Paste" then
					for c=1,#lOS.fClipboard do
						if fs.exists(lOS.fClipboard[c]) == true then
							fs.copy(lOS.fClipboard[c],uFP(fs.combine(tFolder,fs.getName(lOS.fClipboard[c]))))
						end
						if locateEntry(lOS.fCut,lOS.fClipboard[c]) == true then
							fs.delete(lOS.fClipboard[c])
							table.remove(lOS.fCut,({locateEntry(lOS.fCut,lOS.fClipboard[c])})[2])
						end
					end
					lOS.fClipboard = {}
					lOS.fCut = {}
					scanfiles()
				elseif b[3] == "Refresh" then
					scanfiles()
				elseif b[3] == "New Folder" then
					d = {lUtils.inputbox("New Folder","Folder name:",30,9,{"Done","Cancel"})}
					if d[2] ~= false and d[4] ~= "Cancel" and d[1] ~= "" then
						--if fs.exists(fs.combine(tFolder,d[1])) == true then
							--lUtils.popup("Error","This path already exists!",27,9,{"Cancel"})
						--else
							fs.makeDir(uFP(fs.combine(tFolder,d[1])))
							scanfiles()
						--end
					end
				elseif b[3] == "New File" then
					d = {lUtils.inputbox("New File","File name:",30,9,{"Done","Cancel"})}
					if d[2] ~= false and d[4] ~= "Cancel" and d[1] ~= "" then
						--if fs.exists(fs.combine(tFolder,d[1])) == true then
							--lUtils.popup("Error","This file already exists!",27,9,{"Cancel"})
						--else
							local abc = fs.open(uFP(fs.combine(tFolder,d[1])),"w")
							abc.close()
							scanfiles()
						--end
					end
				elseif b[3] == abcd then
					ccemux.openDataDir()
				end
			end
			if clickfile == false then
				selected = {}
				drawfiles(fX,fY,w-1,h-1)
				topbar()
			end
		end
	elseif e[1] == "mouse_drag" then
		if dragging == true then
			if OGw-(drX-e[3]) > 6 then
				drSect.w = OGw-(drX-e[3])
				drawfiles(fX,fY,w-1,h-1)
			end
		end
	elseif e[1] == "mouse_up" then
		dragging = false
		if e[3] >= 1 and e[3] <= 3 and e[4] >= tpY and e[4] <= tpY+2 and tFolder ~= "" then
			tFolder = fs.getDir(tFolder)
			selected = {}
			scrlF = 0
			scanfiles()
			drawfiles(fX,fY,w-1,h-1)
			topbar()
		end
	elseif e[1] == "mouse_scroll" then
		if e[4] > fY and scrlF+e[2] >= 0 then
			scrlF = scrlF+e[2]
			drawfiles(fX,fY,w-1,h-1)
		end
	elseif e[1] == "key" then
		hold[e[2]] = true
		if tMode == "Normal" and hold[keys.leftCtrl] and e[2] == keys.a then
			selected = {}
			for t=1,#tFiles do
				selected[#selected+1] = t
				drawfiles(fX,fY,w-1,h-1)
			end
		end
	elseif e[1] == "key_up" then
		hold[e[2]] = nil
	end
	if #finalresult > 0 or tTerminate == true then
		return finalresult
	end
end
os.sleep(10)