local assets = {
  [ "init.lua" ] = {
    id = 4,
    content = "local w,h = 27,13\
LevelOS.setWin(27,13,\"widget\")\
local tw,th = lOS.wAll.getSize()\
LevelOS.self.window.win.reposition(tw-w,th-(h+1))",
    name = "init.lua",
  },
  [ "offset_down.lua" ] = {
    id = 6,
    content = "lOS.settings.timeOffset = lOS.settings.timeOffset - 0.5",
    name = "offset_down.lua",
  },
  [ "offset.lua" ] = {
    id = 3,
    content = "if lOS.settings.timeOffset then\
    local o = lOS.settings.timeOffset\
    if o >= 0 then\
        self.txt = \"+\"..o\
    else\
        self.txt = tostring(o)\
    end\
end",
    name = "offset.lua",
  },
  [ "offset_up.lua" ] = {
    id = 5,
    content = "lOS.settings.timeOffset = lOS.settings.timeOffset + 0.5",
    name = "offset_up.lua",
  },
  [ "time.lua" ] = {
    id = 0,
    content = "if not lOS.settings.timeOffset then\
    lOS.settings.timeOffset = 0\
end\
local t = os.date(\"*t\",os.epoch(\"local\")/1000+lOS.settings.timeOffset*3600)\
term.setBackgroundColor(colors.gray)\
term.setTextColor(colors.white)\
term.setCursorPos(self.x1,self.y1)\
local function tz(n)\
    return string.rep(\"0\",2-string.len(n))..n\
end\
if lOS.settings.rTime then\
    bigfont.bigPrint(tz(t.hour)..\":\"..tz(t.min)..\":\"..tz(t.sec))\
else\
    local nTime = math.mod(os.time()+lOS.settings.timeOffset,24)\
    local nHour = math.floor(nTime)\
    local nMinute = math.floor((nTime - nHour) * 60)\
    bigfont.bigPrint(tz(nHour)..\":\"..tz(nMinute))\
end\
term.setTextColor(colors.lightGray)\
local days = {\"Sunday\",\"Monday\",\"Tuesday\",\"Wednesday\",\"Thursday\",\"Friday\",\"Saturday\"}\
local months = {\"Jan\",\"Feb\",\"Mar\",\"Apr\",\"May\",\"Jun\",\"Jul\",\"Aug\",\"Sep\",\"Oct\",\"Nov\",\"Dec\"}\
term.setCursorPos(self.x1,({term.getCursorPos()})[2])\
print(days[t.wday]..\", \"..months[t.month]..\" \"..t.day..\", \"..t.year)",
    name = "time.lua",
  },
  [ "switch_time.lua" ] = {
    id = 2,
    content = "lOS.settings.rTime = not lOS.settings.rTime",
    name = "switch_time.lua",
  },
  [ "slider.lua" ] = {
    id = 1,
    content = "local s = shapescape.getSlide()\
if not s.var then s.var = {} end\
\
local set = \"LevelOS/data/settings.lconf\"\
\
if lOS.settings.rTime == nil then\
    lOS.settings.rTime = false\
end\
\
local r = string.rep\
\
local rtime = lOS.settings.rTime\
\
local w,h = term.getSize()\
\
if rtime then\
    term.setBackgroundColor(colors.green)\
    term.setCursorPos(1,1)\
    term.write(r(\" \",w-1))\
    term.setBackgroundColor(colors.white)\
    term.write(\" \")\
else\
    term.setCursorPos(1,1)\
    term.setBackgroundColor(colors.white)\
    term.write(\" \")\
    term.setBackgroundColor(colors.red)\
    term.write(r(\" \",w-1))\
end\
\
while true do\
    local w,h = term.getSize()\
    if lOS.settings.rTime ~= rtime then\
        rtime = lOS.settings.rTime\
        local b1,b2,fg\
        b1 = \"d\"\
        b2 = \"e\"\
        fg = \"0\"\
        local a,b,c\
        if rtime then\
            a,b,c = 1,w,1\
        else\
            a,b,c = w,1,-1\
        end\
        for x=a,b,c do\
            local d,e = x-1,w-x\
            term.setCursorPos(1,1)\
            term.blit(r(\" \",d)..\" \"..r(\" \",e),r(\"f\",w),r(b1,d)..fg..r(b2,e))\
            os.sleep(0.05)\
        end\
    end\
    e = {os.pullEvent()}\
end",
    name = "slider.lua",
  },
}

local nAssets = {}
for key,value in pairs(assets) do nAssets[key] = value nAssets[assets[key].id] = assets[key] end
assets = nAssets
nAssets = nil

local slides = {
  {
    y = 20,
    x = 61,
    h = 19,
    w = 51,
    objs = {
      {
        type = "rect",
        color = 128,
        y2 = 13,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 4,
          },
        },
        x1 = 1,
        y1 = 1,
        x2 = 27,
        border = {
          color = 256,
          type = 1,
        },
      },
      {
        x2 = 26,
        y2 = 4,
        border = {
          color = 128,
          type = 1,
        },
        x1 = 3,
        txt = "",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = 0,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        txtcolor = 1,
        color = 128,
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap top",
        },
        y1 = 2,
      },
      {
        type = "rect",
        color = 128,
        y2 = 8,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 2,
        y1 = 7,
        x2 = 26,
        border = {
          color = 256,
          type = 1,
        },
      },
      {
        type = "rect",
        color = 128,
        y2 = 8,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 2,
        y1 = 8,
        x2 = 26,
        border = {
          color = 0,
          type = 1,
        },
      },
      {
        type = "rect",
        color = 128,
        y2 = 7,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 2,
        border = {
          color = 0,
          type = 1,
        },
        y1 = 7,
        x2 = 2,
      },
      {
        type = "rect",
        color = 128,
        y2 = 7,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 26,
        y1 = 7,
        x2 = 26,
        border = {
          color = 0,
          type = 1,
        },
      },
      {
        txt = "Use real time",
        type = "text",
        color = 128,
        y2 = 8,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 11,
        y1 = 8,
        x2 = 23,
        border = {
          color = 0,
          type = 1,
        },
        input = false,
        txtcolor = 1,
      },
      {
        txt = "+0",
        type = "text",
        color = 1,
        y2 = 12,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = 3,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 3,
        y1 = 10,
        x2 = 9,
        border = {
          color = 256,
          type = 1,
        },
        input = false,
        txtcolor = 32768,
      },
      {
        x2 = 9,
        y2 = 10,
        y1 = 10,
        x1 = 3,
        txt = "   ",
        type = "text",
        event = {
          mouse_up = {
            [ 2 ] = 5,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        txtcolor = 1,
        input = false,
        color = 256,
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap top",
        },
        border = {
          color = 0,
          type = 1,
        },
      },
      {
        txt = "   ",
        type = "text",
        color = 256,
        y2 = 12,
        y1 = 12,
        x1 = 3,
        event = {
          mouse_up = {
            [ 2 ] = 6,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        txtcolor = 1,
        x2 = 9,
        input = false,
        border = {
          color = 0,
          type = 1,
        },
      },
      {
        txt = "Offset (hours)",
        type = "text",
        color = 128,
        y2 = 11,
        event = {
          mouse_up = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
        },
        x1 = 11,
        y1 = 11,
        x2 = 26,
        border = {
          color = 0,
          type = 1,
        },
        input = false,
        txtcolor = 1,
      },
      {
        type = "window",
        color = 32768,
        y2 = 8,
        border = {
          color = 0,
          type = 1,
        },
        x1 = 3,
        y1 = 8,
        x2 = 9,
        snap = {
          Top = "Snap top",
          Right = "Snap left",
          Left = "Snap left",
          Bottom = "Snap top",
        },
        event = {
          mouse_up = {
            [ 2 ] = 2,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          Initialize = {
            [ 2 ] = -1,
          },
          selected = {
            [ 2 ] = -1,
          },
          update = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 1,
          },
        },
      },
    },
    c = 1,
  },
  {
    y = 20,
    x = 61,
    h = 19,
    w = 51,
    objs = {},
    c = 2,
  },
}

for s=1,#slides do
		local slide = slides[s]
		for o=1,#slide.objs do
			local obj = slide.objs[o]
			for key,value in pairs(obj.event) do
				if assets[ value[2] ] then
					lUtils.shapescape.addScript(obj,value[2],key,assets,LevelOS,slides)
				else
					obj.event[key] = {function() end,-1}
				end
			end
		end
	end

		local tArgs = {...}
	if tArgs[1] and tArgs[1] == "load" then
		return {assets=assets,slides=slides}
	end

	
	lUtils.shapescape.run(slides)