local function dothething()
	local completion = require "cc.completion"
	print("Welcome to the LevelOS setup program\nPress any key to continue")
	os.pullEvent("key")
	-- ask for disk
	local diskPath
	local function askDisk(id)
		term.setTextColor(colors.blue)
		print("Insert the disk labelled \"LevelOS "..id.."\" and enter the directory of the drive where this disk is located\nIf you are unsure and only have one disk drive, press enter.")
		os.sleep()
		term.setTextColor(colors.white)
		diskPath = read(nil, nil, nil, "disk")
		if not fs.isDir(diskPath) then printError("Directory invalid: doesn't exist or is a file.")
		elseif not fs.exists(fs.combine(diskPath, "info.txt")) then printError("Directory invalid: not a valid disk.")
		elseif fs.open(fs.combine(diskPath, "info.txt"), "r").readAll() ~= tostring(id) then printError("Directory invalid: wrong disk inserted.")
		else return end
		askDisk(id)
	end
	askDisk(1)
	print("Please take the time to read the entirety of this End User License Agreement.\n")
	term.setTextColor(colors.lightGray)
	print(fs.open(fs.combine(diskPath, "license.txt"), "r").readAll() or error("NO LICENSE FOUND\nMake sure you're not running any other programs."))
	term.setTextColor(colors.white)
	print("\nDo you accept? y/n")
	os.sleep()
	input = read(nil, nil, function(text) return completion.choice(text, {"y", "n"}) end, "y"):lower()
	if input ~= "y" then
		return false
	end
	print("Where would you like to install LevelOS to?\nIf you're unsure, press enter to install to root.")
	os.sleep()
	local installpath = read()
	if not fs.exists(installpath) then print("This path does not exist. Setup will create any missing directories automatically.") end
	print("\nPlease select the type of install you want:\nThe (f)ull version contains all programs for the full experience of LevelOS. (recommended)\nThe (m)inimal version only contains programs necessary for LevelOS to run. Choose this if you have limited storage space on your computer.\nType anything other than f or m to exit installation")
	local package = {["name"]="Full"} -- Default is a full install, in case this part fails
	os.sleep()
	input = read(nil, nil, function(text) return completion.choice(text, {"f", "m", "x"}) end):lower()
	if input == "m" then
		package = {
			["name"] = "Minimal",
			"LevelOS/assets/loading.limg",
			"LevelOS/startup/lUtils.lua",
			"LevelOS/Task_Manager.lua",
			2,
			"startup.lua",
			"LevelOS/desktop.lua",
			"LevelOS/system.lua",
			"LevelOS/Clock.lua",
			"LevelOS/SystemUI.lua",
			"LevelOS/explorer.lua",
			"LevelOS/startup/MwMRender",
		}
	elseif input == "f" then
		package = {
			["name"] = "Full",
			"LevelOS/assets/loading.limg",
			"LevelOS/startup/lUtils.lua",
			"LevelOS/Task_Manager.lua",
			2,
			"startup.lua",
			"LevelOS/desktop.lua",
			"LevelOS/system.lua",
			"LevelOS/Clock.lua",
			"LevelOS/SystemUI.lua",
			"LevelOS/explorer.lua",
			"LevelOS/startup/MwMRender",
			3,
			"LevelOS/Global_Login.lua",
			"LevelOS/imageviewer.lua",
			"LevelOS/LevelCloud.lua",
			"LevelOS/login.lua",
			"LevelOS/lStore.lua",
			"LevelOS/Pigeon.lua",
			"LevelOS/notepad.lua",
			"LevelOS/startup/LevelCloud.lua",
			"LevelOS/startup/LevelCloud.luaupdater",
			"LevelOS/assets/QR_Code.limg",
			"LevelOS/assets/wifi.limg"
		}
	else
		return false
	end
	term.setCursorPos(1,1)
	term.clear()
	term.setTextColor(colors.cyan)
	print("That's all we need from you.\nSetup will now install LevelOS on your computer.\nThis might take a while. Don't turn off your computer.")
	os.sleep(1)
	term.setTextColor(colors.white)
	for p=1, #package do
		if type(package[p]) == "number" then
			askDisk(package[p])
		else
			fs.copy(fs.combine(diskPath, package[p]), fs.combine(installpath, package[p]))
			print(fs.combine(diskPath, package[p]).." => "..fs.combine(installpath, package[p]))
		end
		os.sleep()
	end
	local h = fs.open(fs.combine(installpath, "LevelOS/data/settings.lconf"),"w")
	h.write(textutils.serialize({package=package.name}))
	h.close()
	print("Package submitted")
	print("Setup has completed\nYou must now restart your computer for changes to take effect. Would you like to do that right now?")
	input = read(nil, nil, function(text) return completion.choice(text, {"y", "n"}) end, "y"):lower()
	if input == "y" then
		os.sleep()
		os.reboot()
	end
end

local ok,err = pcall(dothething)
if not ok then
	printError("Uh oh! Something bad happened.\nTell your system administrator this:\n"..err)
end