local lib = require("/User/Cloud/Public/Storage_Manager/api")
local x,y = term.getCursorPos()

local function wr(txt)
	term.setCursorPos(x,y)
	term.clearLine()
	term.setCursorPos(x,y)
	term.write(txt)
end

local tArgs = {...}
wr("Checking args...")
if not tArgs[1] or tArgs[1] == "help" or not tArgs[2] or not tonumber(tArgs[2]) then
	wr("Usage: output <item> [amount]")
	print("")
	return
end

if not _G.setupCache then
	wr("Loading setup...")
	_G.setupCache = {lib.getSetup()}
end
local chests, input, output = unpack(setupCache)

local inv
if not _G.invCache then
	wr("Loading inventory...")
	inv = lib.getInventory(chests)
	_G.invCache = inv
else
	inv = invCache
end
wr("Outputting items...")
local ok, err = lib.outputItem(tArgs[1], tonumber(tArgs[2]), output, inv)
if not ok then
	print("Failed: "..tostring(err))
	return
end
--wr("Reloading inv...")
--_G.invCache = lib.getInventory(chests)
wr("Done!")
print("")