local assets = {
  [ "nextpage.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
\
local pageCount = math.ceil(#var.catPages/2)\
if var.page < pageCount then\
\9var.page = var.page+1\
\9os.queueEvent(\"render_cats\")\
end",
    id = 8,
    name = "nextpage.lua",
  },
  [ "listitems.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local slide = shapescape.getSlide()\
local var = slides.var\
\
local items = {}\
var.items = items\
local selItem = {}\
var.selItem = selItem\
local scrollPos = 0\
\
local function genItems(tItems, tTarget)\
\9local slide = shapescape.getSlide()\
\9local result\
\9if not tItems then\
\9\9scrollPos = 0\
\9\9selItem = {}\
\9\9var.selItem = selItem\
\9\9items = {}\
\9\9result = items\
\9else\
\9\9result = tItems\
\9end\
\9local target\
\9if tTarget then\
\9\9target = tTarget\
\9elseif var.group == \"All\" then\
\9\9target = var.inv\
\9else\
\9\9target = var.inv.groups[var.group]\
\9\9--[[if not target then\
\9\9\9_G.debugGroup = var.group\
\9\9\9_G.debugVar2 = var.groups\
\9\9end]]\
\9end\
\9for _,item in ipairs(target) do\
\9\9if item.items and #item.items == 1 and not item.nbt then\
\9\9\9item.name = item.items[1].name\
\9\9\9item.chest = item.items[1].chest\
\9\9end\
\9\9if item.chest then\
\9\9\9item.chestName = peripheral.getName(item.chest)\
\9\9end\
\9\9if slide.searchbox and #slide.searchbox.txt > 0 then\
\9\9\9local srch = slide.searchbox.txt:lower()\
\9\9\9if\
\9\9\9\9item.name:lower():find(srch, nil, true) or\
\9\9\9\9item.id:find(srch, nil, true) or\
\9\9\9\9(item.chestName and item.chestName:find(srch, nil, true))\
\9\9\9then\
\9\9\9\9table.insert(result, item)\
\9\9\9elseif item.items then\
\9\9\9\9for _,child in ipairs(item.items) do\
\9\9\9\9\9if child.chest then\
\9\9\9\9\9\9child.chestName = peripheral.getName(child.chest)\
\9\9\9\9\9end\
\9\9\9\9\9if\
\9\9\9\9\9\9child.name:lower():find(srch, nil, true) or\
\9\9\9\9\9\9(child.chestName and child.chestName:find(srch, nil, true))\
\9\9\9\9\9then\
\9\9\9\9\9\9table.insert(result, child)\
\9\9\9\9\9\9-- if this doesn't work properly, insert item and break\
\9\9\9\9\9end\
\9\9\9\9end\
\9\9\9end\
\9\9else\
\9\9\9table.insert(result,item)\
\9\9end\
\9end\
\9if not var.sortOn then var.sortOn = \"name\" end\
\9if var.sortIncreasing then\
\9\9table.sort(result, function(a,b) return a[var.sortOn] < b[var.sortOn] end)\
\9else\
\9\9table.sort(result, function(a,b) return a[var.sortOn] > b[var.sortOn] end)\
\9end\
\9if tItems then\
\9\9return result\
\9else\
\9\9var.items = items\
\9end\
end\
\
var.genItems = genItems\
\
genItems()\
\
local scrollUp, scrollDown\
local function renderItem(item)\
\9if selItem[item] or (item.parent and selItem[item.parent]) then\
\9\9term.setBackgroundColor(colors.green)\
\9elseif item.parent then\
\9\9term.setBackgroundColor(colors.white)\
\9else\
\9\9term.setBackgroundColor(colors.white)\
\9end\
\9local _,y = term.getCursorPos()\
\9term.clearLine()\
\9term.setCursorPos(1,y)\
\9if item.dropdown then\
\9\9if not item.expanded then\
\9\9\9term.setTextColor(colors.lightGray)\
\9\9\9term.write(\"\\16 \")\
\9\9else\
\9\9\9term.setTextColor(colors.gray)\
\9\9\9term.write(\"\\31 \")\
\9\9end\
\9else\
\9\9term.write(\"  \")\
\9end\
\9if item.nbt then\
\9\9term.setTextColor(colors.red)\
\9else\
\9\9term.setTextColor(colors.black)\
\9end\
\9local x = 3\
\9if item.parent then\
\9\9term.write(\"  \")\
\9\9x = 5\
\9end\
\9term.write(item.name:sub(1, 2+var.fieldWidth.Name-x+1))\
\9x = 3 + var.fieldWidth.Name + 1\
\9term.setCursorPos(x, y)\
\9term.setTextColor(colors.black)\
\9term.write(tostring(item.count):sub(1, var.fieldWidth.Count))\
\9x = x + var.fieldWidth.Count + 1\
\9term.setCursorPos(x, y)\
\9term.write(item.id:sub(1, var.fieldWidth.ID))\
end\
\
local function renderItems()\
\9scrollUp, scrollDown = false,false\
\9term.setBackgroundColor(colors.white)\
\9term.clear()\
\9local w,h = term.getSize()\
\9local y = 1 - scrollPos\
\9if y < 1 then\
\9\9scrollDown = true\
\9end\
\9for _,i in ipairs(items) do\
\9\9\
\9\9if i.items and #i.items > 1 then -- was 1, testing\
\9\9\9i.dropdown = true\
\9\9end\
\9\9i.y = y\
\9\9if y >= 1 and y <= h then\
\9\9\9term.setCursorPos(1, y)\
\9\9\9renderItem(i)\
\9\9end\
\9\9y = y + 1\
\9\9if i.items and i.expanded then\
\9\9\9for _,c in ipairs(i.items) do\
\9\9\9\9c.parent = i\
\9\9\9\9c.y = y\
\9\9\9\9if y >= 1 and y <= h then\
\9\9\9\9\9term.setCursorPos(1,y)\
\9\9\9\9\9renderItem(c)\
\9\9\9\9end\
\9\9\9\9y = y + 1\
\9\9\9end\
\9\9elseif i.enchantments and selItem[i] then\
\9\9\9for e,enchant in ipairs(i.enchantments) do\
\9\9\9\9if y >= 1 and y <= h then\
\9\9\9\9\9term.setCursorPos(1, y)\
\9\9\9\9\9term.setBackgroundColor(colors.green)\
\9\9\9\9\9term.clearLine()\
\9\9\9\9\9term.setCursorPos(3, y)\
\9\9\9\9\9term.setTextColor(colors.purple)\
\9\9\9\9\9term.write(tostring(enchant.displayName))\
\9\9\9\9\9x = 3 + var.fieldWidth.Name + 1\
\9\9\9\9\9term.setCursorPos(x, y)\
\9\9\9\9\9term.write(tostring(enchant.level))\
\9\9\9\9\9x = x + var.fieldWidth.Count + 1\
\9\9\9\9\9term.setCursorPos(x, y)\
\9\9\9\9\9term.write(tostring(enchant.name))\
\9\9\9\9end\
\9\9\9\9y = y + 1\
\9\9\9end\
\9\9end\
\9end\
\9if y-1 > h then\
\9\9scrollUp = true\
\9end\
end\
\
renderItems()\
\
while true do\
\9local e = {os.pullEvent()}\
\9local w,h = term.getSize()\
\9if e[1] == \"render_cats\" then\
\9\9genItems()\
\9\9renderItems()\
\9elseif slide.searchbox and slide.searchbox.state and (\
\9\9(e[1] == \"key\" and e[2] == keys.enter) or\
\9\9(e[1] == \"key\" and e[2] == keys.backspace) or\
\9\9e[1] == \"char\"\
\9) then\
\9\9genItems()\
\9\9renderItems()\
\9elseif e[1] == \"term_resize\" or e[1] == \"render_items\" then\
\9\9renderItems()\
\9elseif e[1]:find(\"mouse\") and e[3] and e[4] and e[3] >= 1 and e[4] >= 1 and e[3] <= w and e[4] <= h then\
\9\9if e[1] == \"mouse_scroll\" then\
\9\9\9if (e[2] == -1 and scrollDown) or (e[2] == 1 and scrollUp) then\
\9\9\9\9scrollPos = scrollPos + e[2]\
\9\9\9\9renderItems()\
\9\9\9end\
\9\9elseif e[1] == \"mouse_click\" or e[1] == \"mouse_drag\" then\
\9\9\9local oselItem = selItem\
\9\9\9if e[1] == \"mouse_click\" and not lUtils.isHolding(keys.leftCtrl) then\
\9\9\9\9selItem = {}\
\9\9\9\9var.selItem = selItem\
\9\9\9\9--renderItems()\
\9\9\9end\
\9\9\9local clickedThing = false\
\9\9\9for _,i in ipairs(items) do\
\9\9\9\9if e[4] == i.y then\
\9\9\9\9\9if e[3] == 1 and i.dropdown and e[1] == \"mouse_click\" then\
\9\9\9\9\9\9i.expanded = not i.expanded\
\9\9\9\9\9\9renderItems()\
\9\9\9\9\9elseif e[3] >= 3 then\
\9\9\9\9\9\9if oselItem[i] then\
\9\9\9\9\9\9\9selItem[i] = nil\
\9\9\9\9\9\9else\
\9\9\9\9\9\9\9selItem[i] = true\
\9\9\9\9\9\9end\
\9\9\9\9\9\9term.setCursorPos(1, i.y)\
\9\9\9\9\9\9renderItems()\
\9\9\9\9\9end\
\9\9\9\9\9clickedThing = true\
\9\9\9\9\9break\
\9\9\9\9end\
\9\9\9\9\
\9\9\9\9if i.items and i.expanded then\
\9\9\9\9\9for _,c in ipairs(i.items) do\
\9\9\9\9\9\9if e[4] == c.y and e[3] >= 5 then\
\9\9\9\9\9\9\9if oselItem[c] then\
\9\9\9\9\9\9\9\9selItem[c] = nil\
\9\9\9\9\9\9\9else\
\9\9\9\9\9\9\9\9selItem[c] = true\
\9\9\9\9\9\9\9end\
\9\9\9\9\9\9\9term.setCursorPos(1, c.y)\
\9\9\9\9\9\9\9renderItems()\
\9\9\9\9\9\9\9clickedThing = true\
\9\9\9\9\9\9\9break\
\9\9\9\9\9\9end\
\9\9\9\9\9end\
\9\9\9\9\9if clickedThing then\
\9\9\9\9\9\9break\
\9\9\9\9\9end\
\9\9\9\9end\
\9\9\9end\
\9\9\9if not clickedThing then\
\9\9\9\9renderItems()\
\9\9\9end\
\9\9end\
\9elseif e[1] == \"scan_inventory\" then\
\9\9var.group = \"All\"\
\9\9os.queueEvent(\"render_cats\")\
\9\9selItem = {}\
\9\9var.selItem = selItem\
\9\9var.loadMessage(\"Reloading\")\
\9\9os.sleep(0.4)\
\9\9parallel.waitForAny(\
\9\9\9function()\
\9\9\9\9--var.inv = var.lib.getInventory(var.chests)\
\9\9\9\9var.inv = {groups={},tags={},chests={}}\
\9\9\9\9cachedSS.inv = var.inv\
\9\9\9\9local cors = {}\
\9\9\9\9for _,chest in ipairs(var.chests) do\
\9\9\9\9\9table.insert(cors, function()\
\9\9\9\9\9\9var.lib.expandInventory(var.inv, chest)\
\9\9\9\9\9end)\
\9\9\9\9end\
\9\9\9\9parallel.waitForAll(unpack(cors))\
\9\9\9end,\
\9\9\9function()\
\9\9\9\9while true do\
\9\9\9\9\9genItems()\
\9\9\9\9\9renderItems()\
\9\9\9\9\9os.sleep(0.5)\
\9\9\9\9end\
\9\9\9end\
\9\9)\
\9\9var.endLoad()\
\9\9var.groups = {}\
\9\9for k,v in pairs(var.inv.groups) do\
\9\9\9table.insert(var.groups, k)\
\9\9end\
\9\9table.sort(var.groups)\
\9\9table.insert(var.groups, 1, \"All\")\
\9\9table.insert(var.groups, 2, \"Smelting\")\
\9\9os.queueEvent(\"render_cats\")\
\9elseif e[1] == \"output_items\" then\
\9\9var.loadMessage(\"Outputting\")\
\9\9for item,_ in pairs(var.selItem) do\
\9\9\9local count = e[2]\
\9\9\9if count == math.huge then\
\9\9\9\9count = nil\
\9\9\9end\
\9\9\9var.lib.outputItem(item, count, var.output, var.inv)\
\9\9\9genItems()\
\9\9\9renderItems()\
\9\9\9while not count and item.count > 0 do\
\9\9\9\9var.lib.outputItem(item, nil, var.output, var.inv)\
\9\9\9\9genItems()\
\9\9\9\9renderItems()\
\9\9\9\9os.sleep(1)\
\9\9\9end\
\9\9\9if item.count <= 0 then\
\9\9\9\9var.selItem[item] = nil\
\9\9\9end\
\9\9end\
\9\9var.endLoad()\
\9\9os.queueEvent(\"render_items\")\
\9end\
end",
    id = 11,
    name = "listitems.lua",
  },
  [ "smelttxt.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
\
if var.furnaces then\
\9if not var.freeFurnaces then\
\9\9var.freeFurnaces = {}\
\9\9for _,furnace in ipairs(var.furnaces) do\
\9\9\9if not furnace.getItemDetail(1) then\
\9\9\9\9table.insert(var.freeFurnaces, furnace)\
\9\9\9end\
\9\9end\
\9end\
\9if #var.furnaces == 1 then\
\9\9self.txt = \"Smelting | \"..(#var.freeFurnaces)..\"/1 furnace free\"\
\9else\
\9\9self.txt = \"Smelting | \"..(#var.freeFurnaces)..\"/\"..(#var.furnaces)..\" furnaces free\"\
\9end\
end",
    id = 15,
    name = "smelttxt.lua",
  },
  [ "pagetxt.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
\
if not var.catPages then\
\9self.txt = \"?/?\"\
\9return\
end\
\
local pageCount = math.ceil(#var.catPages/2)\
self.txt = var.page..\"/\"..pageCount",
    id = 7,
    name = "pagetxt.lua",
  },
  [ "catBar.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
\
local slide = shapescape.getSlide()\
if not slide.catBars then\
\9slide.catBars = {}\
end\
local barOffset = #slide.catBars\
table.insert(slide.catBars, self)\
\
local function genPages()\
\9var.catPages = {{}}\
\9var.catPos = {}\
\9var.page = 1\
\9local page = 1\
\9local x = 1\
\9local w,_ = term.getSize()\
\9\
\9for _,cat in ipairs(var.groups) do\
\9\9if x+#cat+1 > w then\
\9\9\9page = page + 1\
\9\9\9var.catPages[page] = {}\
\9\9\9x = 1\
\9\9end\
\9\9table.insert(var.catPages[page], cat)\
\9\9var.catPos[cat] = x\
\9\9x = x+#cat+2\
\9end\
end\
\
if barOffset == 0 then\
\9genPages()\
end\
\
local function render()\
\9term.setCursorPos(1,1)\
\9term.setBackgroundColor(colors.cyan)\
\9term.clearLine()\
\9local p = 1+(var.page-1)*2 + barOffset\
\9cats = var.catPages[p]\
\9for _, cat in ipairs(cats) do\
\9\9term.setCursorPos(var.catPos[cat], 1)\
\9\9if var.group == cat then\
\9\9\9term.setBackgroundColor(colors.gray)\
\9\9\9term.setTextColor(colors.white)\
\9\9else\
\9\9\9term.setBackgroundColor(colors.cyan)\
\9\9\9term.setTextColor(colors.gray)\
\9\9end\
\9\9term.write(\" \"..cat..\" \")\
\9end\
end\
\
local function checkClick(event, button, x, y)\
\9local w,_ = term.getSize()\
\9if x >= 1 and x <= w and y == 1 then\
\9\9for _, cat in ipairs(cats) do\
\9\9\9if x >= var.catPos[cat] and x <= var.catPos[cat]+#cat+1 then\
\9\9\9\9return cat\
\9\9\9end\
\9\9end\
\9end\
\9return false\
end\
\
render()\
while true do\
\9local e = {os.pullEvent()}\
\9if e[1] == \"mouse_click\" then\
\9\9local cat = checkClick(unpack(e))\
\9\9if cat and cat ~= var.group then\
\9\9\9if var.group == \"Smelting\" or cat == \"Smelting\" then\
\9\9\9\9var.group = cat\
\9\9\9\9os.queueEvent(\"render_cats\")\
\9\9\9\9render()\
\9\9\9\9if cat == \"Smelting\" then\
\9\9\9\9\9shapescape.setSlide(3)\
\9\9\9\9else\
\9\9\9\9\9shapescape.setSlide(2)\
\9\9\9\9end\
\9\9\9\9os.queueEvent(\"render_cats\")\
\9\9\9else\
\9\9\9\9var.group = cat\
\9\9\9\9os.queueEvent(\"render_cats\")\
\9\9\9end\
\9\9end\
\9elseif e[1] == \"render_cats\" then\
\9\9render()\
\9end\
end",
    id = 6,
    name = "catBar.lua",
  },
  [ "setinput.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
\
local shulkers = {peripheral.find(\"inventory\", function(n,p) return n:find(\"shulker\") end)}\
\
local opts = {}\
\
if var.oinput then\
\9opts = {\
\9\9{\
\9\9\9txt=\"default (\"..var.oinput..\")\",\
\9\9\9disabled = (var.input == var.oinput),\
\9\9\9action=function(self) var.input = var.oinput end,\
\9\9},\
\9\9{action=\"divider\"},\
\9}\
elseif #shulkers > 0 then\
\9var.input = shulkers[1]\
end\
\
for k,v in ipairs(shulkers) do\
\9\
\9local name = peripheral.getName(v)\
\9\
\9local displayName = name\
\9local i = v.getItemDetail(1)\
\9if i and i.displayName then\
\9\9displayName = i.displayName..\" (\"..name..\")\"\
\9end\
\9\
\9table.insert(opts, {\
\9\9txt = displayName,\
\9\9disabled = (var.input == name),\
\9\9action=function(self) var.input = name end,\
\9})\
\9\
end\
\
if #opts == 0 then\
\9opts = {\
\9\9{\
\9\9\9txt = \"No input chests available.\",\
\9\9\9disabled = true\
\9\9}\
\9}\
end\
local con = lUtils.contextmenu(self.x1, self.y1+1, 5, opts, nil, false)\
con.run()",
    id = 20,
    name = "setinput.lua",
  },
  [ "top_gradient.lua" ] = {
    content = "local slides = shapescape.getSlides()\
slides.topgradient = self\
\
local slide = shapescape.getSlide()\
\
local pth = \"/User/Cloud/Public/Storage_Manager\"\
if not fs.exists(pth) then\
\9pth = \"/Program_Files/Storage_Manager\"\
end\
\
local img\
if slide.c == 1 then\
\9img = lUtils.asset.load(pth..\"/top_gradient.bimg\")\
else\
\9img = lUtils.asset.load(pth..\"/top_gradient_small.bimg\")\
end\
local imgWidth, imgHeight = #img[1][1][1], #img[1]\
\
local function render()\
\9term.setBackgroundColor(colors.cyan)\
\9term.clear()\
\9local w,h = term.getSize()\
\9for i=1,math.ceil(w/imgWidth) do\
\9\9lUtils.renderImg(img[1], 1+(i-1)*imgWidth, 1)\
\9end\
end\
\
render()\
\
while true do\
\9local e = {os.pullEvent()}\
\9local nSlide = shapescape.getSlide()\
\9if slide ~= nSlide then\
\9\9slide = nSlide\
\9\9if slide.c == 1 then\
\9\9\9img = lUtils.asset.load(pth..\"/top_gradient.bimg\")\
\9\9else\
\9\9\9img = lUtils.asset.load(pth..\"/top_gradient_small.bimg\")\
\9\9end\
\9\9imgWidth, imgHeight = #img[1][1][1], #img[1]\
\9\9render()\
\9end\
\9if e[1] == \"term_resize\" then\
\9\9render()\
\9end\
end",
    id = 1,
    name = "top_gradient.lua",
  },
  [ "input.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
local input = var.getInput()\
\
var.loadMessage(\"Inputting\")\
\
local ls = input.list()\
for t=2,input.size() do\
\9if ls[t] then\
\9\9var.lib.inputItem(t, input, var.inv)\
\9end\
end\
\
os.queueEvent(\"scan_inventory\")",
    id = 19,
    name = "input.lua",
  },
  [ "fieldbar.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
\
if not var.sortOn then var.sortOn = \"name\" end\
if not var.sortIncreasing then var.sortIncreasing = true end\
\
local slide = shapescape.getSlide()\
table.insert(slide.objs, 2, slides.topgradient)\
table.insert(slide.objs, 2, slides.bottomgradient)\
local slide2 = slides[3]\
table.insert(slide2.objs, 2, slides.topgradient)\
table.insert(slide2.objs, 2, slides.bottomgradient)\
os.queueEvent(\"render_gradients\")\
\
var.fields = {\"Name\",\"Count\",\"ID\"}\
\
if not var.fieldWidth then\
\9var.fieldWidth = {\
\9\9Name = 20,\
\9\9Count= 7,\
\9\9ID   = 50,\
\9}\
end\
\
local dragPos = {}\
local fieldPos = {}\
\
local function render()\
\9local x = 3\
\9term.setBackgroundColor(colors.white)\
\9term.setTextColor(colors.lightGray)\
\9term.clear()\
\9term.setCursorPos(x, 1)\
\9for i,field in ipairs(var.fields) do\
\9\9term.write(field)\
\9\9if var.sortOn == field:lower() then\
\9\9\9if var.sortIncreasing then\
\9\9\9\9term.write(\" \\25\")\
\9\9\9else\
\9\9\9\9term.write(\" \\24\")\
\9\9\9end\
\9\9end\
\9\9term.setCursorPos(x+var.fieldWidth[field], 1)\
\9\9if var.fields[i+1] then\
\9\9\9term.write(\"\\149\")\
\9\9end\
\9\9fieldPos[field] = {x1=x}\
\9\9dragPos[x+var.fieldWidth[field]] = field\
\9\9x = x+var.fieldWidth[field]+1\
\9\9fieldPos[field].x2 = x-2\
\9end\
end\
\
render()\
\
while true do\
\9local e = {os.pullEvent()}\
\9local w,h = term.getSize()\
\9if e[1] == \"term_resize\" then\
\9\9render()\
\9elseif e[1] == \"mouse_click\" and e[3] >= 1 and e[3] <= w and e[4] == 1 then\
\9\9for i,field in ipairs(var.fields) do\
\9\9\9local f = fieldPos[field]\
\9\9\9if e[3] >= f.x1 and e[3] <= f.x2 then\
\9\9\9\9if var.sortOn == field:lower() then\
\9\9\9\9\9var.sortIncreasing = not var.sortIncreasing\
\9\9\9\9else\
\9\9\9\9\9var.sortOn = field:lower()\
\9\9\9\9\9var.sortIncreasing = true\
\9\9\9\9end\
\9\9\9\9render()\
\9\9\9\9os.queueEvent(\"render_cats\")\
\9\9\9end\
\9\9end\
\9end\
end",
    id = 10,
    name = "fieldbar.lua",
  },
  [ "take.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
\
local myCount\
if not self.myCount then\
\9myCount = self.txt:match(\"%S+%s(.+)\")\
\9if tonumber(myCount) then\
\9\9myCount = tonumber(myCount)\
\9elseif myCount == \"all\" then\
\9\9myCount = math.huge\
\9else\
\9\9error(\"Invalid count: \"..tostring(myCount))\
\9end\
\9self.myCount = myCount\
else\
\9myCount = self.myCount\
end\
\
local takeable = true\
\
if var.selItem then\
\9local count = 0\
\9for item,_ in pairs(var.selItem) do\
\9\9count = count + 1\
\9\9if item.count < myCount then\
\9\9\9takeable = false\
\9\9end\
\9end\
\9if count == 0 then\
\9\9takeable = false\
\9elseif myCount == math.huge then\
\9\9takeable = true\
\9end\
else\
\9takeable = false\
end\
\
if takeable then\
\9self.isTakeable = true\
\9self.txtcolor = colors.white\
else\
\9self.isTakeable = false\
\9self.txtcolor = colors.gray\
end",
    id = 14,
    name = "take.lua",
  },
  [ "dottxt.lua" ] = {
    content = "local slide = shapescape.getSlide()\
slide.dottxt = self\
self.txt = \"\"",
    id = 5,
    name = "dottxt.lua",
  },
  [ "search.lua" ] = {
    content = "local slide = shapescape.getSlide()\
slide.searchbox = self\
_G.debugsearchbox = self",
    id = 13,
    name = "search.lua",
  },
  [ "previouspage.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
\
if var.page > 1 then\
\9var.page = var.page-1\
\9os.queueEvent(\"render_cats\")\
end",
    id = 9,
    name = "previouspage.lua",
  },
  [ "loadicon.lua" ] = {
    content = "os.sleep(0.1)\
\
term.setPaletteColor(colors.blue, 0.8, 0.8, 0.8)\
\
local slide = shapescape.getSlide()\
local slides = shapescape.getSlides()\
local var = slides.var\
\
slide.loadicon = self\
for i=#slide.objs, 1, -1 do\
\9if slide.objs[i] == slide.dottxt or slide.objs[i] == slide.loadtxt or slide.objs[i] == self then\
\9\9table.remove(slide.objs, i)\
\9end\
end\
\
local pth = \"/User/Cloud/Public/Storage_Manager\"\
if not fs.exists(pth) then\
\9pth = \"/Program_Files/Storage_Manager\"\
end\
\
local img = lUtils.asset.load(pth..\"/logo2.bimg\")\
self.image = nil\
self.isLoading = false\
self.spawned = false\
var.debugLoadIcon = self\
self.myCoolSlide = slide\
\
var.spawnLoad = function()\
\9local s = shapescape.getSlide()\
\9if not s.loadicon.spawned then\
\9\9table.insert(s.objs, s.loadicon)\
\9\9s.loadicon.spawned = true\
\9end\
end\
\
var.loadMessage = function(txt)\
\9local s = shapescape.getSlide()\
\9if not s.loadicon.isLoading then\
\9\9var.spawnLoad(s.loadicon)\
\9\9s.loadicon.isLoading = true\
\9end\
\9s.loadicon.loadTxt = txt\
end\
\
var.endLoad = function()\
\9local s = shapescape.getSlide()\
\9s.loadicon.isLoading = false\
end\
\
while true do\
\9coroutine.yield()\
\9if self.isLoading then\
\9\9self.image = nil\
\9\9\
\9\9for i=1,5 do\
\9\9\9os.sleep(0.1)\
\9\9\9self.image = img[i]\
\9\9end\
\9\9\
\9\9if not slide.loadtxt.spawned then\
\9\9\9table.insert(slide.objs, slide.loadtxt)\
\9\9\9slide.loadtxt.spawned = true\
\9\9end\
\9\9\
\9\9if not slide.dottxt.spawned then\
\9\9\9table.insert(slide.objs, slide.dottxt)\
\9\9\9slide.dottxt.spawned = true\
\9\9end\
\9\9\
\9\9while self.isLoading do\
\9\9\9local txt = self.loadTxt or \"Loading\"\
\9\9\9slide.loadtxt.txt = string.rep(\" \", 5-math.floor(#txt/2))..txt\
\9\9\9for t=1,4 do\
\9\9\9\9slide.dottxt.txt = \"  \"..string.rep(\".\",t)\
\9\9\9\9os.sleep(0.5)\
\9\9\9end\
\9\9end\
\9\9\
\9\9for i=#slide.objs, 1, -1 do\
\9\9\9if slide.objs[i] == slide.dottxt or slide.objs[i] == slide.loadtxt then\
\9\9\9\9slide.objs[i].spawned = false\
\9\9\9\9table.remove(slide.objs, i)\
\9\9\9end\
\9\9end\
\9\9\
\9\9for i=5,1,-1 do\
\9\9\9os.sleep(0.1)\
\9\9\9self.image = img[i]\
\9\9end\
\9\9\
\9\9self.image = nil\
\9\9\
\9\9for i,obj in ipairs(slide.objs) do\
\9\9\9if obj == self then\
\9\9\9\9slide.objs[i].spawned = false\
\9\9\9\9table.remove(slide.objs, i)\
\9\9\9\9break\
\9\9\9end\
\9\9end\
\9end\
end",
    id = 18,
    name = "loadicon.lua",
  },
  [ "takeClick.lua" ] = {
    content = "if not self.myCount then\
\9error(\"Could not parse count\")\
end\
\
local slides = shapescape.getSlides()\
local var = slides.var\
\
if self.isTakeable and var.selItem then\
\9--[[for item,_ in pairs(var.selItem) do\
\9\9local count = self.myCount\
\9\9if count == math.huge then\
\9\9\9count = nil\
\9\9end\
\9\9var.lib.outputItem(item, count, var.output, var.inv)\
\9\9if item.count <= 0 then\
\9\9\9var.selItem[item] = nil\
\9\9end\
\9end\
\9os.queueEvent(\"render_items\")]]\
\9os.queueEvent(\"output_items\", self.myCount)\
end",
    id = 17,
    name = "takeClick.lua",
  },
  [ "bottom_gradient.lua" ] = {
    content = "local slides = shapescape.getSlides()\
slides.bottomgradient = self\
\
local slide = shapescape.getSlide()\
\
local pth = \"/User/Cloud/Public/Storage_Manager\"\
if not fs.exists(pth) then\
\9pth = \"/Program_Files/Storage_Manager\"\
end\
\
local img\
if slide.c == 1 then\
\9img = lUtils.asset.load(pth..\"/bottom_gradient.bimg\")\
else\
\9img = lUtils.asset.load(pth..\"/bottom_gradient_small.bimg\")\
end\
local imgWidth, imgHeight = #img[1][1][1], #img[1]\
\
local function render()\
\9term.setBackgroundColor(colors.cyan)\
\9term.clear()\
\9local w,h = term.getSize()\
\9for i=1,math.ceil(w/imgWidth) do\
\9\9lUtils.renderImg(img[1], 1+(i-1)*imgWidth, h-imgHeight+1)\
\9end\
end\
\
render()\
\
while true do\
\9local e = {os.pullEvent()}\
\9local nSlide = shapescape.getSlide()\
\9_G.debugslide = nSlide\
\9if slide ~= nSlide then\
\9\9slide = nSlide\
\9\9if slide.c == 1 then\
\9\9\9img = lUtils.asset.load(pth..\"/bottom_gradient.bimg\")\
\9\9else\
\9\9\9img = lUtils.asset.load(pth..\"/bottom_gradient_small.bimg\")\
\9\9end\
\9\9imgWidth, imgHeight = #img[1][1][1], #img[1]\
\9\9render()\
\9end\
\9if e[1] == \"term_resize\" then\
\9\9render()\
\9end\
end",
    id = 2,
    name = "bottom_gradient.lua",
  },
  [ "loadtxt.lua" ] = {
    content = "local slide = shapescape.getSlide()\
slide.loadtxt = self\
self.txt = \"\"",
    id = 4,
    name = "loadtxt.lua",
  },
  [ "init.lua" ] = {
    content = "local function func()\
\
local pth = \"/User/Cloud/Public/Storage_Manager\"\
if not fs.exists(pth) then\
\9pth = \"/Program_Files/Storage_Manager\"\
end\
\
local img = lUtils.asset.load(pth..\"/logo2.bimg\")\
local palette = lUtils.asset.load(pth..\"/logo_palette.lua\")\
\
local slides = shapescape.getSlides()\
local s = shapescape.getSlide()\
if not slides.var then slides.var = {} end\
local var = slides.var\
_G.debugVar = var\
\
var.pth = \"/\"..fs.getDir(LevelOS and LevelOS.self.window.path or shell.getRunningProgram())\
var.appdata = \"/AppData/Storage_Manager/data.lua\"\
\
if fs.exists(var.appdata) then\
\9local f = fs.open(var.appdata, \"r\")\
\9local contents = f.readAll()\
\9f.close()\
\9var.data = textutils.unserialize(contents)\
end\
\
if not var.data then\
\9var.data = {}\
end\
\
var.saveData = function()\
\9local contents = textutils.serialize(var.data)\
\9local f = fs.open(var.appdata, \"w\")\
\9f.write(contents)\
\9f.close()\
end\
\
local lib = require(var.pth..\"/api\")\
\
var.lib = lib\
\
for i=0,15 do\
\9term.setPaletteColor(2^i, unpack(palette[i]))\
end\
\
self.image = nil\
\
os.sleep(0.5)\
LevelOS.maximize()\
os.sleep(0.1)\
os.queueEvent(\"term_resize\")\
\
for i=1,5 do\
\9os.sleep(0.1)\
\9self.image = img[i]\
end\
\
s.loadtxt.txt = \"Scanning\"\
s.dottxt.txt  = \"  ....  \"\
parallel.waitForAny(\
\9function()\
\9\9--os.sleep(3)\
\9\9--local function log(txt) table.insert(myLog,txt) end\
\9\9if _G.cachedSS then\
\9\9\9var.setup = cachedSS.setup\
\9\9\9var.chests, var.output, var.furnaces = cachedSS.chests, cachedSS.output, cachedSS.furnaces\
\9\9\9if cachedSS.input then\
\9\9\9\9var.oinput = cachedSS.oinput or peripheral.getName(cachedSS.input)\
\9\9\9end\
\9\9\9var.inv = cachedSS.inv\
\9\9else\
\9\9\9var.setup = {lib.getSetup()}\
\9\9\9var.chests, var.oinput, var.output, var.furnaces = unpack(var.setup)\
\9\9\9if var.oinput then\
\9\9\9\9var.oinput = peripheral.getName(var.oinput)\
\9\9\9end\
\9\9\9var.inv = lib.getInventory(var.chests)\
\9\9\9_G.cachedSS = var\
\9\9end\
\9end,\
\9function()\
\9\9while true do\
\9\9\9for t=1,4 do\
\9\9\9\9s.dottxt.txt = \"  \"..string.rep(\".\",t)\
\9\9\9\9os.sleep(0.5)\
\9\9\9end\
\9\9end\
\9end\
)\
\
var.getInput = function()\
\9return var.input and peripheral.wrap(var.input) or peripheral.wrap(var.oinput)\
end\
\
s.loadtxt.txt = \"\"\
s.dottxt.txt = \"\"\
for i=6,11 do\
\9os.sleep(0.1)\
\9self.image = img[i]\
end\
var.groups = {}\
for k,v in pairs(var.inv.groups) do\
\9table.insert(var.groups, k)\
end\
table.sort(var.groups)\
table.insert(var.groups, 1, \"All\")\
--table.insert(var.groups, 2, \"Smelting\")\
var.group = \"All\"\
os.sleep(2)\
shapescape.setSlide(2)\
end\
local ok, err = pcall(func)\
if not ok then\
\9_G.fuckyou = err\
\9local slide = shapescape.getSlide()\
\9if slide.loadtxt then\
\9\9slide.loadtxt = \" Error \"\
\9end\
end",
    id = 3,
    name = "init.lua",
  },
  [ "resulttxt.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
\
if var.group and var.items then\
\9if #var.items == 1 then\
\9\9self.txt = var.group..\" | 1 result\"\
\9else\
\9\9self.txt = var.group..\" | \"..(#var.items)..\" results\"\
\9end\
end",
    id = 12,
    name = "resulttxt.lua",
  },
  [ "smelt_inv.lua" ] = {
    content = "local slides = shapescape.getSlides()\
local var = slides.var\
local slide = shapescape.getSlide()\
slide.fullInv = genItems({}, var.inv)\
\
var.smelt_render = function()\
\9\
end",
    id = 16,
    name = "smelt_inv.lua",
  },
}

local nAssets = {}
for key,value in pairs(assets) do nAssets[key] = value nAssets[assets[key].id] = assets[key] end
assets = nAssets
nAssets = nil

local slides = {
  {
    w = 51,
    objs = {
      {
        x1 = 1,
        y1 = 1,
        x2 = 51,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "rect",
        ox2 = 0,
        border = {
          color = 0,
          type = 1,
        },
        color = 512,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
        oy2 = 0,
        y2 = 19,
      },
      {
        x1 = 1,
        y1 = 1,
        x2 = 51,
        y2 = 4,
        type = "window",
        ox2 = 0,
        border = {
          color = 0,
          type = 1,
        },
        color = 32768,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
        input = false,
      },
      {
        x1 = 1,
        y1 = 16,
        x2 = 51,
        y2 = 19,
        type = "window",
        ox2 = 0,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 2,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        border = {
          color = 0,
          type = 1,
        },
        color = 32768,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap bottom",
          Left = "Snap left",
          Right = "Snap right",
        },
        oy2 = 0,
        oy1 = 3,
        input = false,
      },
      {
        x1 = 13,
        y1 = 4,
        x2 = 38,
        y2 = 16,
        image = {
          {
            "",
            "            bb            ",
            "         bbb00bbb         ",
          },
          {
            "",
            "         bb4444bb b       ",
            "       bb44bbbb44b        ",
          },
          {
            "",
            "        11      11        ",
            "bbbbbbbbbbbbbbbbbbbbbbbbbb",
          },
          {
            "",
            " b000b00b0bb0b0b0bb000 00 ",
            "b0bbb0bb0b00b0b0b00bbb0bbb",
          },
          {
            "",
            " 44b b4    bbb4 b b4b4 4 b",
            "bbb4b4bb4b4444b4444b4b4bb ",
          },
          {
            "",
            " bb1 b1 bb1b1b1   1bb1 bb ",
            "b11bb1bb11b1b1b1b1b11b111b",
          },
          {
            "",
            "                         b",
            "bbbbbbbbbbbbbbbbbbbbbbbbb ",
          },
          {
            "",
            "  b b0b0 b b0b0b00b000 0b ",
            "b0000b0b0000b0b0bb0bbb0b0b",
          },
          {
            "",
            " 4 bbbb4 b bbb4 bbb44  b4 ",
            "bb44444b444444b4444bbb44bb",
          },
          {
            "",
            " 1 bb1b1   b1b1bb1bbb1 1b ",
            "bbb11b1b1b11b1b11b111b1b1b",
          },
          {
            "",
            "bbbbbbb bb      b0 bbbbbbb",
            "       b00bbbbbb0bb       ",
          },
          {
            "",
            "       b 5bbbbb55bb       ",
            "        bb55555bb         ",
          },
          {
            "",
            "         bb 99bbb         ",
            "           bbb            ",
          },
        },
        ox1 = 13,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 3,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "rect",
        ox2 = -12,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 6,
        oy2 = -6,
        color = 0,
        snap = {
          Bottom = "Snap center",
          Top = "Snap center",
          Left = "Snap center",
          Right = "Snap center",
        },
      },
      {
        x1 = 22,
        y1 = 9,
        x2 = 29,
        y2 = 9,
        txtcolor = 1,
        txt = "Scanning",
        ox1 = 4,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 4,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = -3,
        color = 0,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 1,
        snap = {
          Bottom = "Snap center",
          Top = "Snap center",
          Left = "Snap center",
          Right = "Snap center",
        },
        oy2 = 1,
        input = false,
      },
      {
        x1 = 22,
        y1 = 10,
        x2 = 30,
        y2 = 10,
        txtcolor = 1,
        txt = "....",
        ox1 = 4,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 5,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = -4,
        color = 0,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 0,
        snap = {
          Bottom = "Snap center",
          Top = "Snap center",
          Left = "Snap center",
          Right = "Snap center",
        },
        oy2 = 0,
        input = false,
      },
    },
    x = 65,
    c = 1,
    y = 22,
    h = 19,
  },
  {
    w = 51,
    objs = {
      {
        x1 = 1,
        y1 = 1,
        x2 = 51,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "rect",
        ox2 = 0,
        border = {
          color = 0,
          type = 1,
        },
        color = 512,
        oy2 = 0,
        y2 = 19,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
      },
      {
        x1 = 2,
        y1 = 5,
        x2 = 50,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "rect",
        ox2 = 1,
        border = {
          color = 128,
          type = 1,
        },
        color = 1,
        oy2 = 4,
        y2 = 15,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
      },
      {
        x1 = 2,
        y1 = 4,
        x2 = 50,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 6,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "window",
        ox2 = 1,
        border = {
          color = 0,
          type = 1,
        },
        color = 32768,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
        y2 = 4,
      },
      {
        x1 = 2,
        y1 = 5,
        x2 = 50,
        y2 = 5,
        type = "rect",
        ox2 = 1,
        border = {
          color = 0,
          type = 1,
        },
        color = 128,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
      },
      {
        x1 = 3,
        y1 = 5,
        x2 = 27,
        y2 = 5,
        type = "text",
        ox2 = 24,
        txtcolor = 256,
        border = {
          color = 0,
          type = 1,
        },
        txt = "Category | ??? Results",
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
        color = 0,
        event = {
          update = {
            [ 2 ] = 12,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        input = false,
      },
      {
        x1 = 29,
        y1 = 5,
        x2 = 49,
        y2 = 5,
        scr = 0,
        ref = {
          1,
          1,
        },
        history = {},
        rhistory = {},
        changed = false,
        lines = {
          "",
        },
        cursor = {
          y = 1,
          a = 1,
          x = 1,
        },
        txt = "",
        txtcolor = 1,
        opt = {
          overflowX = "scroll",
          overflowY = "none",
          cursorColor = 256,
          overflow = "scroll",
          indentChar = " ",
          minWidth = 9,
          minHeight = 1,
          tabSize = 4,
        },
        ox1 = 22,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 13,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "input",
        ox2 = 2,
        scrollX = 0,
        border = {
          color = 0,
          type = 1,
        },
        color = 64,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap right",
          Right = "Snap right",
        },
        blit = {},
        dLines = {
          "",
        },
        state = false,
      },
      {
        x1 = 2,
        y1 = 16,
        x2 = 50,
        y2 = 16,
        type = "window",
        ox2 = 1,
        oy1 = 3,
        border = {
          color = 0,
          type = 1,
        },
        color = 32768,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap bottom",
          Left = "Snap left",
          Right = "Snap right",
        },
        oy2 = 3,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 6,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
      },
      {
        x1 = 3,
        y1 = 6,
        x2 = 49,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 10,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "window",
        ox2 = 2,
        border = {
          color = 0,
          type = 1,
        },
        color = 32768,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
        y2 = 6,
      },
      {
        x1 = 3,
        y1 = 8,
        x2 = 49,
        y2 = 14,
        type = "window",
        ox2 = 2,
        border = {
          color = 0,
          type = 1,
        },
        color = 32768,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
        oy2 = 5,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 11,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
      },
      {
        image = {
          {
            "",
            "         ",
            "         ",
          },
          {
            "",
            "         ",
            " 9999999 ",
          },
          {
            "",
            "         ",
            "         ",
          },
        },
        x1 = 22,
        y1 = 2,
        ox1 = 4,
        y2 = 4,
        type = "rect",
        ox2 = -4,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap center",
          Right = "Snap center",
        },
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        x2 = 30,
      },
      {
        x1 = 23,
        y1 = 3,
        x2 = 23,
        y2 = 3,
        input = false,
        txtcolor = 1,
        ox1 = 3,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 9,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = 3,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap center",
          Right = "Snap center",
        },
        txt = "\17",
      },
      {
        x1 = 25,
        y1 = 3,
        x2 = 27,
        y2 = 3,
        input = false,
        txtcolor = 1,
        ox1 = 1,
        event = {
          update = {
            [ 2 ] = 7,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = -1,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap center",
          Right = "Snap center",
        },
        txt = "0/0",
      },
      {
        x1 = 29,
        y1 = 3,
        x2 = 29,
        y2 = 3,
        input = false,
        txtcolor = 1,
        ox1 = -3,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 8,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = -3,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap center",
          Right = "Snap center",
        },
        txt = "\16",
      },
      {
        x1 = 17,
        y1 = 17,
        ox1 = 34,
        y2 = 18,
        type = "rect",
        ox2 = 1,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 2,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap bottom",
          Left = "Snap right",
          Right = "Snap right",
        },
        oy2 = 1,
        color = 0,
        x2 = 50,
      },
      {
        x1 = 43,
        y1 = 17,
        x2 = 50,
        y2 = 17,
        txtcolor = 1,
        txt = "Take all",
        ox1 = 8,
        event = {
          update = {
            [ 2 ] = 14,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 17,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = 1,
        color = 0,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 2,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap bottom",
          Left = "Snap right",
          Right = "Snap right",
        },
        oy2 = 2,
        input = false,
      },
      {
        x1 = 34,
        y1 = 17,
        x2 = 40,
        y2 = 17,
        txtcolor = 1,
        txt = "Take 64",
        ox1 = 17,
        event = {
          update = {
            [ 2 ] = 14,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 17,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = 11,
        color = 0,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 2,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap bottom",
          Left = "Snap right",
          Right = "Snap right",
        },
        oy2 = 2,
        input = false,
      },
      {
        x1 = 25,
        y1 = 17,
        x2 = 31,
        y2 = 17,
        txtcolor = 1,
        txt = "Take 16",
        ox1 = 26,
        event = {
          update = {
            [ 2 ] = 14,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 17,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = 20,
        color = 0,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 2,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap bottom",
          Left = "Snap right",
          Right = "Snap right",
        },
        oy2 = 2,
        input = false,
      },
      {
        x1 = 17,
        y1 = 17,
        x2 = 22,
        y2 = 17,
        txtcolor = 1,
        txt = "Take 1",
        ox1 = 34,
        event = {
          update = {
            [ 2 ] = 14,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 17,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = 29,
        color = 0,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 2,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap bottom",
          Left = "Snap right",
          Right = "Snap right",
        },
        oy2 = 2,
        input = false,
      },
      {
        x1 = 2,
        y1 = 17,
        x2 = 6,
        y2 = 17,
        input = false,
        txtcolor = 1,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 19,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        color = 0,
        border = {
          color = 0,
          type = 1,
        },
        txt = "Input",
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap bottom",
          Left = "Snap left",
          Right = "Snap left",
        },
        oy2 = 2,
        oy1 = 2,
      },
      {
        x1 = 13,
        y1 = 4,
        x2 = 38,
        y2 = 16,
        image = {
          {
            "",
            "            bb            ",
            "         bbb00bbb         ",
          },
          {
            "",
            "         bb4444bb b       ",
            "       bb44bbbb44b        ",
          },
          {
            "",
            "        11      11        ",
            "bbbbbbbbbbbbbbbbbbbbbbbbbb",
          },
          {
            "",
            " b000b00b0bb0b0b0bb000 00 ",
            "b0bbb0bb0b00b0b0b00bbb0bbb",
          },
          {
            "",
            " 44b b4    bbb4 b b4b4 4 b",
            "bbb4b4bb4b4444b4444b4b4bb ",
          },
          {
            "",
            " bb1 b1 bb1b1b1   1bb1 bb ",
            "b11bb1bb11b1b1b1b1b11b111b",
          },
          {
            "",
            "                         b",
            "bbbbbbbbbbbbbbbbbbbbbbbbb ",
          },
          {
            "",
            "  b b0b0 b b0b0b00b000 0b ",
            "b0000b0b0000b0b0bb0bbb0b0b",
          },
          {
            "",
            " 4 bbbb4 b bbb4 bbb44  b4 ",
            "bb44444b444444b4444bbb44bb",
          },
          {
            "",
            " 1 bb1b1   b1b1bb1bbb1 1b ",
            "bbb11b1b1b11b1b11b111b1b1b",
          },
          {
            "",
            "bbbbbbb bb      b0 bbbbbbb",
            "       b00bbbbbb0bb       ",
          },
          {
            "",
            "       b 5bbbbb55bb       ",
            "        bb55555bb         ",
          },
          {
            "",
            "         bb 99bbb         ",
            "           bbb            ",
          },
        },
        ox1 = 13,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 18,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "rect",
        ox2 = -12,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 6,
        oy2 = -6,
        color = 0,
        snap = {
          Bottom = "Snap center",
          Top = "Snap center",
          Left = "Snap center",
          Right = "Snap center",
        },
      },
      {
        x1 = 21,
        y1 = 9,
        x2 = 30,
        y2 = 9,
        txtcolor = 1,
        txt = " Scanning",
        ox1 = 5,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 4,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = -4,
        color = 0,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 1,
        snap = {
          Bottom = "Snap center",
          Top = "Snap center",
          Left = "Snap center",
          Right = "Snap center",
        },
        oy2 = 1,
        input = false,
      },
      {
        x1 = 22,
        y1 = 10,
        x2 = 30,
        y2 = 10,
        txtcolor = 1,
        txt = "....",
        ox1 = 4,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 5,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = -4,
        color = 0,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = 0,
        snap = {
          Bottom = "Snap center",
          Top = "Snap center",
          Left = "Snap center",
          Right = "Snap center",
        },
        oy2 = 0,
        input = false,
      },
      {
        x1 = 40,
        y1 = 3,
        x2 = 50,
        y2 = 3,
        input = false,
        txtcolor = 1,
        ox1 = 11,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = 1,
        border = {
          color = 0,
          type = 1,
        },
        txt = "Output to \31",
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Right = "Snap right",
          Left = "Snap right",
        },
        color = 0,
      },
      {
        txtcolor = 1,
        y1 = 3,
        x2 = 13,
        y2 = 3,
        type = "text",
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 20,
          },
        },
        x1 = 2,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap left",
        },
        txt = "Input from \31",
        input = false,
      },
    },
    x = 65,
    c = 2,
    y = 22,
    h = 19,
  },
  {
    w = 51,
    objs = {
      {
        x1 = 1,
        y1 = 1,
        x2 = 51,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "rect",
        ox2 = 0,
        border = {
          color = 0,
          type = 1,
        },
        color = 512,
        oy2 = 0,
        y2 = 19,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
      },
      {
        x1 = 2,
        y1 = 5,
        x2 = 50,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "rect",
        ox2 = 1,
        border = {
          color = 128,
          type = 1,
        },
        color = 1,
        oy2 = 4,
        y2 = 15,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
      },
      {
        x1 = 2,
        y1 = 5,
        x2 = 50,
        y2 = 5,
        type = "rect",
        ox2 = 1,
        border = {
          color = 0,
          type = 1,
        },
        color = 128,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
      },
      {
        x1 = 33,
        y1 = 5,
        x2 = 49,
        y2 = 5,
        scr = 0,
        ref = {
          1,
          1,
        },
        history = {},
        rhistory = {},
        changed = false,
        lines = {
          "",
        },
        cursor = {
          y = 1,
          a = 1,
          x = 1,
        },
        txt = "",
        txtcolor = 1,
        opt = {
          overflowX = "scroll",
          overflowY = "none",
          cursorColor = 256,
          overflow = "scroll",
          indentChar = " ",
          minWidth = 9,
          minHeight = 1,
          tabSize = 4,
        },
        ox1 = 18,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 13,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "input",
        ox2 = 2,
        scrollX = 0,
        border = {
          color = 0,
          type = 1,
        },
        color = 64,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap right",
          Right = "Snap right",
        },
        blit = {},
        dLines = {
          "",
        },
        state = false,
      },
      {
        x1 = 25,
        y1 = 3,
        x2 = 27,
        y2 = 3,
        input = false,
        txtcolor = 1,
        ox1 = 1,
        event = {
          update = {
            [ 2 ] = 7,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = -1,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap center",
          Right = "Snap center",
        },
        txt = "0/0",
      },
      {
        x1 = 23,
        y1 = 3,
        x2 = 23,
        y2 = 3,
        input = false,
        txtcolor = 1,
        ox1 = 3,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 9,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = 3,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap center",
          Right = "Snap center",
        },
        txt = "\17",
      },
      {
        x1 = 29,
        y1 = 3,
        x2 = 29,
        y2 = 3,
        input = false,
        txtcolor = 1,
        ox1 = -3,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = 8,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = -3,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap center",
          Right = "Snap center",
        },
        txt = "\16",
      },
      {
        x1 = 3,
        y1 = 5,
        x2 = 32,
        y2 = 5,
        type = "text",
        ox2 = 19,
        txtcolor = 256,
        border = {
          color = 0,
          type = 1,
        },
        txt = "Smelting | ??/?? furnaces free",
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
        color = 0,
        event = {
          update = {
            [ 2 ] = 15,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        input = false,
      },
      {
        x1 = 2,
        y1 = 4,
        x2 = 50,
        y2 = 4,
        type = "window",
        ox2 = 1,
        border = {
          color = 0,
          type = 1,
        },
        color = 32768,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap right",
        },
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 6,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
      },
      {
        x1 = 2,
        y1 = 16,
        x2 = 50,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = 6,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "window",
        ox2 = 1,
        oy1 = 3,
        border = {
          color = 0,
          type = 1,
        },
        color = 32768,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap bottom",
          Left = "Snap left",
          Right = "Snap right",
        },
        oy2 = 3,
        y2 = 16,
      },
      {
        txtcolor = 256,
        y1 = 6,
        x2 = 23,
        y2 = 6,
        type = "text",
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        x1 = 5,
        border = {
          color = 0,
          type = 1,
        },
        txt = "Inv. | ?? results",
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap left",
        },
        color = 0,
        input = false,
      },
      {
        x1 = 5,
        y1 = 11,
        x2 = 23,
        y2 = 11,
        txtcolor = 256,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        oy1 = -1,
        input = false,
        border = {
          color = 0,
          type = 1,
        },
        txt = "Fuel   | ?? items",
        snap = {
          Bottom = "Snap center",
          Top = "Snap center",
          Left = "Snap left",
          Right = "Snap left",
        },
        oy2 = -1,
        color = 0,
      },
      {
        x1 = 27,
        y1 = 6,
        x2 = 45,
        y2 = 6,
        input = false,
        txtcolor = 256,
        ox1 = -1,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = -19,
        border = {
          color = 0,
          type = 1,
        },
        color = 0,
        snap = {
          Bottom = "Snap top",
          Top = "Snap top",
          Left = "Snap center",
          Right = "Snap center",
        },
        txt = "Smelting",
      },
      {
        x1 = 27,
        y1 = 11,
        x2 = 45,
        y2 = 11,
        txtcolor = 256,
        txt = "Output | ?? items",
        ox1 = -1,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "text",
        ox2 = -19,
        color = 0,
        border = {
          color = 0,
          type = 1,
        },
        oy1 = -1,
        snap = {
          Bottom = "Snap center",
          Top = "Snap center",
          Left = "Snap center",
          Right = "Snap center",
        },
        oy2 = -1,
        input = false,
      },
      {
        x1 = 4,
        y1 = 7,
        x2 = 23,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "window",
        ox2 = 3,
        border = {
          color = 0,
          type = 1,
        },
        color = 2,
        oy2 = 1,
        y2 = 9,
        snap = {
          Bottom = "Snap center",
          Top = "Snap top",
          Left = "Snap left",
          Right = "Snap center",
        },
      },
      {
        x1 = 4,
        y1 = 12,
        x2 = 23,
        y2 = 14,
        type = "window",
        ox2 = 3,
        oy1 = -2,
        border = {
          color = 0,
          type = 1,
        },
        color = 2,
        oy2 = 5,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap center",
          Left = "Snap left",
          Right = "Snap center",
        },
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
      },
      {
        x1 = 26,
        y1 = 7,
        ox1 = 0,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        type = "window",
        ox2 = 3,
        x2 = 48,
        border = {
          color = 0,
          type = 1,
        },
        color = 2,
        oy2 = 1,
        snap = {
          Bottom = "Snap center",
          Top = "Snap top",
          Left = "Snap center",
          Right = "Snap right",
        },
        y2 = 9,
      },
      {
        x1 = 26,
        y1 = 12,
        ox1 = 0,
        y2 = 14,
        type = "window",
        ox2 = 3,
        event = {
          update = {
            [ 2 ] = -1,
          },
          focus = {
            [ 2 ] = -1,
          },
          mouse_up = {
            [ 2 ] = -1,
          },
          Coroutine = {
            [ 2 ] = -1,
          },
          mouse_click = {
            [ 2 ] = -1,
          },
          render = {
            [ 2 ] = -1,
          },
        },
        border = {
          color = 0,
          type = 1,
        },
        oy1 = -2,
        snap = {
          Bottom = "Snap bottom",
          Top = "Snap center",
          Left = "Snap center",
          Right = "Snap right",
        },
        oy2 = 5,
        color = 2,
        x2 = 48,
      },
    },
    x = 65,
    c = 3,
    y = 22,
    h = 19,
  },
}

for s=1,#slides do
	local slide = slides[s]
	for o=1,#slide.objs do
		local obj = slide.objs[o]
		for key,value in pairs(obj.event) do
			if assets[ value[2] ] then
				lUtils.shapescape.addScript(obj,value[2],key,assets,LevelOS,slides)
			else
				obj.event[key] = {function() end,-1}
			end
		end
	end
end

	local tArgs = {...}
if tArgs[1] and tArgs[1] == "load" then
	return {assets=assets,slides=slides}
end


return lUtils.shapescape.run(slides,...)