local lib = require("/User/Cloud/Public/Storage_Manager/api")

local x,y = term.getCursorPos()

local function wr(txt)
	term.setCursorPos(x,y)
	term.clearLine()
	term.setCursorPos(x,y)
	term.write(txt)
end

if not _G.setupCache then
	wr("Loading setup...")
	_G.setupCache = {lib.getSetup()}
end
local chests, input, output = unpack(setupCache)

local inv
if not _G.invCache then
	wr("Loading inventory...")
	inv = lib.getInventory(chests)
	_G.invCache = inv
else
	inv = invCache
end
wr("Inputting items...")
local ls = input.list()
for t=2,input.size() do
	if ls[t] then
		lib.inputItem(t,input,inv)
	end
end
wr("Reloading inventory...")
_G.invCache = lib.getInventory(chests)
wr("Done!")
print("")