/*
 * Decompiled with CFR 0.152.
 */
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class Updater {
    public static void main(String[] args) {
        System.out.println("=== PokeCubed Installer Updater Started ===");
        System.out.println("Args: " + String.join((CharSequence)", ", args));
        if (args.length < 3) {
            System.out.println("ERROR: Not enough arguments");
            System.out.println("Usage: java -jar updater.jar <new_installer_path> <target_jar> <new_version>");
            System.exit(1);
        }
        Path newInstallerPath = Paths.get(args[0], new String[0]);
        Path targetJar = Paths.get(args[1], new String[0]);
        String newVersion = args[2];
        System.out.println("New installer path: " + String.valueOf(newInstallerPath));
        System.out.println("Target JAR: " + String.valueOf(targetJar));
        System.out.println("New version: " + newVersion);
        try {
            System.out.println("Waiting for main installer to close...");
            Thread.sleep(5000L);
            System.out.println("Checking if new installer file exists...");
            if (!Files.exists(newInstallerPath, new LinkOption[0])) {
                System.out.println("ERROR: New installer file not found: " + String.valueOf(newInstallerPath));
                System.exit(1);
            }
            long newFileSize = Files.size(newInstallerPath);
            System.out.println("New installer file size: " + newFileSize + " bytes");
            if (newFileSize < 100000L) {
                System.out.println("ERROR: New installer file seems too small, might be corrupted");
                System.exit(1);
            }
            Path backupFile = Paths.get(targetJar.toString() + ".backup", new String[0]);
            if (Files.exists(targetJar, new LinkOption[0])) {
                System.out.println("Backing up original installer...");
                Files.move(targetJar, backupFile, StandardCopyOption.REPLACE_EXISTING);
                System.out.println("Backup created: " + String.valueOf(backupFile));
            } else {
                System.out.println("No existing installer found at " + String.valueOf(targetJar));
            }
            System.out.println("Moving new version to target location...");
            Files.move(newInstallerPath, targetJar, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Update file copy completed");
            System.out.println("Verifying new installer...");
            if (Files.exists(targetJar, new LinkOption[0])) {
                long finalSize = Files.size(targetJar);
                System.out.println("Final installer size: " + finalSize + " bytes");
                if (finalSize == newFileSize) {
                    System.out.println("File sizes match - update successful!");
                } else {
                    System.out.println("WARNING: File sizes don't match!");
                }
            } else {
                System.out.println("ERROR: Target jar doesn't exist after move!");
                System.exit(1);
            }
            System.out.println("Starting new installer...");
            ProcessBuilder pb = new ProcessBuilder("java", "-jar", targetJar.toString());
            pb.directory(targetJar.getParent().toFile());
            pb.start();
            System.out.println("New installer process started");
            Thread.sleep(2000L);
            if (Files.exists(backupFile, new LinkOption[0])) {
                System.out.println("Cleaning up backup file...");
                Files.delete(backupFile);
            }
            System.out.println("=== Update completed successfully! ===");
        }
        catch (Exception e) {
            System.out.println("ERROR: Update failed: " + e.getMessage());
            e.printStackTrace();
            Path backupFile = Paths.get(targetJar.toString() + ".backup", new String[0]);
            if (Files.exists(backupFile, new LinkOption[0])) {
                try {
                    System.out.println("Attempting to restore backup...");
                    Files.move(backupFile, targetJar, StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("Backup restored, starting original version...");
                    new ProcessBuilder("java", "-jar", targetJar.toString()).start();
                }
                catch (Exception restoreException) {
                    System.out.println("CRITICAL: Failed to restore backup: " + restoreException.getMessage());
                    restoreException.printStackTrace();
                }
            }
            System.exit(1);
        }
    }
}

