/*
 * Decompiled with CFR 0.152.
 */
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u0019\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f\u00a2\u0006\u0002\u0010\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"INSTALLER_VERSION", "", "CONFIG_URL", "FULL_CONFIG_URL", "FILE_INFO_URL", "logFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "timeFormatter", "Ljava/time/format/DateTimeFormatter;", "logMessage", "", "message", "main", "args", "", "([Ljava/lang/String;)V", "PokeCubed"})
public final class MainKt {
    @NotNull
    public static final String INSTALLER_VERSION = "1.0.1";
    @NotNull
    public static final String CONFIG_URL = "https://moreno.land/dl/mpack/moddata.json";
    @NotNull
    public static final String FULL_CONFIG_URL = "https://moreno.land/dl/mpack/pokecubedinstaller.json";
    @NotNull
    public static final String FILE_INFO_URL = "https://moreno.land/dl/mpack/file_info.php";
    private static final Path logFile = Paths.get("PokeCubedInstaller.log", new String[0]);
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("M/d/yyyy h:mm:ss a");

    public static final void logMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        String timestamp = LocalDateTime.now().format(timeFormatter);
        String logEntry = "[" + timestamp + "]: " + message + "\n";
        try {
            String string = logEntry;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            string = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            Files.write(logFile, byArray, (OpenOption[])string);
            System.out.println((Object)message);
        }
        catch (Exception e) {
            System.out.println((Object)("Failed to write to log: " + e.getMessage()));
            System.out.println((Object)message);
        }
    }

    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter(args, "args");
        boolean consoleMode = ArraysKt.contains(args, "--console");
        try {
            URI currentJarPath = ModpackInstaller.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            Path currentDir = Paths.get(currentJarPath).getParent();
            Path updaterPath = currentDir.resolve("PokeCubedUpdater.jar");
            if (Files.exists(updaterPath, new LinkOption[0])) {
                Thread.sleep(1000L);
                Files.deleteIfExists(updaterPath);
                MainKt.logMessage("Cleaned up updater file");
            }
        }
        catch (Exception e) {
            MainKt.logMessage("Failed to cleanup updater: " + e.getMessage());
        }
        if (consoleMode) {
            MainKt.logMessage("Console mode enabled");
        }
        SwingUtilities.invokeLater(() -> MainKt.main$lambda$0(consoleMode));
    }

    private static final void main$lambda$0(boolean $consoleMode) {
        new ModpackInstaller($consoleMode).setVisible(true);
    }
}

