/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.waystones.block.PortstoneBlock;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class ModBlocks {
    private static final class_1767[] portstoneColors = new class_1767[]{class_1767.field_7952, class_1767.field_7946, class_1767.field_7958, class_1767.field_7951, class_1767.field_7947, class_1767.field_7961, class_1767.field_7954, class_1767.field_7944, class_1767.field_7967, class_1767.field_7955, class_1767.field_7945, class_1767.field_7966, class_1767.field_7957, class_1767.field_7942, class_1767.field_7964, class_1767.field_7963};
    private static final class_1767[] sharestoneColors = new class_1767[]{class_1767.field_7946, class_1767.field_7958, class_1767.field_7951, class_1767.field_7947, class_1767.field_7961, class_1767.field_7954, class_1767.field_7944, class_1767.field_7967, class_1767.field_7955, class_1767.field_7945, class_1767.field_7966, class_1767.field_7957, class_1767.field_7942, class_1767.field_7964, class_1767.field_7963};
    public static class_2248 waystone;
    public static class_2248 mossyWaystone;
    public static class_2248 sandyWaystone;
    public static class_2248 deepslateWaystone;
    public static class_2248 blackstoneWaystone;
    public static class_2248 endStoneWaystone;
    public static class_2248 warpPlate;
    public static final PortstoneBlock[] portstones;
    public static final SharestoneBlock[] sharestones;

    public static void initialize(BalmBlocks blocks) {
        blocks.register(() -> {
            waystone = new WaystoneBlock(ModBlocks.defaultProperties());
            return waystone;
        }, () -> ModBlocks.itemBlock(waystone), ModBlocks.id("waystone"));
        blocks.register(() -> {
            mossyWaystone = new WaystoneBlock(ModBlocks.defaultProperties());
            return mossyWaystone;
        }, () -> ModBlocks.itemBlock(mossyWaystone), ModBlocks.id("mossy_waystone"));
        blocks.register(() -> {
            sandyWaystone = new WaystoneBlock(ModBlocks.defaultProperties());
            return sandyWaystone;
        }, () -> ModBlocks.itemBlock(sandyWaystone), ModBlocks.id("sandy_waystone"));
        blocks.register(() -> {
            deepslateWaystone = new WaystoneBlock(ModBlocks.defaultProperties().method_9626(class_2498.field_29033));
            return deepslateWaystone;
        }, () -> ModBlocks.itemBlock(deepslateWaystone), ModBlocks.id("deepslate_waystone"));
        blocks.register(() -> {
            blackstoneWaystone = new WaystoneBlock(ModBlocks.defaultProperties());
            return blackstoneWaystone;
        }, () -> ModBlocks.itemBlock(blackstoneWaystone), ModBlocks.id("blackstone_waystone"));
        blocks.register(() -> {
            endStoneWaystone = new WaystoneBlock(ModBlocks.defaultProperties());
            return endStoneWaystone;
        }, () -> ModBlocks.itemBlock(endStoneWaystone), ModBlocks.id("end_stone_waystone"));
        blocks.register(() -> {
            warpPlate = new WarpPlateBlock(ModBlocks.defaultProperties());
            return warpPlate;
        }, () -> ModBlocks.itemBlock(warpPlate), ModBlocks.id("warp_plate"));
        for (class_1767 color : portstoneColors) {
            blocks.register(() -> {
                PortstoneBlock portstoneBlock = new PortstoneBlock(color, ModBlocks.defaultProperties());
                ModBlocks.portstones[color.ordinal()] = portstoneBlock;
                return portstoneBlock;
            }, () -> ModBlocks.itemBlock((class_2248)portstones[color.ordinal()]), ModBlocks.id(color.method_15434() + "_portstone"));
        }
        for (class_1767 color : sharestoneColors) {
            blocks.register(() -> {
                SharestoneBlock sharestoneBlock = new SharestoneBlock(color, ModBlocks.defaultProperties());
                ModBlocks.sharestones[color.ordinal() - 1] = sharestoneBlock;
                return sharestoneBlock;
            }, () -> ModBlocks.itemBlock((class_2248)sharestones[color.ordinal() - 1]), ModBlocks.id(color.method_15434() + "_sharestone"));
        }
    }

    private static class_1747 itemBlock(class_2248 block) {
        return new class_1747(block, Balm.getItems().itemProperties());
    }

    private static class_2960 id(String name) {
        return class_2960.method_60655((String)"waystones", (String)name);
    }

    private static class_4970.class_2251 defaultProperties() {
        return Balm.getBlocks().blockProperties().method_9626(class_2498.field_11544).method_9629(5.0f, 2000.0f);
    }

    @Nullable
    public static SharestoneBlock getSharestone(class_1767 color) {
        int index = color.ordinal() - 1;
        if (index < 0 || index >= sharestones.length) {
            return null;
        }
        return sharestones[index];
    }

    @Nullable
    public static PortstoneBlock getPortstone(class_1767 color) {
        int index = color.ordinal();
        if (index >= portstones.length) {
            return null;
        }
        return portstones[index];
    }

    static {
        portstones = new PortstoneBlock[portstoneColors.length];
        sharestones = new SharestoneBlock[sharestoneColors.length];
    }
}

