/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.client.model.BackpackBakedQuadCollector;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_804;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BackpackBakedModel
implements class_1087 {
    private final BackpackBakedQuadCollector bakedQuads;
    private static final class_809 ITEM_TRANSFORMS = BackpackBakedModel.createItemTransforms();

    public BackpackBakedModel(class_1087 backpack, class_1087 dyedBackpack) {
        this.bakedQuads = new BackpackBakedQuadCollector(backpack, dyedBackpack);
        class_5819 random = class_5819.method_43049((long)0L);
        this.bakedQuads.collectBakedQuads(null, random);
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        BackpackBlockEntity.BackpackRenderData renderData = (BackpackBlockEntity.BackpackRenderData)blockView.getBlockEntityRenderData(pos);
        if (renderData == null) {
            renderData = new BackpackBlockEntity.BackpackRenderData(RenderInfo.EMPTY, -1, false, class_1767.field_7964.method_7789());
        }
        RenderInfo info = renderData.info() == null ? RenderInfo.EMPTY : renderData.info();
        class_2350 direction = class_2350.field_11043;
        if (state.method_11654((class_2769)TravelersBackpackBlock.FACING) != null) {
            direction = (class_2350)state.method_11654((class_2769)TravelersBackpackBlock.FACING);
        }
        int index = direction.method_10161();
        if (state.method_26204() == ModBlocks.STANDARD_TRAVELERS_BACKPACK && renderData.dyeColor() != -1) {
            this.emitDyedBaseQuads(context.getEmitter(), index);
        } else {
            this.emitBaseQuads(context.getEmitter());
        }
        this.emitTanksQuads(context.getEmitter(), info, index);
        if (!renderData.isSleepingBagDeployed()) {
            this.emitSleepingBagQuads(context.getEmitter(), renderData.sleepingBagColor());
        }
        this.emitExtras(context.getEmitter(), new class_1799((class_1935)state.method_26204()).method_7909());
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        RenderInfo info = (RenderInfo)stack.method_57824(ModDataComponents.RENDER_INFO);
        int color = (Integer)stack.method_57825(ModDataComponents.SLEEPING_BAG_COLOR, (Object)class_1767.field_7964.method_7789());
        int dyeColor = ((class_9282)stack.method_57825(class_9334.field_49644, (Object)new class_9282(-1, false))).comp_2384();
        if (stack.method_7909() == ModItems.STANDARD_TRAVELERS_BACKPACK && dyeColor != -1) {
            this.emitDyedBaseQuads(context.getEmitter(), 0);
        } else {
            this.emitBaseQuads(context.getEmitter());
        }
        this.emitTanksQuads(context.getEmitter(), info, 0);
        this.emitSleepingBagQuads(context.getEmitter(), color);
        this.emitExtras(context.getEmitter(), stack.method_7909());
    }

    private void emitBaseQuads(QuadEmitter emitter) {
        this.bakedQuads.getBaseQuads().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
    }

    private void emitDyedBaseQuads(QuadEmitter emitter, int index) {
        this.bakedQuads.getDyedBaseQuads().forEach(quad -> {
            emitter.fromVanilla(quad, emitter.material(), null);
            float centerX = 0.5f;
            float centerZ = 0.5f;
            float angleDegrees = (float)index * 90.0f;
            float radians = (float)Math.toRadians(angleDegrees);
            float cos = (float)Math.cos(radians);
            float sin = (float)Math.sin(radians);
            for (int i = 0; i < 4; ++i) {
                float x = emitter.x(i) - 0.5f;
                float y = emitter.y(i);
                float z = emitter.z(i) - 0.5f;
                float newX = x * cos - z * sin;
                float newZ = x * sin + z * cos;
                emitter.pos(i, newX + 0.5f, y, newZ + 0.5f);
            }
            emitter.emit();
        });
    }

    private void emitExtras(QuadEmitter emitter, class_1792 item) {
        if (item == ModItems.FOX_TRAVELERS_BACKPACK) {
            this.bakedQuads.getFoxNose().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
        if (item == ModItems.WOLF_TRAVELERS_BACKPACK) {
            this.bakedQuads.getWolfNose().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
        if (item == ModItems.WARDEN_TRAVELERS_BACKPACK) {
            this.bakedQuads.getWardenHorns().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
        if (item == ModItems.OCELOT_TRAVELERS_BACKPACK) {
            this.bakedQuads.getOcelotNose().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
        if (item == ModItems.PIG_TRAVELERS_BACKPACK || item == ModItems.HORSE_TRAVELERS_BACKPACK) {
            this.bakedQuads.getPigNose().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
        if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK) {
            this.bakedQuads.getVillagerNose().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
    }

    private void emitTanksQuads(QuadEmitter emitter, RenderInfo info, int index) {
        if (info == null || info.hasTanks()) {
            this.bakedQuads.getTanksQuads().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
            this.addFluids(emitter, info, index);
        }
    }

    private void emitSleepingBagQuads(QuadEmitter emitter, int color) {
        this.bakedQuads.getSleepingBagExtrasQuads().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_2960.method_60655((String)"travelersbackpack", (String)("block/bag/" + class_1767.method_7791((int)color).method_7792().toLowerCase(Locale.ENGLISH) + "_sleeping_bag")));
        this.rebakeSleepingBag(emitter, sprite);
    }

    private void rebakeSleepingBag(QuadEmitter emitter, class_1058 sprite) {
        this.bakedQuads.getSleepingBagQuads().forEach(quad -> {
            class_1058 oldSprite = quad.method_35788();
            int[] oldData = quad.method_3357();
            int[] newData = Arrays.copyOf(oldData, oldData.length);
            for (int i = 0; i < 4; ++i) {
                int index = i * 8;
                float oldU = Float.intBitsToFloat(oldData[index + 4]);
                float oldV = Float.intBitsToFloat(oldData[index + 5]);
                float uUn = oldSprite.method_35804(oldU);
                float vUn = oldSprite.method_35805(oldV);
                float newU = sprite.method_4580(uUn);
                float newV = sprite.method_4570(vUn);
                newData[index + 4] = Float.floatToRawIntBits(newU);
                newData[index + 5] = Float.floatToRawIntBits(newV);
                class_777 rebaked = new class_777(newData, quad.method_3359(), quad.method_3358(), sprite, quad.method_24874());
                emitter.fromVanilla(rebaked, emitter.material(), null).emit();
            }
        });
    }

    private void addFluids(QuadEmitter emitter, RenderInfo renderInfo, int index) {
        if (renderInfo != null && !renderInfo.isEmpty()) {
            if (!renderInfo.getLeftFluidStack().isEmpty()) {
                this.addFluid(emitter, renderInfo.getLeftFluidStack(), (float)renderInfo.getLeftFluidStack().getAmount() / (float)renderInfo.getCapacity(), 0.1125f, index);
            }
            if (!renderInfo.getRightFluidStack().isEmpty()) {
                this.addFluid(emitter, renderInfo.getRightFluidStack(), (float)renderInfo.getRightFluidStack().getAmount() / (float)renderInfo.getCapacity(), 0.79375f, index);
            }
        }
    }

    private void addFluid(QuadEmitter emitter, FluidVariantWrapper fluidStack, float ratio, double xMin, int index) {
        if (fluidStack.isEmpty() || class_3532.method_15347((float)ratio, (float)0.0f)) {
            return;
        }
        double yMin = 0.05;
        double yMax = yMin + (double)ratio * 6.2 / 16.0;
        class_238 bounds = new class_238(xMin, yMin, 0.39375, xMin + 0.09375, yMax, 0.4875);
        int color = FluidVariantRendering.getColor((FluidVariant)fluidStack.fluidVariant()) | 0xFF000000;
        class_1058 still = FluidVariantRendering.getSprite((FluidVariant)fluidStack.fluidVariant());
        float bx1 = 0.0f;
        float bx2 = 3.0f;
        float by1 = 0.0f;
        float by2 = ratio * 12.0f;
        float bz1 = 0.0f;
        float bz2 = 3.0f;
        this.createQuad(List.of(this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index), this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index)), still, class_2350.field_11036, false, color, bx1, 4.0f, bz1, 4.0f, emitter);
        this.createQuad(List.of(this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321, index), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321, index), this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index)), still, class_2350.field_11043, false, color, bx1, bx2, by1, by2, emitter);
        this.createQuad(List.of(this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index)), still, class_2350.field_11035, false, color, bx1, bx2, by1, by2, emitter);
        this.createQuad(List.of(this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321, index), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324, index), this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index)), still, class_2350.field_11039, false, color, bz1, bz2, by1, by2, emitter);
        this.createQuad(List.of(this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321, index), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index)), still, class_2350.field_11034, false, color, bz1, bz2, by1, by2, emitter);
    }

    private void addSleepingBag(QuadEmitter emitter, int color, int index) {
        float minX = 0.1625f;
        float minY = 0.05f;
        float minZ = 0.55625f;
        float maxX = 0.84375f;
        float maxY = 0.15f;
        float maxZ = 0.65625f;
        class_238 bounds = new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_2960.method_60655((String)"travelersbackpack", (String)("block/bags/" + class_1767.method_7791((int)color).method_7792().toLowerCase(Locale.ENGLISH) + "_sleeping_bag")));
        this.createQuad(List.of(this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321, index), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321, index), this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index)), sprite, class_2350.field_11043, true, -1, 11.5f, 15.25f, 0.5f, 1.0f, emitter);
        this.createQuad(List.of(this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index)), sprite, class_2350.field_11035, true, -1, 8.25f, 12.25f, 0.5f, 1.0f, emitter);
        this.createQuad(List.of(this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321, index), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324, index), this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index)), sprite, class_2350.field_11039, true, -1, 7.75f, 8.25f, 0.5f, 1.0f, emitter);
        this.createQuad(List.of(this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321, index), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index)), sprite, class_2350.field_11034, true, -1, 15.25f, 15.75f, 0.5f, 1.0f, emitter);
        this.createQuad(List.of(this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index), this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index)), sprite, class_2350.field_11036, true, -1, 12.0f, 8.25f, 0.5f, 0.0f, emitter);
        this.createQuad(List.of(this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321, index), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324, index), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324, index), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321, index)), sprite, class_2350.field_11033, true, -1, 15.25f, 11.5f, 0.0f, 0.5f, emitter);
    }

    private Vector3f getVector(double x, double y, double z, int index) {
        Vector3f ret = new Vector3f((float)x, (float)y, (float)z);
        this.rotate(ret, new Matrix4f().rotateY((float)Math.toRadians(-(index * 90))));
        return ret;
    }

    private void rotate(Vector3f posIn, Matrix4f transform) {
        Vector3f originIn = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector4f vector4f = transform.transform(new Vector4f(posIn.x() - originIn.x(), posIn.y() - originIn.y(), posIn.z() - originIn.z(), 1.0f));
        posIn.set(vector4f.x() + originIn.x(), vector4f.y() + originIn.y(), vector4f.z() + originIn.z());
    }

    private void createQuad(List<Vector3f> vecs, class_1058 sprite, class_2350 face, boolean hasAmbientOcclusion, int color, float u1x, float u2x, float v1x, float v2x, QuadEmitter emitter) {
        class_2382 dirVec = face.method_10163();
        float u1 = sprite.method_4580(u1x /= 16.0f);
        float u2 = sprite.method_4580(u2x /= 16.0f);
        float v1 = sprite.method_4570(v1x /= 16.0f);
        float v2 = sprite.method_4570(v2x /= 16.0f);
        emitter.cullFace(face);
        emitter.nominalFace(face);
        emitter.spriteBake(sprite, 0);
        if (!hasAmbientOcclusion && RendererAccess.INSTANCE.hasRenderer()) {
            emitter.material(RendererAccess.INSTANCE.getRenderer().materialFinder().ambientOcclusion(TriState.FALSE).find());
        }
        emitter.pos(0, vecs.get(0));
        emitter.color(0, color);
        emitter.uv(0, u1, v1);
        emitter.normal(0, (float)dirVec.method_10263(), (float)dirVec.method_10264(), (float)dirVec.method_10260());
        emitter.pos(1, vecs.get(1));
        emitter.color(1, color);
        emitter.uv(1, u1, v2);
        emitter.normal(1, (float)dirVec.method_10263(), (float)dirVec.method_10264(), (float)dirVec.method_10260());
        emitter.pos(2, vecs.get(2));
        emitter.color(2, color);
        emitter.uv(2, u2, v2);
        emitter.normal(2, (float)dirVec.method_10263(), (float)dirVec.method_10264(), (float)dirVec.method_10260());
        emitter.pos(3, vecs.get(3));
        emitter.color(3, color);
        emitter.uv(3, u2, v1);
        emitter.normal(3, (float)dirVec.method_10263(), (float)dirVec.method_10264(), (float)dirVec.method_10260());
        emitter.emit();
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
        return this.bakedQuads.getBaseQuads();
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.bakedQuads.getBackpackBakedModel().method_4711();
    }

    public class_809 method_4709() {
        return ITEM_TRANSFORMS;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    private static class_809 createItemTransforms() {
        return new class_809(new class_804(new Vector3f(60.0f, -180.0f, 0.0f), new Vector3f(0.0f, 0.09375f, 0.03125f), new Vector3f(0.7f, 0.7f, 0.7f)), new class_804(new Vector3f(60.0f, -180.0f, 0.0f), new Vector3f(0.0f, 0.09375f, 0.03125f), new Vector3f(0.7f, 0.7f, 0.7f)), new class_804(new Vector3f(0.0f, -90.0f, 12.5f), new Vector3f(0.070625f, 0.375f, 0.125f), new Vector3f(0.68f, 0.68f, 0.68f)), new class_804(new Vector3f(0.0f, -90.0f, 12.5f), new Vector3f(0.070625f, 0.375f, 0.125f), new Vector3f(0.68f, 0.68f, 0.68f)), new class_804(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(0.0f, 0.90625f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), new class_804(new Vector3f(30.0f, -38.0f, 0.0f), new Vector3f(-0.015625f, 0.140625f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), new class_804(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.125f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)), new class_804(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(0.0f, 0.140625f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)));
    }
}

