/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.gpu;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.api.ReferenceableLuaObject;
import com.tom.peripherals.gpu.BaseGPU;
import com.tom.peripherals.gpu.GPUImpl;
import com.tom.peripherals.gpu.LuaByteBuffer;
import com.tom.peripherals.gpu.VRAM;
import com.tom.peripherals.util.Image;
import com.tom.peripherals.util.ImageIO;
import com.tom.peripherals.util.ParamCheck;
import java.io.IOException;

public class LuaImage
extends ReferenceableLuaObject
implements BaseGPU.GPUContext,
VRAM.VRAMObject {
    private final VRAM vram;
    private Image image;

    public LuaImage(VRAM vram, Image image) {
        super(vram.getRefMngr());
        this.vram = vram;
        this.image = image;
    }

    @Override
    @LuaMethod
    public int getWidth() {
        if (this.image == null) {
            throw new LuaException("Error: Use after free");
        }
        return this.image.getWidth();
    }

    @Override
    @LuaMethod
    public int getHeight() {
        if (this.image == null) {
            throw new LuaException("Error: Use after free");
        }
        return this.image.getHeight();
    }

    @LuaMethod
    public Object[] getAsBuffer() {
        if (this.image == null) {
            throw new LuaException("Error: Use after free");
        }
        Object[] a = new Object[this.image.getWidth() * this.image.getHeight()];
        int[] d = this.image.getData();
        for (int i = 0; i < d.length; ++i) {
            a[i] = d[i];
        }
        return a;
    }

    @Override
    @LuaMethod
    public Object ref() {
        if (this.image == null) {
            throw new LuaException("Error: Use after free");
        }
        return super.ref();
    }

    @Override
    public void set(int x, int y, int c) {
        if (this.image == null) {
            throw new LuaException("Error: Use after free");
        }
        this.image.setRGB(x, y, c);
    }

    @Override
    public void sync() {
    }

    @LuaMethod
    public Object gpuDraw() throws LuaException {
        if (this.image == null) {
            throw new LuaException("Error: Use after free");
        }
        return new GPUImpl(this);
    }

    @Override
    public VRAM getVRam() {
        return this.vram;
    }

    @Override
    public long getSize() {
        return this.getWidth() * this.getHeight() * 4;
    }

    public Image getImage() throws LuaException {
        if (this.image == null) {
            throw new LuaException("Error: Use after free");
        }
        return this.image;
    }

    @LuaMethod
    public void free() throws LuaException {
        if (this.image == null) {
            return;
        }
        this.vram.getRefMngr().remove(this);
        this.vram.free(this);
        this.image = null;
    }

    @LuaMethod
    public Object[] saveImage() throws LuaException {
        if (this.image == null) {
            throw new LuaException("Error: Use after free");
        }
        LuaByteBuffer buf = new LuaByteBuffer(this.vram);
        try {
            ImageIO.write(this.image, buf.asOutputStream());
        }
        catch (IOException e) {
            throw new LuaException(e.getMessage());
        }
        return new Object[]{buf};
    }

    @LuaMethod
    public void setRGB(Object[] a) throws LuaException {
        int x = ParamCheck.getInt(a, 0) + 1;
        int y = ParamCheck.getInt(a, 1) + 1;
        int rgb = ParamCheck.toColor(a, 2);
        this.image.setRGB(x, y, rgb);
    }

    @LuaMethod
    public int getRGB(Object[] a) throws LuaException {
        int x = ParamCheck.getInt(a, 0) + 1;
        int y = ParamCheck.getInt(a, 1) + 1;
        return this.image.getRGB(x, y);
    }
}

