/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.client;

import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.cc.CCMonitor;
import com.tom.peripherals.client.MonHandler;
import com.tom.peripherals.client.MonitorHandler;
import com.tom.peripherals.network.Network;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import java.util.BitSet;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3544;
import net.minecraft.class_3965;
import net.minecraft.class_6382;

public class KeyboardWidget
extends class_339 {
    private final class_310 mc = class_310.method_1551();
    private float terminateTimer = -1.0f;
    private float rebootTimer = -1.0f;
    private float shutdownTimer = -1.0f;
    private final BitSet keysDown = new BitSet(256);
    private MonitorHandler monHandler;

    public KeyboardWidget() {
        super(0, 0, 0, 0, (class_2561)class_2561.method_43473());
    }

    public boolean method_25400(char ch, int modifiers) {
        if (ch >= ' ' && ch <= '~' || ch >= '\u00a0' && ch <= '\u00ff') {
            this.charType(ch);
        }
        return true;
    }

    public boolean method_25404(int key, int scancode, int modifiers) {
        if (key == 256) {
            return false;
        }
        if ((modifiers & 2) != 0) {
            switch (key) {
                case 82: {
                    if (this.rebootTimer < 0.0f) {
                        this.rebootTimer = 0.0f;
                    }
                    return true;
                }
                case 83: {
                    if (this.shutdownTimer < 0.0f) {
                        this.shutdownTimer = 0.0f;
                    }
                    return true;
                }
                case 84: {
                    if (this.terminateTimer < 0.0f) {
                        this.terminateTimer = 0.0f;
                    }
                    return true;
                }
                default: {
                    break;
                }
                case 86: {
                    String clipboard = this.mc.field_1774.method_1460();
                    if (clipboard == null) break;
                    int newLineIndex1 = clipboard.indexOf("\r");
                    int newLineIndex2 = clipboard.indexOf("\n");
                    if (newLineIndex1 >= 0 && newLineIndex2 >= 0) {
                        clipboard = clipboard.substring(0, Math.min(newLineIndex1, newLineIndex2));
                    } else if (newLineIndex1 >= 0) {
                        clipboard = clipboard.substring(0, newLineIndex1);
                    } else if (newLineIndex2 >= 0) {
                        clipboard = clipboard.substring(0, newLineIndex2);
                    }
                    clipboard = class_3544.method_57180((String)clipboard);
                    if (!clipboard.isEmpty()) {
                        if (clipboard.length() > 512) {
                            clipboard = clipboard.substring(0, 512);
                        }
                        this.pasteContent(clipboard);
                    }
                    return true;
                }
            }
        }
        if (key >= 0 && this.terminateTimer < 0.0f && this.rebootTimer < 0.0f && this.shutdownTimer < 0.0f) {
            boolean repeat = this.keysDown.get(key);
            this.keysDown.set(key);
            this.keyDown(key, repeat);
        }
        return true;
    }

    private void pasteContent(String clipboard) {
        class_2487 tag = new class_2487();
        tag.method_10582("action", "paste");
        tag.method_10582("v", clipboard);
        Network.sendToContainer(tag);
    }

    private void keyDown(int key, boolean repeat) {
        class_2487 tag = new class_2487();
        tag.method_10582("action", "keyDown");
        tag.method_10569("key", key);
        tag.method_10556("r", repeat);
        Network.sendToContainer(tag);
    }

    private void keyUp(int key) {
        class_2487 tag = new class_2487();
        tag.method_10582("action", "keyUp");
        tag.method_10569("key", key);
        Network.sendToContainer(tag);
    }

    private void charType(char ch) {
        class_2487 tag = new class_2487();
        tag.method_10582("action", "char");
        tag.method_10575("char", (short)ch);
        Network.sendToContainer(tag);
    }

    private void queueEvent(String string) {
        class_2487 tag = new class_2487();
        tag.method_10582("action", "event");
        tag.method_10582("name", string);
        Network.sendToContainer(tag);
    }

    public boolean method_16803(int key, int scancode, int modifiers) {
        if (key >= 0 && this.keysDown.get(key)) {
            this.keysDown.set(key, false);
            this.keyUp(key);
        }
        switch (key) {
            case 82: {
                this.rebootTimer = -1.0f;
                break;
            }
            case 83: {
                this.shutdownTimer = -1.0f;
                break;
            }
            case 84: {
                this.terminateTimer = -1.0f;
                break;
            }
            case 341: 
            case 345: {
                this.shutdownTimer = -1.0f;
                this.rebootTimer = -1.0f;
                this.terminateTimer = -1.0f;
            }
        }
        return true;
    }

    public void update() {
        if (this.terminateTimer >= 0.0f && this.terminateTimer < 0.5f) {
            float f;
            this.terminateTimer += 0.05f;
            if (f > 0.5f) {
                this.queueEvent("terminate");
            }
        }
        if (this.shutdownTimer >= 0.0f && this.shutdownTimer < 0.5f) {
            float f;
            this.shutdownTimer += 0.05f;
            if (f > 0.5f) {
                this.queueEvent("shutdown");
            }
        }
        if (this.rebootTimer >= 0.0f && this.rebootTimer < 0.5f) {
            float f;
            this.rebootTimer += 0.05f;
            if (f > 0.5f) {
                this.queueEvent("reboot");
            }
        }
    }

    public void method_48579(class_332 p_93657_, int p_93658_, int p_93659_, float p_93660_) {
        class_3965 lookingAt = (class_3965)this.mc.field_1724.method_5745(32.0, 0.0f, true);
        class_2680 state = this.mc.field_1687.method_8320(lookingAt.method_17777());
        MonitorHandler mh = this.monHandler;
        class_2586 class_25862 = this.mc.field_1687.method_8321(lookingAt.method_17777());
        if (class_25862 instanceof MonitorBlockEntity) {
            MonitorBlockEntity be = (MonitorBlockEntity)class_25862;
            MonitorHandler monitorHandler = this.monHandler;
            if (monitorHandler instanceof MonHandler) {
                h = (MonHandler)monitorHandler;
                ((MonHandler)h).setLookingAt(lookingAt, be);
            } else {
                mh = new MonHandler(lookingAt, be);
            }
        } else if (state.method_26204() instanceof MonitorBlock) {
            MonitorHandler monitorHandler = this.monHandler;
            if (monitorHandler instanceof CCMonitor) {
                h = (CCMonitor)monitorHandler;
                ((CCMonitor)h).setLookingAt(lookingAt);
            } else {
                mh = new CCMonitor(lookingAt);
            }
        } else {
            mh = null;
        }
        if (mh != this.monHandler) {
            if (this.monHandler != null) {
                this.monHandler.onOffScreen();
            }
            this.monHandler = mh;
        }
    }

    public boolean method_25402(double p_93641_, double p_93642_, int button) {
        if (this.monHandler != null) {
            this.monHandler.mouseClick(button + 1);
        }
        return true;
    }

    public boolean method_25406(double p_93684_, double p_93685_, int button) {
        if (this.monHandler != null) {
            this.monHandler.mouseRelease(button + 1);
        }
        return true;
    }

    public boolean method_25403(double p_93645_, double p_93646_, int button, double p_93648_, double p_93649_) {
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double dx, double delta) {
        if (delta != 0.0) {
            if (this.monHandler != null) {
                this.monHandler.mouseScroll(delta < 0.0 ? 1 : -1);
            }
            return true;
        }
        return false;
    }

    public void method_25365(boolean focused) {
        if (!focused) {
            // empty if block
        }
    }

    public void release() {
        for (int key = 0; key < this.keysDown.size(); ++key) {
            if (!this.keysDown.get(key)) continue;
            this.keyUp(key);
        }
        this.keysDown.clear();
        if (this.monHandler != null) {
            this.monHandler.onOffScreen();
            this.monHandler = null;
        }
        this.rebootTimer = -1.0f;
        this.terminateTimer = -1.0f;
        this.shutdownTimer = -1.0f;
    }

    public boolean method_25405(double p_93672_, double p_93673_) {
        return true;
    }

    public class_2561 getInfo() {
        return this.monHandler != null ? this.monHandler.infoComponent() : class_2561.method_43473();
    }

    protected void method_47399(class_6382 p_259858_) {
    }
}

