/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals;

import com.mojang.logging.LogUtils;
import com.tom.peripherals.Config;
import com.tom.peripherals.Content;
import com.tom.peripherals.network.Network;
import com.tom.peripherals.platform.AbstractPeripheralBlockEntity;
import com.tom.peripherals.platform.Platform;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeConfigRegistry;
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeModConfigEvents;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2591;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.slf4j.Logger;

public class PeripheralsMod
implements ModInitializer {
    public static final String ID = "toms_peripherals";
    public static final Logger LOGGER = LogUtils.getLogger();

    public void onInitialize() {
        Content.init();
        Platform.register();
        NeoForgeConfigRegistry.INSTANCE.register(ID, ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        NeoForgeConfigRegistry.INSTANCE.register(ID, ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        NeoForgeModConfigEvents.loading((String)ID).register(c -> {
            LOGGER.info("Loaded Tom's Peripherals config file {}", (Object)c.getFileName());
            Config.load(c);
        });
        NeoForgeModConfigEvents.reloading((String)ID).register(c -> {
            LOGGER.info("Tom's Peripherals config just got changed on the file system!");
            Config.load(c);
        });
        PeripheralLookup.get().registerForBlockEntities((b, side) -> {
            if (b instanceof AbstractPeripheralBlockEntity) {
                AbstractPeripheralBlockEntity be = (AbstractPeripheralBlockEntity)b;
                return be.getCCPeripheral();
            }
            return null;
        }, new class_2591[]{(class_2591)Content.gpuBE.get(), (class_2591)Content.redstonePortBE.get(), (class_2591)Content.wdtBE.get(), (class_2591)Content.keyboardBE.get()});
        Network.initCommon();
    }
}

