/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.ContainerWidget;
import com.supermartijn642.core.gui.widget.MutableWidgetRenderContext;
import com.supermartijn642.core.gui.widget.Widget;
import dev.architectury.event.events.client.ClientGuiEvent;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_465;

public class WidgetContainerScreen<T extends Widget, X extends BaseContainer>
extends class_465<X> {
    private static final class_2960 SLOT_TEXTURE = class_2960.method_60655((String)"supermartijn642corelib", (String)"textures/gui/slot.png");
    private final MutableWidgetRenderContext widgetRenderContext = MutableWidgetRenderContext.create();
    protected final X container;
    protected final T widget;
    private boolean initialized = false;
    private final boolean drawSlots;
    private final boolean isPauseScreen;

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots, isPauseScreen);
    }

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots);
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        super(container, ((BaseContainer)((Object)container)).player.method_31548(), (class_2561)TextComponents.empty().get());
        this.widget = widget;
        this.container = container;
        this.drawSlots = drawSlots;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots) {
        this(widget, container, drawSlots, false);
    }

    public void method_25426() {
        if (!this.initialized) {
            if (this.widget instanceof ContainerWidget) {
                ((ContainerWidget)this.widget).initialize(this.container);
            } else {
                this.widget.initialize();
            }
            this.initialized = true;
        }
        this.field_2792 = this.widget.width();
        this.field_2779 = this.widget.height();
        super.method_25426();
    }

    public void method_25419() {
        this.widget.discard();
        super.method_25419();
    }

    protected void method_37432() {
        this.widget.update();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        class_1799 cursorStack;
        this.widgetRenderContext.update(guiGraphics, partialTicks);
        this.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
        if (CoreLib.isArchitecturyLoaded) {
            ((ClientGuiEvent.ContainerScreenRenderBackground)ClientGuiEvent.RENDER_CONTAINER_BACKGROUND.invoker()).render((class_465)this, guiGraphics, mouseX, mouseY, partialTicks);
        }
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        int offsetY = (this.field_22790 - this.widget.height()) / 2;
        int offsetMouseX = mouseX - offsetX;
        int offsetMouseY = mouseY - offsetY;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)offsetX, (float)offsetY, 0.0f);
        RenderSystem.disableDepthTest();
        this.widget.setFocused(offsetMouseX >= 0 && offsetMouseX < this.widget.width() && offsetMouseY >= 0 && offsetMouseY < this.widget.height());
        this.widget.renderBackground(this.widgetRenderContext, offsetMouseX, offsetMouseY);
        if (this.drawSlots) {
            for (class_1735 slot : ((BaseContainer)((Object)this.container)).field_7761) {
                ScreenUtils.bindTexture(SLOT_TEXTURE);
                ScreenUtils.drawTexture(guiGraphics.method_51448(), slot.field_7873 - 1, slot.field_7872 - 1, 18.0f, 18.0f);
            }
        }
        this.widget.render(this.widgetRenderContext, offsetMouseX, offsetMouseY);
        this.field_2787 = null;
        for (class_1735 slot : ((BaseContainer)((Object)this.container)).field_7761) {
            if (!slot.method_7682()) continue;
            this.method_2385(guiGraphics, slot);
            if (!this.method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY)) continue;
            this.field_2787 = slot;
            WidgetContainerScreen.method_33285((class_332)guiGraphics, (int)slot.field_7873, (int)slot.field_7872, (int)0);
        }
        this.widget.renderForeground(this.widgetRenderContext, offsetMouseX, offsetMouseY);
        this.method_2380(guiGraphics, offsetMouseX, offsetMouseY);
        if (CoreLib.isArchitecturyLoaded) {
            ((ClientGuiEvent.ContainerScreenRenderForeground)ClientGuiEvent.RENDER_CONTAINER_FOREGROUND.invoker()).render((class_465)this, guiGraphics, mouseX, mouseY, partialTicks);
        }
        class_1799 class_17992 = cursorStack = this.field_2782.method_7960() ? ((BaseContainer)this.field_2797).method_34255() : this.field_2782;
        if (!cursorStack.method_7960()) {
            int offset = this.field_2782.method_7960() ? 8 : 16;
            String s = null;
            if (!this.field_2782.method_7960() && this.field_2789) {
                cursorStack = cursorStack.method_7972();
                cursorStack.method_7939(class_3532.method_15386((float)((float)cursorStack.method_7947() / 2.0f)));
            } else if (this.field_2794 && this.field_2793.size() > 1) {
                cursorStack = cursorStack.method_7972();
                cursorStack.method_7939(this.field_2803);
                if (cursorStack.method_7960()) {
                    s = String.valueOf(class_124.field_1054) + "0";
                }
            }
            this.method_2382(guiGraphics, cursorStack, offsetMouseX - 8, offsetMouseY - offset, s);
        }
        if (!this.field_2785.method_7960()) {
            float f = (float)(class_156.method_658() - this.field_2795) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.field_2785 = class_1799.field_8037;
            }
            int j2 = this.field_2802.field_7873 - this.field_2784;
            int k2 = this.field_2802.field_7872 - this.field_2796;
            int j1 = this.field_2784 + (int)((float)j2 * f);
            int k1 = this.field_2796 + (int)((float)k2 * f);
            this.method_2382(guiGraphics, this.field_2785, j1, k1, null);
        }
        this.widget.renderOverlay(this.widgetRenderContext, offsetMouseX, offsetMouseY);
        this.widget.renderTooltips(this.widgetRenderContext, offsetMouseX, offsetMouseY);
        guiGraphics.method_51448().method_22909();
        RenderSystem.enableDepthTest();
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        return this.widget.mousePressed((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.field_22790 - this.widget.height()) / 2), button, false) || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        return this.widget.mouseReleased((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.field_22790 - this.widget.height()) / 2), button, false) || super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int offsetY;
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.field_22790 - this.widget.height()) / 2), horizontalAmount, false) || super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.widget.keyPressed(keyCode, false)) {
            return true;
        }
        if (ClientUtils.getMinecraft().field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.widget.keyReleased(keyCode, false) || super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char character, int modifiers) {
        return this.widget.charTyped(character, false) || super.method_25400(character, modifiers);
    }

    public boolean method_25421() {
        return this.isPauseScreen;
    }

    public class_2561 method_25435() {
        class_2561 message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

