/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2960;

public class AndResourceCondition
implements ResourceCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final List<ResourceCondition> conditions;

    public AndResourceCondition(ResourceCondition ... conditions) {
        this.conditions = new ArrayList<ResourceCondition>(Arrays.asList(conditions));
    }

    @Override
    public boolean test(ResourceConditionContext context) {
        for (ResourceCondition condition : this.conditions) {
            if (condition.test(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResourceConditionSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public ResourceCondition and(ResourceCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    private static class Serializer
    implements ResourceConditionSerializer<AndResourceCondition> {
        private Serializer() {
        }

        @Override
        public void serialize(JsonObject json, AndResourceCondition condition) {
            JsonArray conditions = new JsonArray();
            for (ResourceCondition alternative : condition.conditions) {
                JsonObject conditionJson = new JsonObject();
                alternative.getSerializer().serialize(conditionJson, alternative);
                conditionJson.addProperty("condition", Registries.RESOURCE_CONDITION_SERIALIZERS.getIdentifier(alternative.getSerializer()).toString());
                conditions.add((JsonElement)conditionJson);
            }
            json.add("conditions", (JsonElement)conditions);
        }

        @Override
        public AndResourceCondition deserialize(JsonObject json) {
            if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
                throw new RuntimeException("Condition must have key 'conditions' with a json array!");
            }
            JsonArray conditionsJson = json.getAsJsonArray("conditions");
            ResourceCondition[] conditions = new ResourceCondition[conditionsJson.size()];
            for (int i = 0; i < conditionsJson.size(); ++i) {
                JsonObject conditionJson = conditionsJson.get(i).getAsJsonObject();
                class_2960 identifier = class_2960.method_12829((String)conditionJson.get("condition").getAsString());
                if (!Registries.RESOURCE_CONDITION_SERIALIZERS.hasIdentifier(identifier)) {
                    throw new RuntimeException("Could not find any resource condition with identifier '" + String.valueOf(identifier) + "'!");
                }
                conditions[i] = Registries.RESOURCE_CONDITION_SERIALIZERS.getValue(identifier).deserialize(conditionJson);
            }
            return new AndResourceCondition(conditions);
        }
    }
}

