/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.tathan.SkyAesthetics;
import fr.tathan.sky_aesthetics.client.data.ConstellationsData;
import fr.tathan.sky_aesthetics.client.skies.record.Constellation;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5365;
import net.minecraft.class_5819;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class StarHelper {
    public static class_291 createStars(float scale, int amountFancy, int r, int g, int b, Optional<List<String>> constellations, Optional<class_2960> starTexture) {
        class_5365 graphicsMode;
        class_289 tesselator = class_289.method_1348();
        RenderSystem.setShader(class_757::method_34543);
        class_291 vertexBuffer = new class_291(class_291.class_8555.field_44793);
        Random random = new Random();
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        if (starTexture.isPresent()) {
            bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        }
        int stars = amountFancy / (BooleanUtils.toInteger(((graphicsMode = (class_5365)class_310.method_1551().field_1690.method_42534().method_41753()) == class_5365.field_25428 || graphicsMode == class_5365.field_25429 ? 1 : 0) != 0) + 1);
        starTexture.ifPresent(resourceLocation -> RenderSystem.setShaderTexture((int)0, (class_2960)resourceLocation));
        for (int i = 0; i < stars; ++i) {
            float d0 = random.nextFloat() * 2.0f - 1.0f;
            float d1 = random.nextFloat() * 2.0f - 1.0f;
            float d2 = random.nextFloat() * 2.0f - 1.0f;
            float d3 = scale + random.nextFloat() * 0.1f;
            float d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0f) || !(d4 > 0.01f)) continue;
            d4 = (float)(1.0 / Math.sqrt(d4));
            float d5 = (d0 *= d4) * 100.0f;
            float d6 = (d1 *= d4) * 100.0f;
            float d7 = (d2 *= d4) * 100.0f;
            float d8 = (float)Math.atan2(d0, d2);
            float d9 = (float)Math.sin(d8);
            float d10 = (float)Math.cos(d8);
            float d11 = (float)Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            float d12 = (float)Math.sin(d11);
            float d13 = (float)Math.cos(d11);
            float d14 = (float)(random.nextDouble() * (Math.PI * 2));
            float d15 = (float)Math.sin(d14);
            float d16 = (float)Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                int color3;
                float d18 = (float)((j & 2) - 1) * d3;
                float d19 = (float)((j + 1 & 2) - 1) * d3;
                float d21 = d18 * d16 - d19 * d15;
                float d22 = d19 * d16 + d18 * d15;
                float d23 = d21 * d12 + 0.0f * d13;
                float d24 = 0.0f * d12 - d21 * d13;
                float d25 = d24 * d9 - d22 * d10;
                float d26 = d22 * d9 + d24 * d10;
                int color1 = r == -1 ? i : r;
                int color2 = g == -1 ? i : g;
                int n = color3 = b == -1 ? i : b;
                if (starTexture.isPresent()) {
                    float u = (float)(j % 2) * 1.0f;
                    float v = (float)j / 2.0f;
                    bufferBuilder.method_22912(d5 + d25, d6 + d23, d7 + d26).method_22913(u, v).method_1336(color1, color2, color3, 170);
                    continue;
                }
                bufferBuilder.method_22912(d5 + d25, d6 + d23, d7 + d26).method_1336(color1, color2, color3, 170);
            }
        }
        if (constellations.isPresent()) {
            for (String constellationId : constellations.get()) {
                Constellation constellation = ConstellationsData.CONSTELLATIONS.get(constellationId);
                if (constellation != null) {
                    class_243 color = constellation.color();
                    float x = (float)constellation.firstPoint().field_1352;
                    float y = (float)constellation.firstPoint().field_1351;
                    float z = (float)constellation.firstPoint().field_1350;
                    StarHelper.createStar(constellation.firstPoint(), color, (int)constellation.scale(), random, bufferBuilder, constellation.starTexture().orElse(null));
                    for (class_243 point : constellation.points()) {
                        class_243 pointPos = new class_243((double)x + point.field_1352, (double)y + point.field_1351, (double)z + point.field_1350);
                        StarHelper.createStar(pointPos, color, constellation.scale(), random, bufferBuilder, constellation.starTexture().orElse(null));
                    }
                    continue;
                }
                SkyAesthetics.LOG.error("{} is null", (Object)constellationId);
            }
        }
        vertexBuffer.method_1353();
        vertexBuffer.method_1352(bufferBuilder.method_60800());
        class_291.method_1354();
        return vertexBuffer;
    }

    public static void createStar(class_243 pos, class_243 color, float scale, Random random, class_287 bufferBuilder, @Nullable class_2960 starTexture) {
        float d0 = (float)pos.field_1352;
        float d1 = (float)pos.field_1351;
        float d2 = (float)pos.field_1350;
        float d3 = class_3532.method_15363((float)(scale + random.nextFloat()), (float)scale, (float)(scale + 0.2f));
        float d4 = d0 * d0 + d1 * d1 + d2 * d2;
        d4 = (float)(1.0 / Math.sqrt(d4));
        float d5 = (d0 *= d4) * 100.0f;
        float d6 = (d1 *= d4) * 100.0f;
        float d7 = (d2 *= d4) * 100.0f;
        float d8 = (float)Math.atan2(d0, d2);
        float d9 = (float)Math.sin(d8);
        float d10 = (float)Math.cos(d8);
        float d11 = (float)Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
        float d12 = (float)Math.sin(d11);
        float d13 = (float)Math.cos(d11);
        float d14 = (float)(random.nextDouble() * Math.PI);
        float d15 = (float)Math.sin(d14);
        float d16 = (float)Math.cos(d14);
        for (int j = 0; j < 4; ++j) {
            float d18 = (float)((j & 2) - 1) * d3;
            float d19 = (float)((j + 1 & 2) - 1) * d3;
            float d21 = d18 * d16 - d19 * d15;
            float d22 = d19 * d16 + d18 * d15;
            float d23 = d21 * d12 + 0.0f * d13;
            float d24 = 0.0f * d12 - d21 * d13;
            float d25 = d24 * d9 - d22 * d10;
            float d26 = d22 * d9 + d24 * d10;
            if (starTexture != null) {
                float u = (float)(j % 2) * 1.0f;
                float v = (float)j / 2.0f;
                bufferBuilder.method_22912(d5 + d25, d6 + d23, d7 + d26).method_22913(u, v).method_1336((int)color.method_10216(), (int)color.method_10214(), (int)color.method_10215(), 170);
                continue;
            }
            bufferBuilder.method_22912(d5 + d25, d6 + d23, d7 + d26).method_1336((int)color.method_10216(), (int)color.method_10214(), (int)color.method_10215(), 170);
        }
    }

    public static void drawStars(class_291 vertexBuffer, class_4587 poseStack, Matrix4f projectionMatrix, float nightTime, Optional<class_2960> starTexture) {
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(nightTime));
        class_758.method_23792();
        starTexture.ifPresent(resourceLocation -> RenderSystem.setShaderTexture((int)0, (class_2960)resourceLocation));
        float cycleSpeed = 0.5f;
        float alpha = (class_3532.method_15362((float)((float)((double)((float)System.currentTimeMillis() * cycleSpeed) / 1000.0))) + 1.0f) / 2.0f;
        alpha = class_3532.method_16439((float)0.3f, (float)0.7f, (float)alpha);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        vertexBuffer.method_1353();
        if (starTexture.isPresent()) {
            vertexBuffer.method_34427(poseStack.method_23760().method_23761(), projectionMatrix, class_757.method_34543());
        } else {
            vertexBuffer.method_34427(poseStack.method_23760().method_23761(), projectionMatrix, class_757.method_34540());
        }
        class_291.method_1354();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22909();
    }

    public static class_291 createVanillaStars() {
        class_291 starBuffer = new class_291(class_291.class_8555.field_44793);
        starBuffer.method_1353();
        starBuffer.method_1352(StarHelper.createVanillaStars(class_289.method_1348()));
        class_291.method_1354();
        return starBuffer;
    }

    public static class_9801 createVanillaStars(class_289 tesselator) {
        class_5819 randomSource = class_5819.method_43049((long)10842L);
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        for (int j = 0; j < 1500; ++j) {
            float g = randomSource.method_43057() * 2.0f - 1.0f;
            float h = randomSource.method_43057() * 2.0f - 1.0f;
            float k = randomSource.method_43057() * 2.0f - 1.0f;
            float l = 0.15f + randomSource.method_43057() * 0.1f;
            float m = class_3532.method_60677((float)g, (float)h, (float)k);
            if (m <= 0.010000001f || m >= 1.0f) continue;
            Vector3f vector3f = new Vector3f(g, h, k).normalize(100.0f);
            float n = (float)(randomSource.method_43058() * 3.1415927410125732 * 2.0);
            Quaternionf quaternionf = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)vector3f).rotateZ(n);
            bufferBuilder.method_60830(vector3f.add((Vector3fc)new Vector3f(l, -l, 0.0f).rotate((Quaternionfc)quaternionf))).method_39415(255);
            bufferBuilder.method_60830(vector3f.add((Vector3fc)new Vector3f(l, l, 0.0f).rotate((Quaternionfc)quaternionf))).method_39415(255);
            bufferBuilder.method_60830(vector3f.add((Vector3fc)new Vector3f(-l, l, 0.0f).rotate((Quaternionfc)quaternionf))).method_39415(255);
            bufferBuilder.method_60830(vector3f.add((Vector3fc)new Vector3f(-l, -l, 0.0f).rotate((Quaternionfc)quaternionf))).method_39415(255);
        }
        return bufferBuilder.method_60800();
    }
}

