/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.tathan.SkyAesthetics;
import fr.tathan.sky_aesthetics.client.skies.record.CloudSettings;
import fr.tathan.sky_aesthetics.client.skies.record.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.record.SkyObject;
import fr.tathan.sky_aesthetics.client.skies.record.SkyProperties;
import fr.tathan.sky_aesthetics.client.skies.record.Star;
import fr.tathan.sky_aesthetics.client.skies.utils.ShootingStar;
import fr.tathan.sky_aesthetics.client.skies.utils.SkyHelper;
import fr.tathan.sky_aesthetics.client.skies.utils.StarHelper;
import fr.tathan.sky_aesthetics.helper.PlatformHelper;
import fr.tathan.sky_aesthetics.helper.SkyCompat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1132;
import net.minecraft.class_243;
import net.minecraft.class_289;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_758;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class SkyRenderer {
    private final SkyProperties properties;
    private class_291 starBuffer = null;
    private final Map<UUID, ShootingStar> shootingStars;

    public SkyRenderer(SkyProperties properties) {
        this.properties = properties;
        if (properties.stars().count() > 100) {
            this.starBuffer = StarHelper.createStars(properties.stars().scale(), properties.stars().count(), (int)properties.stars().color().method_10216(), (int)properties.stars().color().method_10214(), (int)properties.stars().color().method_10215(), properties.constellations(), properties.stars().starsTexture());
        } else if (properties.stars().vanilla()) {
            this.starBuffer = StarHelper.createVanillaStars();
        }
        this.shootingStars = new HashMap<UUID, ShootingStar>();
    }

    public void render(class_638 level, class_4587 poseStack, Matrix4f projectionMatrix, float partialTick, class_4184 camera, Runnable fogCallback) {
        if (!this.isSkyRendered()) {
            return;
        }
        this.runFogCallback(fogCallback);
        class_289 tesselator = class_289.method_1348();
        CustomVanillaObject customVanillaObject = null;
        if (this.properties.customVanillaObject().isPresent()) {
            customVanillaObject = this.properties.customVanillaObject().get();
        }
        float dayAngle = level.method_30274(partialTick) * 360.0f % 360.0f;
        float nightAngle = dayAngle + 180.0f;
        class_243 vec3 = level.method_23777(camera.method_19326(), partialTick);
        Vector4f vec4 = new Vector4f((float)vec3.field_1352, (float)vec3.field_1351, (float)vec3.field_1350, 1.0f);
        if (this.properties.skyColor().customColor() && this.properties.skyColor().color().isPresent()) {
            vec4 = this.properties.skyColor().color().get();
        }
        class_758.method_3212();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)vec4.x, (float)vec4.y, (float)vec4.z, (float)vec4.w);
        class_5944 shaderInstance = RenderSystem.getShader();
        if (Objects.equals(this.properties.skyType(), "NORMAL")) {
            SkyHelper.drawSky(poseStack.method_23760().method_23761(), projectionMatrix, shaderInstance);
        } else if (Objects.equals(this.properties.skyType(), "END")) {
            SkyHelper.renderEndSky(poseStack);
        }
        this.renderStars(level, partialTick, poseStack, projectionMatrix, fogCallback, nightAngle);
        this.properties.stars().shootingStars().ifPresent(shootingStar -> this.handleShootingStars(level, poseStack, projectionMatrix, this.properties.stars(), partialTick));
        if (customVanillaObject != null) {
            if (customVanillaObject.sun() && customVanillaObject.sunTexture().isPresent() && customVanillaObject.sunHeight().isPresent() && customVanillaObject.sunSize().isPresent()) {
                SkyHelper.drawCelestialBody(customVanillaObject.sunTexture().get(), tesselator, poseStack, customVanillaObject.sunHeight().get().floatValue(), customVanillaObject.sunSize().get().floatValue(), dayAngle, true);
            }
            if (customVanillaObject.moon()) {
                if (PlatformHelper.isModLoaded("lunar")) {
                    SkyCompat.drawLunarSky(level, tesselator, poseStack, customVanillaObject.moonSize().get().floatValue(), nightAngle);
                } else if (customVanillaObject.moonPhase()) {
                    SkyHelper.drawMoonWithPhase(tesselator, poseStack, customVanillaObject.moonSize().get().floatValue(), customVanillaObject, nightAngle);
                } else {
                    SkyHelper.drawCelestialBody(customVanillaObject.moonTexture().get(), tesselator, poseStack, customVanillaObject.moonHeight().get().floatValue(), customVanillaObject.moonSize().get().floatValue(), nightAngle, 0.0f, 1.0f, 0.0f, 1.0f, false);
                }
            }
        }
        for (SkyObject skyObject : this.properties.skyObjects()) {
            SkyHelper.drawCelestialBody(skyObject, tesselator, poseStack, dayAngle);
        }
        this.runFogCallback(fogCallback);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    private void handleShootingStars(class_638 level, class_4587 poseStack, Matrix4f projectionMatrix, Star star, float partialTick) {
        if (!level.field_9236) {
            return;
        }
        float starLight = level.method_23787(partialTick) * (1.0f - level.method_8430(partialTick));
        if (!star.allDaysVisible() && !(starLight > 0.2f)) {
            if (!this.shootingStars.isEmpty()) {
                this.shootingStars.clear();
            }
            return;
        }
        Star.ShootingStars shootingStarConfig = star.shootingStars().get();
        Random random = new Random();
        if (random.nextInt(1001) >= shootingStarConfig.percentage()) {
            UUID starId = UUID.randomUUID();
            ShootingStar shootingStar = new ShootingStar(random.nextInt((int)shootingStarConfig.randomLifetime().field_1343, (int)shootingStarConfig.randomLifetime().field_1342), shootingStarConfig, starId);
            this.shootingStars.putIfAbsent(starId, shootingStar);
        }
        if (this.shootingStars == null || this.shootingStars.isEmpty()) {
            return;
        }
        ArrayList<UUID> starsToRemove = new ArrayList<UUID>();
        for (ShootingStar shootingStar : this.shootingStars.values()) {
            if (!shootingStar.render(poseStack, projectionMatrix)) continue;
            starsToRemove.add(shootingStar.starId);
        }
        starsToRemove.forEach(this.shootingStars::remove);
    }

    private void renderStars(class_638 level, float partialTick, class_4587 poseStack, Matrix4f projectionMatrix, Runnable fogCallback, float nightAngle) {
        float starsAngle;
        float starLight = level.method_23787(partialTick) * (1.0f - level.method_8430(partialTick));
        if (this.starBuffer == null) {
            return;
        }
        if (this.properties.stars().vanilla()) {
            if (starLight > 0.0f) {
                RenderSystem.setShaderColor((float)starLight, (float)starLight, (float)starLight, (float)starLight);
                class_758.method_23792();
                this.starBuffer.method_1353();
                this.starBuffer.method_34427(poseStack.method_23760().method_23761(), projectionMatrix, class_757.method_34539());
                class_291.method_1354();
            }
            return;
        }
        float f = starsAngle = !this.properties.stars().movingStars() ? -90.0f : nightAngle;
        if (this.properties.stars().allDaysVisible()) {
            if (this.properties.stars().starsTexture().isPresent()) {
                RenderSystem.setShader(class_757::method_34543);
            } else {
                RenderSystem.setShader(class_757::method_34540);
            }
            RenderSystem.setShaderColor((float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f));
            StarHelper.drawStars(this.starBuffer, poseStack, projectionMatrix, starsAngle, this.properties.stars().starsTexture());
        } else if (starLight > 0.2f) {
            if (this.properties.stars().starsTexture().isPresent()) {
                RenderSystem.setShader(class_757::method_34543);
            } else {
                RenderSystem.setShader(class_757::method_34540);
            }
            RenderSystem.setShaderColor((float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f));
            StarHelper.drawStars(this.starBuffer, poseStack, projectionMatrix, starsAngle, this.properties.stars().starsTexture());
        }
        this.runFogCallback(fogCallback);
    }

    public void runFogCallback(Runnable fogCallback) {
        if (this.properties.fogSettings().isEmpty()) {
            fogCallback.run();
            return;
        }
        this.properties.fogSettings().ifPresent(fogSettings -> {
            if (fogSettings.fog().booleanValue()) {
                fogCallback.run();
            }
        });
    }

    public Boolean shouldRemoveCloud() {
        return SkyHelper.isAModCancelRendering(SkyAesthetics.CONFIG.modDisablingCloudRender) || this.properties.cloudSettings().isPresent() && !this.properties.cloudSettings().get().showCloud();
    }

    public Boolean shouldRemoveSnowAndRain() {
        return SkyHelper.isAModCancelRendering(SkyAesthetics.CONFIG.modDisablingWeather) || this.properties.rain() == false;
    }

    public boolean isSkyRendered() {
        if (this.properties.renderCondition().isEmpty() || !this.properties.renderCondition().get().condition()) {
            return true;
        }
        SkyProperties.RenderCondition condition = this.properties.renderCondition().get();
        class_3218 level = this.getServerLevel();
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || level == null) {
            return false;
        }
        if (condition.biomes().isPresent()) {
            return level.method_23753(player.method_23312()).method_40220(condition.biomes().get());
        }
        if (condition.biome().isPresent()) {
            return level.method_23753(player.method_23312()).method_40225(condition.biome().get());
        }
        return true;
    }

    public class_243 getCloudColor(float rainLevel, float stormLevel) {
        if (this.properties.cloudSettings().isPresent() && this.properties.cloudSettings().get().cloudColor().isPresent()) {
            CloudSettings.CustomCloudColor color = this.properties.cloudSettings().get().cloudColor().get();
            if (stormLevel > 0.0f && !color.alwaysBaseColor()) {
                return new class_243(color.stormColor().field_1352, color.stormColor().field_1351, color.stormColor().field_1350);
            }
            if (rainLevel > 0.0f && !color.alwaysBaseColor()) {
                return new class_243(color.rainColor().field_1352, color.rainColor().field_1351, color.rainColor().field_1350);
            }
            return new class_243(color.baseColor().field_1352, color.baseColor().field_1351, color.baseColor().field_1350);
        }
        return null;
    }

    private class_3218 getServerLevel() {
        class_310 minecraft = class_310.method_1551();
        class_1132 integratedServer = minecraft.method_1576();
        return integratedServer != null ? integratedServer.method_3847(minecraft.field_1687.method_27983()) : null;
    }
}

