/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client;

import com.mrcrayfish.furniture.refurbished.client.gui.screen.ComputerScreen;
import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.Display;
import com.mrcrayfish.furniture.refurbished.computer.client.Icon;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ProgramShortcutButton;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerOpenProgram;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_638;

public class Desktop {
    private static final int SHORTCUT_AREA_WIDTH = 220;
    private static final int SHORTCUT_COLUMNS = 7;
    private final ComputerScreen screen;
    private final List<ProgramShortcutButton> shortcuts;
    private int displayStart;
    private int displayTop;
    private int displayWidth;
    private int displayHeight;

    public Desktop(ComputerScreen screen) {
        this.screen = screen;
        this.shortcuts = this.createProgramShortcuts();
    }

    private List<ProgramShortcutButton> createProgramShortcuts() {
        int index = 0;
        ArrayList<ProgramShortcutButton> shortcuts = new ArrayList<ProgramShortcutButton>();
        for (class_2960 id : Computer.get().getPrograms()) {
            Icon icon = Display.get().getIcon(id);
            if (icon == null) continue;
            shortcuts.add(new ProgramShortcutButton(this.screen, index++, 42, 32, this.getProgramName(id), icon, btn -> {
                Network.getPlay().sendToServer((Object)new MessageComputerOpenProgram(id));
                btn.method_25365(false);
            }));
        }
        return shortcuts;
    }

    public void update(int displayStart, int displayTop, int displayWidth, int displayHeight) {
        this.displayStart = displayStart;
        this.displayTop = displayTop;
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        int startX = displayStart + (displayWidth - 220) / 2;
        int startY = displayTop + 4;
        this.shortcuts.forEach(shortcut -> {
            int shortcutX = startX + shortcut.getIndex() % 7 * 42 + shortcut.getIndex() % 7 * 4;
            int shortcutY = startY + shortcut.getIndex() / 7 * 32 + shortcut.getIndex() / 7 * 4;
            shortcut.method_48229(shortcutX, shortcutY);
        });
    }

    public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(this.displayStart, this.displayTop, this.displayStart + this.displayWidth, this.displayTop + this.displayHeight, -14277082);
        this.shortcuts.forEach(shortcut -> shortcut.method_25394(graphics, mouseX, mouseY, partialTick));
        graphics.method_25294(this.displayStart, this.displayTop + this.displayHeight - 16, this.displayStart + this.displayWidth, this.displayTop + this.displayHeight, -10857649);
        graphics.method_25294(this.displayStart, this.displayTop + this.displayHeight - 16 + 2, this.displayStart + this.displayWidth, this.displayTop + this.displayHeight, -13423059);
        class_327 font = class_310.method_1551().field_1772;
        String timeLabel = this.getDayTimeLabel();
        int width = font.method_1727(timeLabel);
        graphics.method_51433(font, timeLabel, this.displayStart + this.displayWidth - width - 5, this.displayTop + this.displayHeight - 11, -1, false);
        graphics.method_25293(ComputerScreen.TEXTURE, this.displayStart, this.displayTop + this.displayHeight - 24, 32, 36, 0.0f, 150.0f, 16, 18, 256, 256);
    }

    private class_2561 getProgramName(class_2960 id) {
        return class_2561.method_43471((String)String.format("computer_program.%s.%s", id.method_12836(), id.method_12832()));
    }

    public List<ProgramShortcutButton> getShortcuts() {
        return this.shortcuts;
    }

    private String getDayTimeLabel() {
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            long time = (level.method_8532() + 6000L) % 24000L;
            long hours = time / 1000L;
            long minutes = 60L * (time % 1000L) / 1000L;
            return "%d:%02d".formatted(hours, minutes);
        }
        return "";
    }
}

