/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.overlay;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.gui.overlay.IHudOverlay;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.ContainerInput;
import com.mrcrayfish.furniture.refurbished.crafting.CuttingBoardCombiningRecipe;
import com.mrcrayfish.furniture.refurbished.crafting.CuttingBoardSlicingRecipe;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_5348;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.class_9779;

public class CuttingBoardHelperOverlay
implements IHudOverlay {
    private static final int COLUMNS = 7;
    private static final int TITLE_HEIGHT = 13;

    @Override
    public void draw(class_332 graphics, class_9779 deltaTracker) {
        if (!((Boolean)Config.CLIENT.showCuttingBoardHelper.get()).booleanValue()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1765 == null || mc.field_1724 == null) {
            return;
        }
        class_239 class_2393 = mc.field_1765;
        if (!(class_2393 instanceof class_3965)) {
            return;
        }
        class_3965 result = (class_3965)class_2393;
        class_2586 entity = mc.field_1687.method_8321(result.method_17777());
        if (!(entity instanceof CuttingBoardBlockEntity)) {
            return;
        }
        CuttingBoardBlockEntity cuttingBoard = (CuttingBoardBlockEntity)entity;
        int placeIndex = cuttingBoard.getPlaceIndex();
        class_1277 container = new class_1277(placeIndex);
        IntStream.range(0, placeIndex).forEach(arg_0 -> CuttingBoardHelperOverlay.lambda$draw$0((class_1263)container, cuttingBoard, arg_0));
        List recipes = mc.field_1687.method_8433().method_30027((class_3956)ModRecipeTypes.CUTTING_BOARD_COMBINING.get());
        Stream<class_1792> combinable = recipes.stream().filter(arg_0 -> CuttingBoardHelperOverlay.lambda$draw$1((class_1263)container, mc, placeIndex, arg_0)).flatMap(holder -> Stream.of(((class_1856)((CuttingBoardCombiningRecipe)holder.comp_1933()).method_8117().get(placeIndex)).method_8105())).map(class_1799::method_7909);
        Stream<class_1792> sliceable = mc.field_1687.method_8433().method_30027((class_3956)ModRecipeTypes.CUTTING_BOARD_SLICING.get()).stream().flatMap(holder -> Stream.of(((class_1856)((CuttingBoardSlicingRecipe)holder.comp_1933()).method_8117().get(0)).method_8105())).map(class_1799::method_7909);
        Stream<class_1792> items = placeIndex == 0 ? Stream.concat(combinable, sliceable) : combinable;
        List<class_1792> placeable = items.distinct().sorted(Comparator.comparing(class_1792::method_7880)).toList();
        boolean drawPlaceableElement = !placeable.isEmpty();
        boolean drawSliceableElement = this.canSlice(cuttingBoard);
        int areaWidth = 134;
        int areaHeight = this.getAreaHeight(placeable, drawPlaceableElement, drawSliceableElement);
        int areaStart = 5;
        int areaTop = (graphics.method_51443() - areaHeight) / 2;
        if (drawPlaceableElement) {
            int elementHeight = this.getPlaceableHeight(placeable);
            ScreenHelper.fillRounded(graphics, areaStart, areaTop, areaWidth, elementHeight, -1728053248);
            ScreenHelper.fillRounded(graphics, areaStart, areaTop, areaWidth, 13, -1728053248);
            graphics.method_27534(class_310.method_1551().field_1772, Components.GUI_PLACEABLE, areaStart + areaWidth / 2, areaTop + 2, -1);
            for (int i = 0; i < placeable.size(); ++i) {
                int x = areaStart + i % 7 * 18 + 1 + 4;
                int y = areaTop + i / 7 * 18 + 1 + 4 + 13;
                graphics.method_51445(new class_1799((class_1935)placeable.get(i)), x, y);
            }
        }
        if (drawSliceableElement) {
            class_2561 sliceableLabel = Components.GUI_SLICEABLE;
            int elementHeight = 18;
            int contentWidth = 18 + class_310.method_1551().field_1772.method_27525((class_5348)sliceableLabel);
            int contentTop = areaTop + areaHeight - elementHeight;
            int labelStart = areaStart + (areaWidth - contentWidth) / 2;
            ScreenHelper.fillRounded(graphics, areaStart, contentTop, areaWidth, elementHeight, -1724404169);
            graphics.method_51445(new class_1799((class_1935)ModItems.KNIFE.get()), labelStart, contentTop + 1);
            graphics.method_27535(class_310.method_1551().field_1772, sliceableLabel, labelStart + 18, contentTop + 5, -1);
        }
    }

    private int getAreaHeight(List<class_1792> placeable, boolean combining, boolean slicing) {
        int height = 0;
        if (combining) {
            height += this.getPlaceableHeight(placeable);
        }
        if (slicing) {
            height += 18;
        }
        if (combining && slicing) {
            height += 5;
        }
        return height;
    }

    private int getPlaceableHeight(List<class_1792> placeable) {
        return (placeable.size() / 7 + 1) * 18 + 1 + 8 + 13;
    }

    private boolean canSlice(CuttingBoardBlockEntity entity) {
        class_1799 placedItem = entity.method_5438(0);
        if (entity.getHeadIndex() == 0 && !placedItem.method_7960()) {
            class_1937 level = Objects.requireNonNull(entity.method_10997());
            return level.method_8433().method_8132((class_3956)ModRecipeTypes.CUTTING_BOARD_SLICING.get(), (class_9695)new class_9696(placedItem), level).isPresent();
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$draw$1(class_1263 container, class_310 mc, int placeIndex, class_8786 holder) {
        return ((CuttingBoardCombiningRecipe)holder.comp_1933()).matches(new ContainerInput(container), (class_1937)mc.field_1687) && placeIndex < ((CuttingBoardCombiningRecipe)holder.comp_1933()).method_8117().size();
    }

    private static /* synthetic */ void lambda$draw$0(class_1263 container, CuttingBoardBlockEntity cuttingBoard, int index) {
        container.method_5447(index, cuttingBoard.method_5438(index));
    }
}

