/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.DefaultActionResponse;
import com.cobblemon.mod.common.battles.ForcePassActionResponse;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.SwitchActionResponse;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.gitlab.srcmc.rctapi.ModCommon;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.ai.utils.Debug;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ResponseBuilder {
    private Supplier<Stream<BattlePokemon>> switchCandidates = Stream::empty;
    private Supplier<Stream<Pair<BagItem, BattlePokemon>>> itemCandidates = Stream::empty;
    private Supplier<Stream<Pair<InBattleMove, Targetable>>> moveCandidates = Stream::empty;
    private List<Choice<ShowdownActionResponse>> choices = new ArrayList<Choice<ShowdownActionResponse>>();
    private Random rng = new Random(0L);
    private ActiveBattlePokemon pkmn;
    private ShowdownMoveset moveset;
    private boolean forceSwitch;
    private boolean forceMove;
    private boolean mustChoose;
    private double margin;
    private static final int MAX_CHOICE_RNG = 16;

    public static ResponseBuilder create(ActiveBattlePokemon pkmn, ShowdownMoveset moveset, boolean forceSwitch) {
        BattleStates.ActorState actorSt = BattleStates.get(pkmn.getBattle()).getActorState(pkmn.getActor());
        ResponseBuilder builder = new ResponseBuilder();
        builder.mustChoose = pkmn.getActor().getMustChoose();
        builder.forceSwitch = forceSwitch;
        builder.forceMove = false;
        builder.moveset = moveset;
        builder.pkmn = pkmn;
        if (!actorSt.hasResponse(pkmn)) {
            if (!builder.forceSwitch && builder.mustChoose && pkmn.hasPokemon()) {
                BattleActor battleActor;
                if (builder.moveset != null && builder.moveset.moves.stream().findFirst().isPresent()) {
                    Stream<InBattleMove> stream;
                    if (builder.moveset.moves.stream().anyMatch(InBattleMove::mustBeUsed)) {
                        stream = builder.moveset.moves.stream().filter(InBattleMove::mustBeUsed);
                        builder.forceMove = true;
                    } else {
                        stream = builder.moveset.moves.stream().filter(InBattleMove::canBeUsed);
                    }
                    builder.moveCandidates = () -> stream.flatMap(mv -> mv.getTargets(pkmn) == null || mv.getTargets(pkmn).isEmpty() ? Stream.of(new Pair<InBattleMove, Targetable>((InBattleMove)mv, null)) : mv.getTargets(pkmn).stream().map(t -> new Pair<InBattleMove, Targetable>((InBattleMove)mv, (Targetable)t)));
                }
                if (!builder.forceMove && pkmn.getActor().canFitForcedAction() && (battleActor = pkmn.getActor()) instanceof BattleManager.TrainerEntityBattleActor) {
                    BattleManager.TrainerEntityBattleActor actor = (BattleManager.TrainerEntityBattleActor)battleActor;
                    builder.itemCandidates = () -> actor.getBag().getItems().stream().flatMap(bi -> pkmn.getActor().getPokemonList().stream().filter(p -> bi.canUse(pkmn.getBattle(), p)).map(p -> new Pair<BagItem, BattlePokemon>((BagItem)bi, (BattlePokemon)p)));
                }
            }
            if (!pkmn.hasPokemon() || !builder.forceMove) {
                builder.switchCandidates = () -> pkmn.getActor().getPokemonList().stream().filter(BattlePokemon::canBeSentOut);
            }
            actorSt.addResponse(pkmn);
        } else if (pkmn.isAlive() && builder.mustChoose && builder.forceSwitch) {
            builder.switchCandidates = () -> pkmn.getActor().getPokemonList().stream().filter(BattlePokemon::canBeSentOut);
            actorSt.addResponse(pkmn);
        }
        return builder;
    }

    public ResponseBuilder suggestSwitches(Function<Stream<BattlePokemon>, Stream<Choice<BattlePokemon>>> consumer) {
        consumer.apply(this.switchCandidates.get()).forEach(choice -> this.choices.add(new Choice<SwitchActionResponse>(choice.name, new SwitchActionResponse(((BattlePokemon)choice.value).getUuid()), choice.weight, () -> {
            ((BattlePokemon)choice.value).setWillBeSwitchedIn(true);
            if (this.pkmn.hasPokemon()) {
                this.pkmn.getBattlePokemon().setWillBeSwitchedIn(false);
            }
        })));
        return this;
    }

    public ResponseBuilder suggestItems(Function<Stream<Pair<BagItem, BattlePokemon>>, Stream<Choice<Pair<BagItem, BattlePokemon>>>> consumer) {
        BattleActor battleActor = this.pkmn.getActor();
        if (battleActor instanceof BattleManager.TrainerEntityBattleActor) {
            BattleManager.TrainerEntityBattleActor actor = (BattleManager.TrainerEntityBattleActor)battleActor;
            consumer.apply(this.itemCandidates.get()).forEach(choice -> this.choices.add(new Choice<ForcePassActionResponse>(choice.name, new ForcePassActionResponse(), choice.weight, () -> {
                BagItem item = (BagItem)((Pair)choice.value).first;
                BattlePokemon pkmn = (BattlePokemon)((Pair)choice.value).second;
                this.pkmn.getActor().forceChoose((ShowdownActionResponse)new BagItemActionResponse(actor.getBag().use(item), pkmn, pkmn.getUuid().toString()));
            }, true)));
        }
        return this;
    }

    public ResponseBuilder suggestMoves(Function<Stream<Pair<InBattleMove, Targetable>>, Stream<Choice<Pair<InBattleMove, Targetable>>>> consumer) {
        ShowdownMoveset.Gimmick gimmick = this.moveset != null && this.moveset.getGimmicks().size() > 0 ? (ShowdownMoveset.Gimmick)this.moveset.getGimmicks().get(this.rng.nextInt(this.moveset.getGimmicks().size())) : null;
        Debug.log(1, () -> {
            ModCommon.LOG.info("[GIMMICKS of " + (this.pkmn.hasPokemon() ? this.pkmn.getBattlePokemon().getName().getString() : "<dead>") + "]");
            if (this.moveset != null) {
                this.moveset.getGimmicks().forEach(g -> ModCommon.LOG.info(" - " + g.getId() + ", " + g.name()));
            }
            if (gimmick != null) {
                ModCommon.LOG.info("ACTIVATED: " + gimmick.getId());
            }
        });
        consumer.apply(this.moveCandidates.get()).forEach(choice -> {
            InBattleMove move = (InBattleMove)((Pair)choice.value).first;
            Targetable target = (Targetable)((Pair)choice.value).second;
            String gimmickId = gimmick != null && (!ShowdownMoveset.Gimmick.Z_POWER.equals((Object)gimmick) || move.getGimmickMove() != null) ? gimmick.getId() : null;
            this.choices.add(new Choice<MoveActionResponse>(choice.name, new MoveActionResponse(move.id, target != null ? target.getPNX() : null, gimmickId), choice.weight, () -> {
                BattleStates.BattleState battleState = BattleStates.get(this.pkmn.getBattle());
                battleState.getActorState(this.pkmn.getActor()).addGimmick(gimmickId);
                if (this.pkmn.hasPokemon() && gimmickId != null) {
                    if (ShowdownMoveset.Gimmick.DYNAMAX.getId().equals(gimmickId)) {
                        battleState.getPokemonState(this.pkmn.getBattlePokemon()).add(BattleEffects.Custom.DYNAMAX);
                    } else if (ShowdownMoveset.Gimmick.MEGA_EVOLUTION.getId().equals(gimmickId)) {
                        battleState.getPokemonState(this.pkmn.getBattlePokemon()).add(BattleEffects.Custom.MEGA);
                    } else if (ShowdownMoveset.Gimmick.TERASTALLIZATION.getId().equals(gimmickId)) {
                        battleState.getPokemonState(this.pkmn.getBattlePokemon()).add(BattleEffects.Custom.TERA);
                    } else if (ShowdownMoveset.Gimmick.Z_POWER.getId().equals(gimmickId) || ShowdownMoveset.Gimmick.ULTRA_BURST.getId().equals(gimmickId)) {
                        battleState.getPokemonState(this.pkmn.getBattlePokemon()).add(BattleEffects.Custom.ZMOVE);
                    }
                }
            }));
        });
        return this;
    }

    public ShowdownActionResponse response(MessagePassingQueue.Consumer<ShowdownActionResponse> consumer) {
        List<Choice> choices = this.choices.stream().filter(c -> c.forced || ((ShowdownActionResponse)c.value).isValid(this.pkmn, this.moveset, this.forceMove)).toList();
        Debug.log(1, "[CHOICES OF %s]:%s", this.pkmn.isAlive() ? this.pkmn.getBattlePokemon().getName().getString() : "<dead>", ", forceMove: " + this.forceMove + ", forceSwitch: " + this.forceSwitch + ", mustChoose: " + this.mustChoose);
        Debug.log(1, () -> choices.stream().sorted().forEach(ch -> ModCommon.LOG.info(String.format(" - %s: %.4f", ch.name, ch.weight))));
        PassActionResponse response = choices.isEmpty() ? (this.forceMove && this.mustChoose && this.pkmn.hasPokemon() ? new DefaultActionResponse() : PassActionResponse.INSTANCE) : (ShowdownActionResponse)ResponseBuilder.getRandom(ResponseBuilder.takeWithMargin(choices.stream().sorted(), (double)this.margin), (Random)this.rng, (double)this.margin).orElse(new Choice<DefaultActionResponse>((String)"DEFAULT", new DefaultActionResponse(), (double)0.0)).pick().value;
        consumer.accept((Object)response);
        return response;
    }

    public ShowdownActionResponse response() {
        return this.response((MessagePassingQueue.Consumer<ShowdownActionResponse>)((MessagePassingQueue.Consumer)r -> Debug.log(1, "RESPONSE: " + String.valueOf(r), new Object[0])));
    }

    public ResponseBuilder margin(double margin) {
        this.margin = margin;
        return this;
    }

    public ResponseBuilder random(Random rng) {
        this.rng = rng;
        return this;
    }

    private static <T> Stream<Choice<T>> takeWithMargin(Stream<Choice<T>> in, double margin) {
        double[] w = new double[]{Double.NEGATIVE_INFINITY};
        return in.takeWhile(choice -> {
            if (w[0] == Double.NEGATIVE_INFINITY) {
                w[0] = choice.weight;
            } else if (choice.weight - w[0] > margin) {
                return false;
            }
            return true;
        });
    }

    private static <T> Optional<Choice<T>> getRandom(Stream<Choice<T>> stream, Random rng, double margin) {
        Choice c;
        Iterator it = stream.iterator();
        if (it.hasNext()) {
            Choice next = (Choice)it.next();
            double start = next.weight;
            double w = 0.0;
            int i = 1;
            c = next;
            while (it.hasNext()) {
                next = (Choice)it.next();
                w = margin > 0.0 ? (next.weight - start) / margin : 1.0;
                if (rng.nextInt(++i + (int)(w * 16.0)) != 0) continue;
                c = next;
            }
        } else {
            c = null;
        }
        return Optional.ofNullable(c);
    }

    public static class Choice<T>
    implements Comparable<Choice<?>> {
        public final T value;
        public final double weight;
        public final String name;
        public final boolean forced;
        private final Action onpick;

        public Choice(String name, T value, double weight) {
            this(name, value, weight, () -> {}, false);
        }

        public Choice(String name, T value, double weight, boolean forced) {
            this(name, value, weight, () -> {}, forced);
        }

        public Choice(String name, T value, double weight, Action onpick) {
            this(name, value, weight, onpick, false);
        }

        public Choice(String name, T value, double weight, Action onpick, boolean forced) {
            this.value = value;
            this.weight = weight;
            this.name = name;
            this.onpick = onpick;
            this.forced = forced;
        }

        public Choice<T> pick() {
            this.onpick.perform();
            return this;
        }

        @Override
        public int compareTo(Choice<?> other) {
            return Double.compare(this.weight, other.weight);
        }

        public static interface Action {
            public void perform();
        }
    }

    public static class Pair<T, U> {
        public final T first;
        public final U second;

        public Pair(T first, U second) {
            this.first = first;
            this.second = second;
        }
    }
}

