/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.experimental;

import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.SwitchActionResponse;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfdotGen5AI
implements BattleAI {
    private static final Random RANDOM = new Random();
    private static final double SUPER_EFFECTIVE = 2.0;
    private static final double NOT_VERY_EFFECTIVE = 0.5;
    private static final double IMMUNE = 0.0;
    private static final Map<ElementalType, Map<ElementalType, Double>> typeChart = new HashMap<ElementalType, Map<ElementalType, Double>>();

    private static double typeEffectiveness(ElementalType attacker, ElementalType defender) {
        if (!typeChart.containsKey(defender)) {
            return 1.0;
        }
        if (typeChart.get(defender).containsKey(attacker)) {
            return typeChart.get(defender).get(attacker);
        }
        return 1.0;
    }

    private static double typeEffectiveness(ElementalType attacker, ElementalType defender, Ability defenderAbility) {
        String defenderAbilityId = defenderAbility.getDisplayName();
        if (attacker.equals(ElementalTypes.INSTANCE.getWATER()) ? defenderAbilityId.equals("cobblemon.ability.stormdrain") || defenderAbilityId.equals("cobblemon.ability.waterabsorb") || defenderAbilityId.equals("cobblemon.ability.dryskin") : (attacker.equals(ElementalTypes.INSTANCE.getELECTRIC()) ? defenderAbilityId.equals("cobblemon.ability.voltabsorb") || defenderAbilityId.equals("cobblemon.ability.lightningrod") || defenderAbilityId.equals("cobblemon.ability.motordrive") : (attacker.equals(ElementalTypes.INSTANCE.getGROUND()) ? defenderAbilityId.equals("cobblemon.ability.levitate") || defenderAbilityId.equals("cobblemon.ability.eartheater") : (attacker.equals(ElementalTypes.INSTANCE.getFIRE()) ? defenderAbilityId.equals("cobblemon.ability.wellbakedbody") || defenderAbilityId.equals("cobblemon.ability.flashfire") : attacker.equals(ElementalTypes.INSTANCE.getGRASS()) && defenderAbilityId.equals("cobblemon.ability.sapsipper"))))) {
            return 0.0;
        }
        double typeEffectiveness = SelfdotGen5AI.typeEffectiveness(attacker, defender);
        if (defenderAbilityId.equals("cobblemon.ability.wonderguard") && typeEffectiveness != 2.0) {
            return 0.0;
        }
        return typeEffectiveness;
    }

    private static double damage(int attackerLevel, int attackerEffectiveAttack, int defenderEffectiveDefence, double movePower, ElementalType moveType, ElementalType attackerPrimaryType, ElementalType attackerSecondaryType, ElementalType defenderPrimaryType, ElementalType defenderSecondaryType, Ability defenderAbility, boolean isAttackerBurned, boolean isPhysicalMove) {
        double baseDamage = 2.0 * (double)attackerLevel / 5.0 * movePower * ((double)attackerEffectiveAttack / (double)defenderEffectiveDefence) / 50.0 + 2.0;
        return SelfdotGen5AI.typeEffectiveness(moveType, defenderPrimaryType, defenderAbility) * (defenderSecondaryType == null ? 1.0 : SelfdotGen5AI.typeEffectiveness(moveType, defenderSecondaryType, defenderAbility)) * (moveType.equals(attackerPrimaryType) || moveType.equals(attackerSecondaryType) ? 1.5 : 1.0) * (isPhysicalMove && isAttackerBurned ? 0.5 : 1.0) * (RANDOM.nextDouble() * 0.15 + 0.85) * baseDamage;
    }

    private static double damage(BattlePokemon attacker, BattlePokemon defender, Move move) {
        String damageCategory = move.getDamageCategory().getName();
        if (damageCategory.equals(DamageCategories.INSTANCE.getSTATUS().getName())) {
            return 0.0;
        }
        boolean isPhysicalMove = damageCategory.equals(DamageCategories.INSTANCE.getPHYSICAL().getName());
        boolean isAttackerBurned = false;
        PersistentStatusContainer statusContainer = attacker.getEffectedPokemon().getStatus();
        if (statusContainer != null && !statusContainer.isExpired()) {
            isAttackerBurned = statusContainer.getStatus().equals(Statuses.INSTANCE.getBURN());
        }
        return SelfdotGen5AI.damage(attacker.getOriginalPokemon().getLevel(), attacker.getOriginalPokemon().getStat((Stat)(isPhysicalMove ? Stats.ATTACK : Stats.SPECIAL_ATTACK)), defender.getOriginalPokemon().getStat((Stat)(isPhysicalMove ? Stats.DEFENCE : Stats.SPECIAL_DEFENCE)), move.getPower(), move.getType(), attacker.getOriginalPokemon().getPrimaryType(), attacker.getOriginalPokemon().getSecondaryType(), defender.getOriginalPokemon().getPrimaryType(), defender.getOriginalPokemon().getSecondaryType(), defender.getOriginalPokemon().getAbility(), isAttackerBurned, isPhysicalMove);
    }

    private static double powerAndTypeDamage(double movePower, ElementalType moveType, ElementalType defenderPrimaryType, ElementalType defenderSecondaryType) {
        return movePower * SelfdotGen5AI.typeEffectiveness(moveType, defenderPrimaryType) * (defenderSecondaryType == null ? 1.0 : SelfdotGen5AI.typeEffectiveness(moveType, defenderSecondaryType));
    }

    @NotNull
    public ShowdownActionResponse choose(@NotNull ActiveBattlePokemon activeBattlePokemon, @Nullable ShowdownMoveset showdownMoveset, boolean mustSwitch) {
        Optional<ActiveBattlePokemon> opponentActiveBattlePokemon = StreamSupport.stream(activeBattlePokemon.getAllActivePokemon().spliterator(), false).filter(abp -> !abp.isAllied((Targetable)activeBattlePokemon)).findFirst();
        if (mustSwitch || activeBattlePokemon.isGone()) {
            List<BattlePokemon> canSwitchTo = activeBattlePokemon.getActor().getPokemonList().stream().filter(BattlePokemon::canBeSentOut).toList();
            if (canSwitchTo.isEmpty()) {
                return PassActionResponse.INSTANCE;
            }
            if (opponentActiveBattlePokemon.isEmpty() || opponentActiveBattlePokemon.get().getBattlePokemon() == null) {
                BattlePokemon nextPokemon = canSwitchTo.get(RANDOM.nextInt(canSwitchTo.size()));
                nextPokemon.setWillBeSwitchedIn(true);
                return new SwitchActionResponse(nextPokemon.getUuid());
            }
            BattlePokemon opponent = opponentActiveBattlePokemon.get().getBattlePokemon();
            BattlePokemon nextPokemon = canSwitchTo.stream().max(Comparator.comparingDouble(pokemon -> pokemon.getMoveSet().getMoves().stream().map(move -> SelfdotGen5AI.powerAndTypeDamage(move.getPower(), move.getType(), opponent.getOriginalPokemon().getPrimaryType(), opponent.getOriginalPokemon().getSecondaryType())).max(Double::compare).orElse(0.0))).get();
            nextPokemon.setWillBeSwitchedIn(true);
            return new SwitchActionResponse(nextPokemon.getUuid());
        }
        if (showdownMoveset == null) {
            return PassActionResponse.INSTANCE;
        }
        if (showdownMoveset.moves.size() == 1 && ((InBattleMove)showdownMoveset.moves.get(0)).getId().equals("recharge")) {
            return new MoveActionResponse("recharge", null, null);
        }
        List<InBattleMove> inBattleMoves = showdownMoveset.moves.stream().filter(InBattleMove::canBeUsed).filter(inBattleMove -> {
            List targetList = (List)inBattleMove.getTarget().getTargetList().invoke((Object)activeBattlePokemon);
            return inBattleMove.mustBeUsed() || targetList == null || !targetList.isEmpty();
        }).toList();
        if (inBattleMoves.isEmpty()) {
            return new MoveActionResponse("struggle", null, null);
        }
        if (opponentActiveBattlePokemon.isEmpty()) {
            return new MoveActionResponse(inBattleMoves.get((int)SelfdotGen5AI.RANDOM.nextInt((int)showdownMoveset.moves.size())).id, null, null);
        }
        BattlePokemon opponent = opponentActiveBattlePokemon.get().getBattlePokemon();
        if (opponent == null) {
            return new MoveActionResponse(inBattleMoves.get((int)SelfdotGen5AI.RANDOM.nextInt((int)showdownMoveset.moves.size())).id, null, null);
        }
        HashMap moveMap = new HashMap();
        IntStream.range(0, inBattleMoves.size()).forEach(i -> moveMap.put((InBattleMove)inBattleMoves.get(i), Moves.INSTANCE.all().stream().filter(move -> move.getName().equals(((InBattleMove)inBattleMoves.get(i)).getId())).findFirst().get().create()));
        HashMap<InBattleMove, Double> moveDamages = new HashMap<InBattleMove, Double>();
        inBattleMoves.forEach(inBattleMove -> {
            double dmg = SelfdotGen5AI.damage(activeBattlePokemon.getBattlePokemon(), opponent, (Move)moveMap.get(inBattleMove));
            moveDamages.put((InBattleMove)inBattleMove, dmg);
        });
        ArrayList killingMoves = new ArrayList();
        moveDamages.forEach((move, damage) -> {
            if (damage >= (double)opponent.getHealth()) {
                killingMoves.add(move);
            }
        });
        InBattleMove move2 = killingMoves.isEmpty() ? (InBattleMove)Collections.max(moveDamages.entrySet(), Map.Entry.comparingByValue()).getKey() : (InBattleMove)killingMoves.get(RANDOM.nextInt(killingMoves.size()));
        List targets = move2.mustBeUsed() ? null : (List)move2.getTarget().getTargetList().invoke((Object)activeBattlePokemon);
        return new MoveActionResponse(move2.id, targets == null ? null : opponentActiveBattlePokemon.get().getPNX(), null);
    }

    public static void initialiseTypeChart() {
        ElementalTypes types = ElementalTypes.INSTANCE;
        ElementalType NORMAL = types.getNORMAL();
        ElementalType FIGHTING = types.getFIGHTING();
        ElementalType FLYING = types.getFLYING();
        ElementalType POISON = types.getPOISON();
        ElementalType GROUND = types.getGROUND();
        ElementalType ROCK = types.getROCK();
        ElementalType BUG = types.getBUG();
        ElementalType GHOST = types.getGHOST();
        ElementalType STEEL = types.getSTEEL();
        ElementalType FIRE = types.getFIRE();
        ElementalType WATER = types.getWATER();
        ElementalType GRASS = types.getGRASS();
        ElementalType ELECTRIC = types.getELECTRIC();
        ElementalType PSYCHIC = types.getPSYCHIC();
        ElementalType ICE = types.getICE();
        ElementalType DRAGON = types.getDRAGON();
        ElementalType DARK = types.getDARK();
        ElementalType FAIRY = types.getFAIRY();
        typeChart.put(NORMAL, Map.of(FIGHTING, 2.0, GHOST, 0.0));
        typeChart.put(FIGHTING, Map.of(FLYING, 2.0, ROCK, 0.5, BUG, 0.5, PSYCHIC, 2.0, DARK, 0.5, FAIRY, 2.0));
        typeChart.put(FLYING, Map.of(FIGHTING, 0.5, GROUND, 0.0, ROCK, 2.0, BUG, 0.5, GRASS, 0.5, ELECTRIC, 2.0, ICE, 2.0));
        typeChart.put(POISON, Map.of(FIGHTING, 0.5, POISON, 0.5, GROUND, 2.0, BUG, 0.5, GRASS, 0.5, PSYCHIC, 2.0, FAIRY, 0.5));
        typeChart.put(GROUND, Map.of(POISON, 0.5, ROCK, 0.5, WATER, 2.0, GRASS, 2.0, ELECTRIC, 0.0, ICE, 2.0));
        typeChart.put(ROCK, Map.of(NORMAL, 0.5, FIGHTING, 2.0, FLYING, 0.5, POISON, 0.5, GROUND, 2.0, STEEL, 2.0, FIRE, 0.5, WATER, 2.0, GRASS, 2.0));
        typeChart.put(BUG, Map.of(FIGHTING, 0.5, FLYING, 2.0, GROUND, 0.5, ROCK, 2.0, FIRE, 2.0, GRASS, 0.5));
        typeChart.put(GHOST, Map.of(NORMAL, 0.0, FIGHTING, 0.0, POISON, 0.5, BUG, 0.5, GHOST, 2.0, DARK, 2.0));
        HashMap<ElementalType, Double> steelMap = new HashMap<ElementalType, Double>(Map.of(NORMAL, 0.5, FIGHTING, 2.0, FLYING, 0.5, POISON, 0.0, GROUND, 2.0, ROCK, 0.5, BUG, 0.5, STEEL, 0.5, FIRE, 2.0, GRASS, 0.5));
        steelMap.put(PSYCHIC, 0.5);
        steelMap.put(ICE, 0.5);
        steelMap.put(DRAGON, 0.5);
        steelMap.put(FAIRY, 0.5);
        typeChart.put(STEEL, steelMap);
        typeChart.put(FIRE, Map.of(GROUND, 2.0, ROCK, 2.0, BUG, 0.5, STEEL, 0.5, FIRE, 0.5, WATER, 2.0, GRASS, 0.5, ICE, 0.5, FAIRY, 0.5));
        typeChart.put(WATER, Map.of(STEEL, 0.5, FIRE, 0.5, WATER, 0.5, GRASS, 2.0, ELECTRIC, 2.0, ICE, 0.5));
        typeChart.put(GRASS, Map.of(FLYING, 2.0, POISON, 2.0, GROUND, 0.5, BUG, 2.0, FIRE, 2.0, WATER, 0.5, GRASS, 0.5, ELECTRIC, 0.5, ICE, 2.0));
        typeChart.put(ELECTRIC, Map.of(FLYING, 0.5, GROUND, 2.0, STEEL, 0.5, ELECTRIC, 0.5));
        typeChart.put(PSYCHIC, Map.of(FIGHTING, 0.5, BUG, 2.0, GHOST, 2.0, PSYCHIC, 0.5, DARK, 2.0));
        typeChart.put(ICE, Map.of(FIGHTING, 2.0, ROCK, 2.0, STEEL, 2.0, FIRE, 2.0, ICE, 0.5));
        typeChart.put(DRAGON, Map.of(FIRE, 0.5, WATER, 0.5, GRASS, 0.5, ELECTRIC, 0.5, ICE, 2.0, DRAGON, 2.0, FAIRY, 2.0));
        typeChart.put(DARK, Map.of(FIGHTING, 2.0, BUG, 2.0, GHOST, 0.5, PSYCHIC, 0.0, DARK, 0.5, FAIRY, 2.0));
        typeChart.put(FAIRY, Map.of(FIGHTING, 0.5, POISON, 2.0, BUG, 0.5, STEEL, 2.0, DRAGON, 0.0, DARK, 0.5));
    }
}

