/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai;

import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.interactive.PotionType;
import com.gitlab.srcmc.rctapi.ModCommon;
import com.gitlab.srcmc.rctapi.api.RCTApi;
import com.gitlab.srcmc.rctapi.api.ai.config.RCTBattleAIConfig;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.ai.utils.Debug;
import com.gitlab.srcmc.rctapi.api.ai.utils.MoveType;
import com.gitlab.srcmc.rctapi.api.ai.utils.PokeMath;
import com.gitlab.srcmc.rctapi.api.ai.utils.ResponseBuilder;
import com.gitlab.srcmc.rctapi.api.ai.utils.TypeChart;
import com.gitlab.srcmc.rctapi.api.models.Gimmicks;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class RCTBattleAI
implements BattleAI {
    private double moveBias;
    private double statusMoveBias;
    private double switchBias;
    private double itemBias;
    private double maxSelectMargin;
    private Random rng = new Random();

    public RCTBattleAI() {
        this(new RCTBattleAIConfig.Builder().build());
    }

    public RCTBattleAI(@NotNull RCTBattleAIConfig config) {
        this.moveBias = config.moveBias();
        this.statusMoveBias = config.statusMoveBias();
        this.switchBias = config.switchBias();
        this.itemBias = config.itemBias();
        this.maxSelectMargin = config.maxSelectMargin();
    }

    public ShowdownActionResponse choose(ActiveBattlePokemon pkmn, ShowdownMoveset moveset, boolean forceSwitch) {
        Object var5_4;
        Debug.log(2, () -> {
            if (pkmn.isAlive()) {
                BattleEffects.dump(pkmn.getBattlePokemon());
                pkmn.getActor().getSide().getOppositeSide().getActivePokemon().stream().filter(p -> p.isAlive()).map(p -> p.getBattlePokemon()).forEach(BattleEffects::dump);
            }
        });
        if (pkmn.hasPokemon() && moveset != null && (var5_4 = RCTApi.getInstances().map(rct -> ((RCTApi)rct.getValue()).getTrainerRegistry().getByOT(pkmn.getBattlePokemon().getEffectedPokemon())).filter(t -> t != null && t instanceof TrainerNPC).findFirst().orElse(null)) instanceof TrainerNPC) {
            TrainerNPC trainer = var5_4;
            BattleStates.BattleState battleState = BattleStates.get(pkmn.getBattle());
            BattleStates.ActorState actorState = battleState.getActorState(pkmn.getActor());
            BattleStates.PokemonState pkmnState = battleState.getPokemonState(pkmn.getBattlePokemon());
            Gimmicks gimmicks = trainer.getGimmicks().of(pkmn.getBattlePokemon().getOriginalPokemon());
            moveset.setCanTerastallize(gimmicks.tera() != null && !actorState.hasGimmick(ShowdownMoveset.Gimmick.TERASTALLIZATION.getId()) && !actorState.hasGimmick(ShowdownMoveset.Gimmick.MEGA_EVOLUTION.getId()) && !pkmnState.has(BattleEffects.Custom.MEGA) && !pkmnState.has(BattleEffects.Custom.ZMOVE) && !moveset.getCanUltraBurst() && !moveset.getCanMegaEvo() && moveset.getCanZMove() == null ? gimmicks.tera() : null);
            moveset.setCanDynamax(ModCommon.modLoader().isLoaded("mega_showdown") && gimmicks.dynamax() && !actorState.hasGimmick(ShowdownMoveset.Gimmick.DYNAMAX.getId()) && !pkmnState.has(BattleEffects.Custom.MEGA) && !pkmnState.has(BattleEffects.Custom.TERA) && !moveset.getCanUltraBurst() && !moveset.getCanMegaEvo() && moveset.getCanZMove() == null);
            if (!moveset.getCanDynamax()) {
                moveset.setMaxMoves(null);
            }
        }
        ResponseBuilder builder = ResponseBuilder.create(pkmn, moveset, forceSwitch).margin(this.rng.nextDouble(this.maxSelectMargin)).random(this.rng);
        builder.suggestMoves(candidates -> candidates.filter(pair -> {
            ActiveBattlePokemon targetPkmn;
            Object patt0$temp = pair.second;
            return !(patt0$temp instanceof ActiveBattlePokemon) || (targetPkmn = (ActiveBattlePokemon)patt0$temp).isAlive();
        }).map(pair -> {
            Object patt0$temp = pair.second;
            if (patt0$temp instanceof ActiveBattlePokemon) {
                ActiveBattlePokemon targetPkmn = (ActiveBattlePokemon)patt0$temp;
                return new ResponseBuilder.Choice<ResponseBuilder.Pair>(String.format("MOVE %s -> %s", ((InBattleMove)pair.first).id, targetPkmn.getBattlePokemon().getName().getString()), (ResponseBuilder.Pair)pair, 1.0 - this.evalMove(pkmn.getBattlePokemon(), targetPkmn.getBattlePokemon(), (InBattleMove)pair.first));
            }
            return new ResponseBuilder.Choice<ResponseBuilder.Pair>(String.format("MOVE %s -> <multi/none>", ((InBattleMove)pair.first).id), (ResponseBuilder.Pair)pair, 1.0 - this.evalMove(pkmn.getBattlePokemon(), null, (InBattleMove)pair.first));
        }));
        builder.suggestItems(candidates -> candidates.map(pair -> new ResponseBuilder.Choice<ResponseBuilder.Pair>(String.format("ITEM %s -> %s", ((BagItem)pair.first).getItemName(), ((BattlePokemon)pair.second).getName().getString()), (ResponseBuilder.Pair)pair, 1.0 - this.evalItem((BagItem)pair.first, (BattlePokemon)pair.second))));
        if (forceSwitch || !pkmn.hasPokemon() || !BattleEffects.Pokemon.State.trapped(pkmn.getBattlePokemon())) {
            builder.suggestSwitches(candidates -> candidates.map(bp -> new ResponseBuilder.Choice<BattlePokemon>(String.format("SWITCH %s -> %s", pkmn.isAlive() ? pkmn.getBattlePokemon().getName().getString() : "<dead>", bp.getName().getString()), (BattlePokemon)bp, 1.0 - this.evalSwitch(pkmn, (BattlePokemon)bp))));
        }
        return builder.response();
    }

    private double evalMove(BattlePokemon from, BattlePokemon to, InBattleMove move) {
        double e;
        MoveType mt = MoveType.of(move);
        if (to == null) {
            List all = mt == MoveType.HEAL || mt == MoveType.CURE || mt == MoveType.BUFF ? from.getActor().getSide().getActivePokemon() : from.getActor().getSide().getOppositeSide().getActivePokemon();
            return all.stream().filter(ActiveBattlePokemon::hasPokemon).map(pkmn -> this.evalMove(from, pkmn.getBattlePokemon(), move)).max(Double::compare).orElse(0.0);
        }
        boolean ally = from.actor.getSide().equals(to.actor.getSide());
        switch (mt) {
            case HEAL: {
                e = ally ? java.lang.Math.max(this.rngSin() * this.maxSelectMargin, 1.0 - (double)to.getHealth() / (double)to.getMaxHealth()) * this.statusMoveBias : 0.0;
                break;
            }
            case CURE: {
                e = ally ? (BattleEffects.Pokemon.Status.any(to) ? this.rngSin() : this.rngSin() * this.maxSelectMargin) * this.statusMoveBias : 0.0;
                break;
            }
            case BUFF: {
                e = ally ? this.rngSin() * java.lang.Math.min(1.0, 1.0 - BattleEffects.Pokemon.Boost.avg(to) * 5.0) * this.statusMoveBias : 0.0;
                double h = (double)from.getHealth() / (double)from.getMaxHealth();
                e *= h * h;
                break;
            }
            case MALUS: {
                e = !ally ? this.rngSin() * java.lang.Math.min(1.0, 1.0 + BattleEffects.Pokemon.Boost.avg(to) * 5.0) * this.statusMoveBias : 0.0;
                double h = (double)to.getHealth() / (double)to.getMaxHealth();
                e *= h * h;
                break;
            }
            case STATUS: {
                e = !ally ? (!BattleEffects.Pokemon.Status.any(to) && !BattleEffects.Pokemon.Volatile.any(to) ? this.rngSin() : this.rngSin() * this.maxSelectMargin) * this.statusMoveBias : 0.0;
                break;
            }
            case DAMAGE: {
                double dmg = (double)java.lang.Math.min(to.getHealth(), PokeMath.damage(from, to, move)) / (double)to.getHealth();
                e = !ally ? (dmg > 0.0 ? java.lang.Math.max(this.rngSin() * this.maxSelectMargin, dmg) * this.moveBias : 0.0) : 0.0;
                break;
            }
            default: {
                e = this.rng.nextDouble();
            }
        }
        return e == 0.0 ? -1.0 : MoveType.eval(from, to, move.id) * e;
    }

    private double evalItem(BagItem item, BattlePokemon to) {
        if (item instanceof PotionType) {
            PotionType potion = (PotionType)item;
            int amount = potion == PotionType.POTION ? java.lang.Math.min(20, to.getMaxHealth()) : (potion == PotionType.SUPER_POTION ? java.lang.Math.min(50, to.getMaxHealth()) : (potion == PotionType.HYPER_POTION ? java.lang.Math.min(200, to.getMaxHealth()) : (potion == PotionType.MAX_POTION ? to.getMaxHealth() : (potion == PotionType.FULL_RESTORE ? to.getMaxHealth() : 0))));
            double estHeal = (double)(java.lang.Math.min(to.getMaxHealth(), to.getHealth() + amount) - to.getHealth()) / (double)amount;
            return java.lang.Math.min(1.0, (double)amount / (double)to.getMaxHealth() * (1.0 - (double)to.getHealth() / (double)to.getMaxHealth()) * java.lang.Math.min(1.0, estHeal * (to.isSentOut() ? 1.0 : 0.75) * (BattleEffects.Pokemon.Status.any(to) && potion.getCuresStatus() ? 1.25 : 1.0)) * this.itemBias);
        }
        return 0.0;
    }

    private double evalSwitch(ActiveBattlePokemon from, BattlePokemon to) {
        double fboost = 1.0 - 0.5 * (from.hasPokemon() ? BattleEffects.Pokemon.Boost.avg(from.getBattlePokemon()) : 0.0);
        double fStat = from.hasPokemon() && (BattleEffects.Pokemon.Status.any(from.getBattlePokemon()) || BattleEffects.Pokemon.Volatile.any(from.getBattlePokemon())) ? 1.25 : 1.0;
        double tStat = BattleEffects.Pokemon.Status.any(to) ? 0.75 : 1.0;
        double[] d = new double[]{fStat * tStat * fboost};
        int atkFrom = from.hasPokemon() ? from.getBattlePokemon().getEffectedPokemon().getAttack() : 0;
        int spaFrom = from.hasPokemon() ? from.getBattlePokemon().getEffectedPokemon().getSpecialAttack() : 0;
        int defFrom = from.hasPokemon() ? from.getBattlePokemon().getEffectedPokemon().getAttack() : 0;
        int spdFrom = from.hasPokemon() ? from.getBattlePokemon().getEffectedPokemon().getSpecialAttack() : 0;
        int atkTo = to.getEffectedPokemon().getAttack();
        int spaTo = to.getEffectedPokemon().getSpecialAttack();
        int defTo = to.getEffectedPokemon().getAttack();
        int spdTo = to.getEffectedPokemon().getSpecialAttack();
        to.getActor().getSide().getOppositeSide().getActivePokemon().stream().filter(ActiveBattlePokemon::hasPokemon).forEach(pkmn -> {
            int atkOpp = pkmn.getBattlePokemon().getEffectedPokemon().getAttack();
            int spaOpp = pkmn.getBattlePokemon().getEffectedPokemon().getSpecialAttack();
            int defOpp = pkmn.getBattlePokemon().getEffectedPokemon().getAttack();
            int spdOpp = pkmn.getBattlePokemon().getEffectedPokemon().getSpecialAttack();
            double fe1 = from.hasPokemon() ? TypeChart.getEffectiveness(from.getBattlePokemon(), pkmn.getBattlePokemon()) : 0.0;
            double fe2 = from.hasPokemon() ? TypeChart.getEffectiveness(pkmn.getBattlePokemon(), from.getBattlePokemon()) : 4.0;
            double f1 = atkFrom > 0 ? (double)defOpp / (double)atkFrom : 1.0;
            double f2 = spaFrom > 0 ? (double)spdOpp / (double)spaFrom : 1.0;
            double f3 = defFrom > 0 ? (double)atkOpp / (double)defFrom : 1.0;
            double f4 = spdFrom > 0 ? (double)spaOpp / (double)spdFrom : 1.0;
            double f5 = fe1 > 0.0 ? 1.0 / fe1 : 1.0;
            double f6 = fe2 > 0.0 ? fe2 / 4.0 : 0.5;
            double te1 = TypeChart.getEffectiveness(to, pkmn.getBattlePokemon());
            double te2 = TypeChart.getEffectiveness(pkmn.getBattlePokemon(), to);
            double t1 = defOpp > 0 ? (double)atkTo / (double)defOpp : 2.0;
            double t2 = spdOpp > 0 ? (double)spaTo / (double)spdOpp : 2.0;
            double t3 = atkOpp > 0 ? (double)defTo / (double)atkOpp : 2.0;
            double t4 = spaOpp > 0 ? (double)spdTo / (double)spaOpp : 2.0;
            double t5 = te1 > 0.0 ? te2 / 4.0 : 0.5;
            double t6 = te2 > 0.0 ? 1.0 / te2 : 2.0;
            d[0] = d[0] * (f1 * f2 * f3 * f4 * f5 * f6 * t1 * t2 * t3 * t4 * t5 * t6);
        });
        double thRel = (double)to.getHealth() / (double)to.getMaxHealth();
        d[0] = d[0] * (thRel < 1.0 ? this.rng.nextDouble(thRel, 1.0) : 1.0);
        return java.lang.Math.min(1.0, d[0]) * this.switchBias * (from.hasPokemon() && BattleStates.get(from.getBattle()).getPokemonState(from.getBattlePokemon()).has(BattleEffects.Custom.DYNAMAX) ? 0.25 : 1.0);
    }

    private double rngSin() {
        return Math.sin((double)(this.rng.nextDouble() * 1.5707963267948966));
    }
}

