/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3999;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ModConfig;

public abstract class WeatherParticle
extends class_4003 {
    protected class_2338.class_2339 pos;
    protected class_2338.class_2339 oPos;
    boolean doCollisionAnim = false;
    class_3965 collision = null;
    float baseTemp;
    float targetOpacity;
    float oQuadSize;
    float distanceSquared;

    protected WeatherParticle(class_638 level, double x, double y, double z, float gravity, float opacity, float size, float windStrength, float stormWindStrength) {
        super(level, x, y, z);
        this.field_3844 = gravity;
        this.field_17867 = size;
        this.field_3841 = 0.0f;
        this.field_3852 = gravity * (level.method_8546() ? stormWindStrength : windStrength);
        if (ModConfig.CONFIG.compat.yLevelWindAdjustment) {
            this.field_3852 *= WeatherParticle.yLevelWindAdjustment(y);
        }
        this.field_3850 = this.field_3852;
        this.field_3869 = -gravity;
        this.field_3862 = false;
        this.targetOpacity = opacity;
        this.method_3080(0.01f, 0.01f);
        this.field_3847 = ModConfig.CONFIG.perf.particleDistance * 100;
        this.pos = new class_2338.class_2339(x, y, z);
        this.oPos = new class_2338.class_2339(x, y, z);
        this.baseTemp = ((class_1959)level.method_23753((class_2338)this.pos).comp_349()).method_8712();
        this.testForCollisions();
        ++WeatherParticleManager.particleCount;
    }

    public void method_3070() {
        super.method_3070();
        this.oQuadSize = this.field_17867;
        this.distanceSquared = (float)class_310.method_1551().field_1773.method_19418().method_19326().method_1028(this.field_3874, this.field_3854, this.field_3871);
        this.pos.method_10102(this.field_3874, this.field_3854, this.field_3871);
        if (!this.pos.equals((Object)this.oPos)) {
            this.onPositionUpdate();
            this.oPos.method_10101((class_2382)this.pos);
        }
        if (this.doCollisionAnim) {
            this.collisionAnim();
        }
        this.fadeByDistance();
    }

    public void onPositionUpdate() {
        if (!ModConfig.CONFIG.compat.crossBiomeBorder && (double)class_3532.method_15379((float)(((class_1959)this.field_3851.method_23753((class_2338)this.pos).comp_349()).method_8712() - this.baseTemp)) > 0.4) {
            this.doCollisionAnim = true;
        }
        if (this.field_3851.method_8320((class_2338)this.pos).method_26234((class_1922)this.field_3851, (class_2338)this.pos) || !this.field_3851.method_8316((class_2338)this.pos).method_15769()) {
            this.method_3085();
        } else {
            this.testForCollisions();
        }
    }

    public void testForCollisions() {
        class_243 quadCenterPos = new class_243(this.field_3874, this.field_3854, this.field_3871);
        class_243 quadEdgePos = new class_243(this.field_3852, this.field_3869, this.field_3850).method_1029().method_18805((double)this.field_17867, (double)this.field_17867, (double)this.field_17867).method_1031(this.field_3874, this.field_3854, this.field_3871);
        class_3965 hitResult = this.field_3851.method_17742(StonecutterUtil.getClipContext(quadCenterPos, quadEdgePos));
        if (!hitResult.method_17783().equals((Object)class_239.class_240.field_1333) && !this.doCollisionAnim) {
            this.collision = hitResult;
            this.doCollisionAnim = true;
        }
    }

    public void fadeByDistance() {
        float renderDistanceSquared = class_3532.method_34954((int)ModConfig.CONFIG.perf.particleDistance);
        if (this.distanceSquared > renderDistanceSquared + 2.0f) {
            this.method_3085();
        } else {
            this.field_3841 = class_3532.method_16439((float)(this.distanceSquared / renderDistanceSquared), (float)this.targetOpacity, (float)0.0f);
        }
    }

    public float method_18132(float scaleFactor) {
        return class_3532.method_16439((float)scaleFactor, (float)this.oQuadSize, (float)this.field_17867);
    }

    public void collisionAnim() {
        float deltaMovement = (float)new class_243(this.field_3852, this.field_3869, this.field_3850).method_1033();
        this.field_17867 -= deltaMovement;
        if (this.field_17867 <= 0.0f) {
            this.method_3085();
        }
    }

    public void method_3085() {
        if (this.method_3086()) {
            --WeatherParticleManager.particleCount;
        }
        super.method_3085();
    }

    public Quaternionf turnBackfaceFlipways(Quaternionf quaternion, Vector3f cameraOffset) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)quaternion).normalize();
        float dot = normal.dot((Vector3fc)cameraOffset);
        if (dot > 0.0f) {
            return quaternion.mul((Quaternionfc)class_7833.field_40716.rotation((float)java.lang.Math.PI));
        }
        return quaternion;
    }

    public static double yLevelWindAdjustment(double y) {
        return Math.clamp((double)0.01, (double)0.5, (double)((y - 64.0) / 40.0));
    }

    public class_3999 method_18122() {
        if (this.targetOpacity == 1.0f) {
            return class_3999.field_17828;
        }
        return class_3999.field_17829;
    }
}

