/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import java.awt.Color;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7833;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;
import pigcart.particlerain.mixin.access.SingleQuadParticleAccessor;
import pigcart.particlerain.particle.WeatherParticle;
import pigcart.particlerain.particle.render.BlendedParticleRenderType;

public class CustomParticle
extends WeatherParticle {
    ModConfig.ParticleOptions opts;

    public CustomParticle(class_638 level, double x, double y, double z, ModConfig.ParticleOptions opts) {
        super(level, x, y, z, opts.gravity, opts.opacity, opts.size, opts.windStrength, opts.stormWindStrength);
        this.opts = opts;
        this.field_3847 = opts.lifetime;
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)class_310.method_1551().field_1713;
        this.method_18141(particleEngine.getTextureAtlas().method_4608(StonecutterUtil.parseResourceLocation(opts.spriteLocations.get(level.field_9229.method_43048(opts.spriteLocations.size())))));
        switch (opts.tintType) {
            case CUSTOM: {
                this.method_3084((float)opts.customTint.getRed() / 255.0f, (float)opts.customTint.getGreen() / 255.0f, (float)opts.customTint.getBlue() / 255.0f);
                break;
            }
            case FOG: {
                Color color = new Color(((class_1959)this.field_3851.method_23753((class_2338)this.pos).comp_349()).method_24376()).darker();
                this.method_3084((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                break;
            }
            case WATER: {
                if (!ModConfig.CONFIG.compat.waterTint) break;
                TextureUtil.applyWaterTint(this, level, (class_2338)this.pos);
                break;
            }
            case MAP: {
                Color color = StonecutterUtil.getMapColor(level, (class_2338)this.pos);
                this.method_3084((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
        }
    }

    @Override
    public void method_3070() {
        super.method_3070();
        if (this.opts.constantScreenSize && !this.doCollisionAnim) {
            this.field_17867 = this.getDistanceSize();
        }
        this.tickWind();
    }

    public void tickWind() {
        float frequency = ModConfig.CONFIG.wind.gustFrequency;
        float shift = (float)ParticleRain.clientTicks * ModConfig.CONFIG.wind.modulationSpeed;
        float variance = ModConfig.CONFIG.wind.strengthVariance;
        float strength = ModConfig.CONFIG.wind.strength;
        float multiplier = this.field_3851.method_8546() ? this.opts.stormWindStrength : this.opts.windStrength;
        this.field_3852 = (double)((class_3532.method_15374((float)((float)this.field_3874 * frequency + shift)) * variance + variance + strength) * multiplier) * CustomParticle.yLevelWindAdjustment(this.field_3854);
        this.field_3850 = (double)((class_3532.method_15374((float)((float)this.field_3871 * frequency + shift)) * variance + variance + strength) * multiplier) * CustomParticle.yLevelWindAdjustment(this.field_3854);
    }

    public float getDistanceSize() {
        return this.distanceSquared * (this.opts.size / 100.0f);
    }

    @Override
    public class_3999 method_18122() {
        return switch (this.opts.renderType) {
            default -> throw new MatchException(null, null);
            case ModConfig.RenderType.TRANSLUCENT -> class_3999.field_17829;
            case ModConfig.RenderType.OPAQUE -> class_3999.field_17828;
            case ModConfig.RenderType.TERRAIN -> class_3999.field_17827;
            case ModConfig.RenderType.BLENDED -> BlendedParticleRenderType.INSTANCE;
        };
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickPercent) {
        class_243 camPos = camera.method_19326();
        float offsetX = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3858, (double)this.field_3874) - camPos.method_10216());
        float offsetY = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3838, (double)this.field_3854) - camPos.method_10214());
        float offsetZ = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3856, (double)this.field_3871) - camPos.method_10215());
        switch (this.opts.rotationType) {
            case COPY_CAMERA: {
                Quaternionf quaternion = new Quaternionf((Quaternionfc)camera.method_23767());
                if (this.field_3839 != 0.0f) {
                    quaternion.rotateZ(class_3532.method_16439((float)tickPercent, (float)this.field_3857, (float)this.field_3839));
                }
                this.method_60374(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent);
                break;
            }
            case RELATIVE_VELOCITY: {
                Vector3f camD = class_310.method_1551().field_1719.method_18798().method_46409();
                Vector3f deltaMotion = new Vector3f((float)this.field_3852 - camD.x, (float)this.field_3869 - camD.y, (float)this.field_3850 - camD.z);
                float angle = Math.acos((float)new Vector3f((Vector3fc)deltaMotion).normalize().y);
                Vector3f axis = new Vector3f(-deltaMotion.z(), 0.0f, deltaMotion.x()).normalize();
                Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
                Vector3f transformedOffset = new Vector3f(offsetX, offsetY, offsetZ);
                transformedOffset.rotateAxis(angle, axis.x, axis.y, axis.z);
                quaternion.mul((Quaternionfc)class_7833.field_40716.rotation(Math.atan2((float)transformedOffset.x, (float)transformedOffset.z) + (float)java.lang.Math.PI));
                float speed = class_3532.method_15363((float)deltaMotion.lengthSquared(), (float)0.2f, (float)1.0f);
                this.turnBackfaceFlipways(quaternion, new Vector3f(offsetX, offsetY, offsetZ));
                this.renderSquishyRotatedQuad(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent, speed);
                break;
            }
            case LOOKAT_PLAYER: {
                Vector3f localPos = new Vector3f(offsetX, offsetY, offsetZ);
                Quaternionf quaternion = class_7833.field_40716.rotation((float)java.lang.Math.atan2(offsetX, offsetZ) + (float)java.lang.Math.PI);
                float yAngle = (float)java.lang.Math.asin(offsetY / localPos.length());
                quaternion.rotateX(yAngle);
                quaternion.rotateZ((float)java.lang.Math.atan2(offsetX, offsetZ));
                if (yAngle < -1.0f) {
                    this.doCollisionAnim = true;
                }
                quaternion.rotateZ(class_3532.method_16439((float)tickPercent, (float)this.field_3857, (float)this.field_3839));
                this.method_60374(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent);
                break;
            }
            case FLAT_PLANES: {
                Quaternionf quaternion = new Quaternionf(new AxisAngle4d(1.5707963705062866, -1.0, 0.0, 0.0));
                quaternion.rotateZ(class_3532.method_16439((float)tickPercent, (float)this.field_3857, (float)this.field_3839));
                this.turnBackfaceFlipways(quaternion, new Vector3f(offsetX, offsetY, offsetZ));
                this.method_60374(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent);
            }
        }
    }

    private void renderSquishyRotatedQuad(class_4588 vertexConsumer, Quaternionf quaternion, float x, float y, float z, float tickPercent, float squish) {
        float size = this.method_18132(tickPercent);
        float u0 = this.method_18133();
        float u1 = this.method_18134();
        float v0 = this.method_18135();
        float v1 = this.method_18136();
        int color = this.method_3068(tickPercent);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, 1.0f, -squish, size, u1, v1, color);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, 1.0f, squish, size, u1, v0, color);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, -1.0f, squish, size, u0, v0, color);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, -1.0f, -squish, size, u0, v1, color);
    }

    private void renderVertex(class_4588 buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        SingleQuadParticleAccessor p = (SingleQuadParticleAccessor)((Object)this);
        p.callRenderVertex(buffer, quaternion, x, y, z, xOffset, yOffset, quadSize, u, v, packedLight);
    }

    public static class DefaultFactory
    implements class_707<class_2400> {
        ModConfig.ParticleOptions opts;

        public DefaultFactory(ModConfig.ParticleOptions opts) {
            this.opts = opts;
        }

        public class_703 createParticle(class_2400 parameters, class_638 level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            for (ModConfig.ParticleOptions options : ModConfig.CONFIG.customParticles) {
                if (!this.opts.id.equals(options.id)) continue;
                this.opts = options;
            }
            return new CustomParticle(level, x, y, z, this.opts);
        }
    }
}

