/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_703;
import net.minecraft.class_7924;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.particle.CustomParticle;

public final class WeatherParticleManager {
    public static int particleCount;
    public static int fogCount;
    private static final class_2338.class_2339 pos;
    private static final class_2338.class_2339 heightmapPos;

    private static void spawnParticles(class_638 level, class_6880<class_1959> biome, double x, double y, double z) {
        class_1959.class_1963 precipitation = StonecutterUtil.getPrecipitationAt((class_1937)level, (class_1959)biome.comp_349(), (class_2338)(ModConfig.CONFIG.compat.useHeightmapTemp ? heightmapPos : pos));
        block12: for (ModConfig.ParticleOptions opts : ModConfig.CONFIG.customParticles) {
            if (!opts.enabled || !opts.precipitation.contains(precipitation) || !(opts.density > level.field_9229.method_43057()) || !WeatherParticleManager.meetsRequirements(opts.biomeList, opts.biomeWhitelist, class_7924.field_41236, biome) || !WeatherParticleManager.meetsRequirements(opts.blockList, opts.blockWhitelist, class_7924.field_41254, level.method_8320((class_2338)heightmapPos).method_41520())) continue;
            if (opts.onGround) {
                double localBlockX = x - (double)pos.method_10263();
                double localBlockZ = z - (double)pos.method_10260();
                class_2680 blockState = level.method_8320((class_2338)heightmapPos);
                class_3610 fluidState = level.method_8316((class_2338)heightmapPos);
                class_265 voxelShape = blockState.method_26220((class_1922)level, (class_2338)heightmapPos);
                double blockHeight = voxelShape.method_1102(class_2350.class_2351.field_11052, localBlockX, localBlockZ);
                double fluidHeight = fluidState.method_15763((class_1922)level, (class_2338)heightmapPos);
                y = (double)heightmapPos.method_10264() + Math.max(blockHeight, fluidHeight);
            }
            switch (opts.id) {
                case "rain_splashing": {
                    level.method_8406((class_2394)class_2398.field_11242, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case "rain_ripples": {
                    level.method_8406((class_2394)ParticleRain.RIPPLE, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case "rain_smoke": {
                    level.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case "shrubs": {
                    level.method_8406((class_2394)ParticleRain.SHRUB, x, y, z, 0.0, 0.0, 0.0);
                    continue block12;
                }
            }
            class_310.method_1551().field_1713.method_3058((class_703)new CustomParticle(level, x, y, z, opts));
        }
    }

    public static <T> boolean meetsRequirements(List<String> list, boolean isWhitelist, class_5321<? extends class_2378<T>> registry, class_6880<T> holder) {
        if (!list.isEmpty()) {
            for (String string : list) {
                boolean hasMatch;
                class_2960 location = StonecutterUtil.parseResourceLocation(string);
                if (location == null) continue;
                class_6862 tag = class_6862.method_40092(registry, (class_2960)location);
                boolean bl = hasMatch = holder.method_40226(location) || holder.method_40220(tag);
                if (isWhitelist && hasMatch) {
                    return true;
                }
                if (!hasMatch) continue;
                return false;
            }
            return !isWhitelist;
        }
        return true;
    }

    public static void tick(class_638 level, class_243 cameraPos) {
        if (level.method_8419() && particleCount < ModConfig.CONFIG.perf.maxParticleAmount) {
            int density = (int)((float)class_3532.method_48781((float)level.method_8478(1.0f), (int)ModConfig.CONFIG.perf.particleDensity, (int)ModConfig.CONFIG.perf.particleStormDensity) * level.method_8430(1.0f));
            float speed = (float)class_310.method_1551().method_1560().method_18798().method_1027();
            density *= (int)(speed * 2.0f + 1.0f);
            for (int i = 0; i < density; ++i) {
                int cloudHeight;
                float height;
                if ((double)speed < 0.8) {
                    height = class_3532.method_15379((float)(class_3532.method_27285((float)level.field_9229.method_43057()) - class_3532.method_27285((float)level.field_9229.method_43057()))) * -1.0f + 1.0f;
                    height *= 1.0f;
                } else {
                    height = level.field_9229.method_43057();
                }
                float theta = (float)Math.PI * 2 * level.field_9229.method_43057();
                float phi = (float)Math.acos(2.0f * height - 1.0f);
                float x = (float)ModConfig.CONFIG.perf.particleDistance * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta) + (float)cameraPos.field_1352;
                float y = (float)ModConfig.CONFIG.perf.particleDistance * class_3532.method_15362((float)phi) + (float)cameraPos.field_1351;
                float z = (float)ModConfig.CONFIG.perf.particleDistance * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta) + (float)cameraPos.field_1350;
                if (!ModConfig.CONFIG.compat.canSpawnAboveClouds && (cloudHeight = StonecutterUtil.getCloudHeight(level)) != 0 && y > (float)cloudHeight) {
                    y = cloudHeight;
                }
                pos.method_10102((double)x, (double)y, (double)z);
                heightmapPos.method_10102((double)x, (double)(level.method_8624(class_2902.class_2903.field_13197, pos.method_10263(), pos.method_10260()) - 1), (double)z);
                if (heightmapPos.method_10264() > pos.method_10264()) continue;
                WeatherParticleManager.spawnParticles(level, (class_6880<class_1959>)level.method_23753((class_2338)pos), x, y, z);
            }
        }
    }

    public static class_3414 getAdditionalWeatherSounds(class_638 level, class_2338 blockPos, boolean above) {
        class_6880 biome = level.method_23753(blockPos);
        class_1959.class_1963 precipitation = StonecutterUtil.getPrecipitationAt((class_1937)level, (class_1959)biome.comp_349(), blockPos);
        if (precipitation == class_1959.class_1963.field_9383 && ModConfig.CONFIG.sound.doSnowSounds) {
            return above ? ParticleRain.WEATHER_SNOW_ABOVE : ParticleRain.WEATHER_SNOW;
        }
        if (WeatherParticleManager.doesThisBlockHaveDustBlowing(precipitation, level, blockPos, (class_6880<class_1959>)biome) && ModConfig.CONFIG.sound.doWindSounds) {
            return above ? ParticleRain.WEATHER_SANDSTORM_ABOVE : ParticleRain.WEATHER_SANDSTORM;
        }
        return null;
    }

    public static boolean doesThisBlockHaveDustBlowing(class_1959.class_1963 precipitation, class_638 level, class_2338 blockPos, class_6880<class_1959> biome) {
        boolean matchesTag = false;
        List<String> dustyBlockTags = List.of("minecraft:camel_sand_step_sound_blocks", "minecraft:sand");
        for (int i = 0; i < dustyBlockTags.size(); ++i) {
            if (!level.method_8320(level.method_8598(class_2902.class_2903.field_13197, blockPos).method_10074()).method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)StonecutterUtil.parseResourceLocation(dustyBlockTags.get(i))))) continue;
            matchesTag = true;
            break;
        }
        return precipitation == class_1959.class_1963.field_9384 && matchesTag && (double)((class_1959)biome.comp_349()).method_8712() > 0.25;
    }

    public static boolean canHostStreaks(class_2680 state) {
        return state.method_26164(class_3481.field_15490) || state.method_26164(class_3481.field_33715) || state.method_26164(ParticleRain.GLASS_PANES);
    }

    public static void resetParticleCount() {
        particleCount = 0;
        fogCount = 0;
    }

    static {
        pos = new class_2338.class_2339();
        heightmapPos = new class_2338.class_2339();
    }
}

