/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1011;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import org.joml.Math;
import org.lwjgl.system.MemoryUtil;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.mixin.access.NativeImageAccessor;

public class TextureUtil {
    public static IntUnaryOperator desaturateOperation = rgba -> {
        Color col = new Color(rgba, true);
        int gray = Math.max((int)Math.max((int)col.getRed(), (int)col.getGreen()), (int)col.getBlue());
        return (col.getAlpha() & 0xFF) << 24 | (gray & 0xFF) << 16 | (gray & 0xFF) << 8 | gray & 0xFF;
    };

    public static void applyToAllPixels(java.util.function.IntUnaryOperator function, class_1011 image) {
        if (image.method_4318() != class_1011.class_1012.field_4997) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "function application only works on RGBA images; have %s", image.method_4318()));
        }
        ((NativeImageAccessor)image).callCheckAllocated();
        int i = image.method_4307() * image.method_4323();
        IntBuffer intBuffer = MemoryUtil.memIntBuffer((long)((NativeImageAccessor)image).getPixels(), (int)i);
        for (int j = 0; j < i; ++j) {
            int k = TextureUtil.argbToABGR(intBuffer.get(j));
            int l = function.applyAsInt(k);
            intBuffer.put(j, TextureUtil.argbToABGR(l));
        }
    }

    public static int argbToABGR(int i) {
        return i & 0xFF00FF00 | (i & 0xFF0000) >> 16 | (i & 0xFF) << 16;
    }

    public static void applyWaterTint(class_4003 particle, class_638 clientLevel, class_2338 blockPos) {
        Color waterColor = new Color(class_1163.method_4961((class_1920)clientLevel, (class_2338)blockPos));
        Color fogColor = new Color(((class_1959)clientLevel.method_23753(blockPos).comp_349()).method_24376());
        float rCol = class_3532.method_16439((float)ModConfig.CONFIG.compat.tintMix, (float)waterColor.getRed(), (float)fogColor.getRed()) / 255.0f;
        float gCol = class_3532.method_16439((float)ModConfig.CONFIG.compat.tintMix, (float)waterColor.getGreen(), (float)fogColor.getGreen()) / 255.0f;
        float bCol = class_3532.method_16439((float)ModConfig.CONFIG.compat.tintMix, (float)waterColor.getBlue(), (float)fogColor.getBlue()) / 255.0f;
        particle.method_3084(rCol, gCol, bCol);
    }

    public static class_1011 loadTexture(class_2960 resourceLocation) throws IOException {
        class_1011 nativeImage;
        class_3298 resource = class_310.method_1551().method_1478().getResourceOrThrow(resourceLocation);
        try (InputStream inputStream = resource.method_14482();){
            nativeImage = class_1011.method_4309((InputStream)inputStream);
        }
        return nativeImage;
    }

    public static class_7764 splitImage(class_1011 image, int segment, String id) {
        int size = image.method_4307();
        class_1011 sprite = new class_1011(size, size, false);
        image.method_47594(sprite, 0, size * segment, 0, 0, size, size, true, true);
        return new class_7764(StonecutterUtil.getResourceLocation("particlerain", id + segment), new class_7771(size, size), sprite, StonecutterUtil.getSpriteMetadata());
    }

    public static int getRippleResolution(List<class_7764> contents) {
        if (ModConfig.CONFIG.ripple.useResourcepackResolution) {
            class_2960 resourceLocation = StonecutterUtil.getResourceLocation("big_smoke_0");
            for (class_7764 spriteContents : contents) {
                if (!spriteContents.method_45816().equals((Object)resourceLocation)) continue;
                if (spriteContents.method_45807() < 256) {
                    return spriteContents.method_45807();
                }
                return 256;
            }
        }
        if (ModConfig.CONFIG.ripple.resolution < 4) {
            ModConfig.CONFIG.ripple.resolution = 4;
        }
        if (ModConfig.CONFIG.ripple.resolution > 256) {
            ModConfig.CONFIG.ripple.resolution = 256;
        }
        return ModConfig.CONFIG.ripple.resolution;
    }

    public static class_7764 generateRipple(int i, int size) {
        float radius = (float)size / 2.0f / 8.0f * (float)(i + 1);
        class_1011 image = new class_1011(size, size, true);
        Color color = Color.WHITE;
        int colorint = (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
        TextureUtil.generateBresenhamCircle(image, size, (int)Math.clamp((float)1.0f, (float)((float)size / 2.0f - 1.0f), (float)radius), colorint);
        return new class_7764(StonecutterUtil.getResourceLocation("particlerain", "ripple_" + i), new class_7771(size, size), image, StonecutterUtil.getSpriteMetadata());
    }

    public static void generateBresenhamCircle(class_1011 image, int imgSize, int radius, int colorint) {
        int centerX = imgSize / 2;
        int centerY = imgSize / 2;
        int x = 0;
        int y = radius;
        int d = 3 - 2 * radius;
        TextureUtil.drawCirclePixel(centerX, centerY, x, y, image, colorint);
        while (y >= x) {
            d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * x + 6;
            TextureUtil.drawCirclePixel(centerX, centerY, ++x, y, image, colorint);
        }
    }

    static void drawCirclePixel(int xc, int yc, int x, int y, class_1011 img, int col) {
        img.method_4305(xc + x, yc + y, col);
        img.method_4305(xc - x, yc + y, col);
        img.method_4305(xc + x, yc - y, col);
        img.method_4305(xc - x, yc - y, col);
        img.method_4305(xc + y, yc + x, col);
        img.method_4305(xc - y, yc + x, col);
        img.method_4305(xc + y, yc - x, col);
        img.method_4305(xc - y, yc - x, col);
    }
}

