/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.text.DecimalFormat;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.TaskScheduler;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigScreens;
import pigcart.particlerain.config.ModConfig;

public class ParticleRain {
    public static int clientTicks = 0;
    public static final String MOD_ID = "particlerain";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"particlerain");
    public static final class_6862<class_2248> GLASS_PANES = ParticleRain.commonBlockTag("glass_panes");
    public static class_2400 MIST;
    public static class_2400 SHRUB;
    public static class_2400 RIPPLE;
    public static class_2400 STREAK;
    public static class_3414 WEATHER_SNOW;
    public static class_3414 WEATHER_SNOW_ABOVE;
    public static class_3414 WEATHER_SANDSTORM;
    public static class_3414 WEATHER_SANDSTORM_ABOVE;

    public static class_6862<class_2248> commonBlockTag(String tagId) {
        return class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)StonecutterUtil.getResourceLocation("c", tagId));
    }

    public static void onInitializeClient() {
        ModConfig.loadConfig();
        WEATHER_SNOW = ParticleRain.createSoundEvent("weather.snow");
        WEATHER_SNOW_ABOVE = ParticleRain.createSoundEvent("weather.snow.above");
        WEATHER_SANDSTORM = ParticleRain.createSoundEvent("weather.sandstorm");
        WEATHER_SANDSTORM_ABOVE = ParticleRain.createSoundEvent("weather.sandstorm.above");
    }

    public static void onTick(class_310 client) {
        if (!client.method_1493() && client.field_1687 != null && client.field_1773.method_19418().method_19332()) {
            ++clientTicks;
            WeatherParticleManager.tick(client.field_1687, client.field_1773.method_19418().method_19326());
            TaskScheduler.tick();
        }
    }

    private static class_3414 createSoundEvent(String name) {
        class_2960 id = StonecutterUtil.getResourceLocation(MOD_ID, name);
        return class_3414.method_47908((class_2960)id);
    }

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).executes(ctx -> {
            TaskScheduler.scheduleDelayed(1, () -> class_310.method_1551().method_1507(ConfigScreens.generateMainConfigScreen(null)));
            return 0;
        })).then(LiteralArgumentBuilder.literal((String)"debug").executes(ctx -> {
            class_638 level = class_310.method_1551().field_1687;
            ParticleRain.addChatMsg(String.format("Particle count: %d/%d", WeatherParticleManager.particleCount, ModConfig.CONFIG.perf.maxParticleAmount));
            ParticleRain.addChatMsg(String.format("Fog density: %d/%f", WeatherParticleManager.fogCount, Float.valueOf(ModConfig.CONFIG.mist.density)));
            class_2338 blockPos = class_2338.method_49638((class_2374)class_310.method_1551().field_1724.method_19538());
            class_6880 holder = level.method_23753(blockPos);
            String biomeStr = (String)holder.method_40229().map(resourceKey -> resourceKey.method_29177().toString(), biome -> "[unregistered " + String.valueOf(biome) + "]");
            ParticleRain.addChatMsg("Biome: " + biomeStr);
            class_1959.class_1963 precipitation = StonecutterUtil.getPrecipitationAt((class_1937)level, (class_1959)holder.comp_349(), blockPos);
            ParticleRain.addChatMsg("Precipitation: " + String.valueOf(precipitation));
            ParticleRain.addChatMsg("Base Temp: " + ((class_1959)holder.comp_349()).method_8712());
            ParticleRain.addChatMsg("Cloud height: " + StonecutterUtil.getCloudHeight(level));
            return 0;
        }));
    }

    private static void addChatMsg(String message) {
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)message));
    }

    public static void debugValue(float value) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43470((String)df.format(value)), true);
    }
}

