/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RemoteControllerPeripheral
implements IPeripheral {
    private final RemoteControllerBlockEntity remote;

    public RemoteControllerPeripheral(RemoteControllerBlockEntity remote) {
        this.remote = remote;
    }

    public String getType() {
        return "elevator_remote";
    }

    public boolean equals(IPeripheral other) {
        return other instanceof RemoteControllerPeripheral && Objects.equals(this.remote.method_11016(), ((RemoteControllerPeripheral)other).remote.method_11016());
    }

    @LuaFunction
    public final boolean isMoving() {
        if (!this.remote.hasGroup()) {
            return false;
        }
        return this.remote.getGroup().isMoving();
    }

    @LuaFunction
    public final Map<String, Object> getStatus() {
        ControllerBlockEntity controller;
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("hasGroup", this.remote.hasGroup());
        status.put("isInCabin", this.remote.isInCabin());
        if (this.remote.hasGroup() && (controller = this.remote.getController()) != null) {
            ElevatorGroup group = this.remote.getGroup();
            status.put("currentFloor", group.getFloorNumber(controller.getFloorLevel()) + 1);
            status.put("totalFloors", group.getFloorCount());
            status.put("isMoving", this.isMoving());
            status.put("floorName", this.remote.getFloorName());
        }
        return status;
    }
}

