/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DisplayPeripheral
implements IPeripheral {
    private final DisplayBlockEntity display;

    public DisplayPeripheral(DisplayBlockEntity display) {
        this.display = display;
    }

    public String getType() {
        return "elevator_display";
    }

    public boolean equals(IPeripheral other) {
        return other instanceof DisplayPeripheral && Objects.equals(this.display.method_11016(), ((DisplayPeripheral)other).display.method_11016());
    }

    @LuaFunction
    public final boolean isMoving() {
        ElevatorGroup group = this.display.getElevatorGroup();
        return group != null && group.isMoving();
    }

    @LuaFunction
    public final Map<String, Object> getDisplayInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        ElevatorInputBlockEntity inputEntity = this.display.getInputBlockEntity();
        ElevatorGroup group = this.display.getElevatorGroup();
        info.put("isBottomDisplay", this.display.isBottomDisplay());
        info.put("hasDisplayOnTop", this.display.hasDisplayOnTop());
        info.put("displayCategory", this.display.getDisplayCategory());
        if (inputEntity != null && group != null) {
            info.put("currentFloor", group.getFloorNumber(inputEntity.getFloorLevel()) + 1);
            info.put("totalFloors", group.getFloorCount());
            info.put("isMoving", group.isMoving());
            info.put("floorName", inputEntity.getFloorName());
        }
        return info;
    }
}

