/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2338;

public class ControllerPeripheral
implements IPeripheral {
    private final ControllerBlockEntity controller;

    public ControllerPeripheral(ControllerBlockEntity controller) {
        this.controller = controller;
    }

    public String getType() {
        return "elevator";
    }

    public boolean equals(IPeripheral other) {
        return other instanceof ControllerPeripheral && Objects.equals(this.controller.method_11016(), ((ControllerPeripheral)other).controller.method_11016());
    }

    @LuaFunction
    public final boolean isMoving() {
        if (!this.controller.hasGroup()) {
            return false;
        }
        return this.controller.getGroup().isMoving();
    }

    @LuaFunction
    public final int getCurrentFloor() {
        if (!this.controller.hasGroup()) {
            return -1;
        }
        ElevatorGroup group = this.controller.getGroup();
        if (group.isMoving()) {
            int closestFloor = group.getClosestFloorNumber((int)group.getCurrentY());
            return closestFloor + 1;
        }
        for (int i = 0; i < group.getFloorCount(); ++i) {
            int floorY = group.getFloorYLevel(i);
            class_2338 cagePos = group.getCageAnchorBlockPos(floorY);
            if (!ElevatorCage.canCreateCage(group.level, cagePos, group.getCageSizeX(), group.getCageSizeY(), group.getCageSizeZ())) continue;
            return i + 1;
        }
        return 1;
    }

    @LuaFunction
    public final int getFloors() {
        if (!this.controller.hasGroup()) {
            return 0;
        }
        return this.controller.getGroup().getFloorCount();
    }

    @LuaFunction
    public final boolean goUp() {
        if (!this.controller.hasGroup()) {
            return false;
        }
        ElevatorGroup group = this.controller.getGroup();
        group.ccButtonPress(true, false, this.controller.getFloorLevel());
        return true;
    }

    @LuaFunction
    public final boolean goDown() {
        if (!this.controller.hasGroup()) {
            return false;
        }
        ElevatorGroup group = this.controller.getGroup();
        group.ccButtonPress(false, true, this.controller.getFloorLevel());
        return true;
    }

    @LuaFunction
    public final boolean callElevator() {
        if (!this.controller.hasGroup()) {
            return false;
        }
        ElevatorGroup group = this.controller.getGroup();
        group.ccButtonPress(false, false, this.controller.getFloorLevel());
        return true;
    }

    @LuaFunction
    public final boolean goToFloor(int floor) {
        if (!this.controller.hasGroup()) {
            return false;
        }
        ElevatorGroup group = this.controller.getGroup();
        int targetFloor = floor - 1;
        if (targetFloor < 0 || targetFloor >= group.getFloorCount()) {
            return false;
        }
        group.ccGoToFloor(targetFloor);
        return true;
    }

    @LuaFunction
    public final Map<String, Object> getStatus() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("hasGroup", this.controller.hasGroup());
        if (this.controller.hasGroup()) {
            status.put("currentFloor", this.getCurrentFloor());
            status.put("totalFloors", this.getFloors());
            status.put("isMoving", this.isMoving());
        }
        return status;
    }

    @LuaFunction
    public final Map<String, Object> getCageInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (this.controller.hasGroup()) {
            ElevatorGroup group = this.controller.getGroup();
            info.put("sizeX", group.getCageSizeX());
            info.put("sizeY", group.getCageSizeY());
            info.put("sizeZ", group.getCageSizeZ());
            if (group.isMoving()) {
                info.put("currentY", group.getCurrentY());
            }
        }
        return info;
    }
}

