/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.decoration;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.minecraft.class_8824;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MLMapMarker<D extends MLMapDecoration> {
    private final class_6880<MLMapDecorationType<?, ?>> type;
    @NotNull
    protected final class_2338 pos;
    protected final float rot;
    protected final Optional<class_2561> name;
    protected final boolean preventsExtending;
    protected final boolean shouldRefresh;
    protected final boolean shouldSave;
    public static final Codec<MLMapMarker<?>> REFERENCE_CODEC = MLMapDecorationType.CODEC.dispatch("type", MLMapMarker::getType, mapWorldMarker -> ((MLMapDecorationType)mapWorldMarker.comp_349()).getMarkerCodec());
    public static final int HAS_SMALL_TEXTURE_FLAG = 1;

    public static <T extends MLMapMarker<?>> Products.P7<RecordCodecBuilder.Mu<T>, class_6880<MLMapDecorationType<?, ?>>, class_2338, Float, Optional<class_2561>, Optional<Boolean>, Optional<Boolean>, Boolean> baseCodecGroup(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)MLMapDecorationType.CODEC.fieldOf("type").forGetter(m -> m.getType()), (App)class_2338.field_25064.fieldOf("pos").forGetter(m -> m.getPos()), (App)Codec.FLOAT.optionalFieldOf("rot", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.getRotation())), (App)class_8824.field_46598.optionalFieldOf("name").forGetter(m -> m.getDisplayName()), (App)Codec.BOOL.optionalFieldOf("should_refresh").forGetter(m -> Optional.of(m.shouldRefreshFromWorld())), (App)Codec.BOOL.optionalFieldOf("should_save").forGetter(m -> Optional.of(m.shouldSave())), (App)Codec.BOOL.optionalFieldOf("prevents_extending", (Object)false).forGetter(m -> m.preventsExtending()));
    }

    public MLMapMarker(class_6880<MLMapDecorationType<?, ?>> type, class_2338 pos, float rotation, Optional<class_2561> component, Optional<Boolean> shouldRefresh, Optional<Boolean> shouldSave, boolean preventsExtending) {
        this.type = type;
        this.pos = pos;
        this.rot = rotation;
        this.name = component;
        this.shouldRefresh = shouldRefresh.orElse(((MLMapDecorationType)type.comp_349()).isFromWorld());
        this.shouldSave = shouldSave.orElse(((MLMapDecorationType)type.comp_349()).isFromWorld());
        this.preventsExtending = preventsExtending;
    }

    public class_6880<MLMapDecorationType<?, ?>> getType() {
        return this.type;
    }

    public boolean shouldRefreshFromWorld() {
        return this.shouldRefresh;
    }

    public boolean shouldSave() {
        return this.shouldSave;
    }

    public boolean preventsExtending() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLMapMarker that = (MLMapMarker)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.pos, that.pos) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pos, this.name);
    }

    public String getMarkerUniqueId() {
        return this.type.method_55840() + "-" + this.pos.method_10263() + "," + this.pos.method_10264() + "," + this.pos.method_10260();
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public float getRotation() {
        return this.rot;
    }

    public Optional<class_2561> getDisplayName() {
        return this.name;
    }

    @NotNull
    protected abstract D doCreateDecoration(byte var1, byte var2, byte var3);

    @Nullable
    public D createDecorationFromMarker(class_22 data) {
        class_2338 pos = this.getPos();
        if (pos == null) {
            return null;
        }
        double worldX = pos.method_10263();
        double worldZ = pos.method_10260();
        double rotation = this.getRotation();
        int i = 1 << data.field_119;
        float f = (float)(worldX - (double)data.field_116) / (float)i;
        float f1 = (float)(worldZ - (double)data.field_115) / (float)i;
        byte mapX = (byte)((double)(f * 2.0f) + 0.5);
        byte mapY = (byte)((double)(f1 * 2.0f) + 0.5);
        if (f >= -64.0f && f1 >= -64.0f && f <= 64.0f && f1 <= 64.0f) {
            byte rot = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            return this.doCreateDecoration(mapX, mapY, rot);
        }
        return null;
    }

    public int getFlags() {
        return 0;
    }

    public boolean hasFlag(int flag) {
        return (this.getFlags() & flag) != 0;
    }
}

