/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.util.LenientListCodec;
import net.minecraft.class_1792;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FluidContainerList {
    public static final Codec<FluidContainerList> CODEC = LenientListCodec.of(Category.CODEC).xmap(FluidContainerList::new, FluidContainerList::getCategories);
    private final Map<class_1792, Category> emptyToFilledMap = new IdentityHashMap<class_1792, Category>();

    public FluidContainerList(List<Category> categoryList) {
        categoryList.forEach(this::addCategory);
    }

    public FluidContainerList() {
    }

    private void addCategory(Category newCategory) {
        if (!newCategory.isEmpty()) {
            if (this.emptyToFilledMap.containsKey(newCategory.emptyContainer)) {
                Category c = this.emptyToFilledMap.get(newCategory.emptyContainer);
                if (c.containerCapacity == newCategory.containerCapacity) {
                    c.filled.addAll(newCategory.filled);
                }
            } else {
                this.emptyToFilledMap.put(newCategory.emptyContainer, newCategory);
            }
        }
    }

    public Optional<class_1792> getEmpty(class_1792 filledContainer) {
        for (Map.Entry<class_1792, Category> e : this.emptyToFilledMap.entrySet()) {
            if (!e.getValue().getFilledItems().contains(filledContainer)) continue;
            return Optional.of(e.getKey());
        }
        return Optional.empty();
    }

    public Optional<class_1792> getFilled(class_1792 emptyContainer) {
        Category c = this.emptyToFilledMap.get(emptyContainer);
        if (c != null) {
            return c.getFirstFilled();
        }
        return Optional.empty();
    }

    public Optional<Category> getCategoryFromEmpty(class_1792 emptyContainer) {
        return Optional.ofNullable(this.emptyToFilledMap.get(emptyContainer));
    }

    public Optional<Category> getCategoryFromFilled(class_1792 filledContainer) {
        return this.getEmpty(filledContainer).map(this.emptyToFilledMap::get);
    }

    public Collection<class_1792> getPossibleFilled() {
        ArrayList<class_1792> list = new ArrayList<class_1792>();
        this.emptyToFilledMap.values().forEach(c -> list.addAll(c.filled));
        return list;
    }

    public Collection<class_1792> getPossibleEmpty() {
        return this.emptyToFilledMap.keySet();
    }

    public List<Category> getCategories() {
        return List.copyOf(this.emptyToFilledMap.values());
    }

    protected void merge(FluidContainerList other) {
        other.emptyToFilledMap.values().forEach(this::addCategory);
    }

    protected void add(class_1792 empty, class_1792 filled, int amount) {
        Category c = this.emptyToFilledMap.computeIfAbsent(empty, i -> new Category((class_1792)i, amount));
        c.addItem(filled);
    }

    protected void add(class_1792 empty, class_1792 filled, int amount, class_3414 fillSound, class_3414 emptySound) {
        Category c = this.emptyToFilledMap.computeIfAbsent(empty, i -> new Category((class_1792)i, amount));
        c.addItem(filled);
        c.fillSound = fillSound;
        c.emptySound = emptySound;
    }

    private static <T> Function<Category, Optional<T>> getHackyOptional(Function<Category, T> getter) {
        return f -> {
            Object def;
            Object value = getter.apply((Category)f);
            return value.equals(def = getter.apply(Category.EMPTY.get())) ? Optional.empty() : Optional.of(value);
        };
    }

    public static class Category {
        private static final Supplier<Category> EMPTY = Suppliers.memoize(() -> new Category((class_1792)class_7923.field_41178.method_10223(class_7923.field_41178.method_10137()), 1));
        public static final Codec<Category> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_39673().fieldOf("empty").forGetter(c -> c.emptyContainer), (App)SoftFluid.Capacity.INT_CODEC.fieldOf("capacity").forGetter(Category::getCapacity), (App)class_7923.field_41178.method_39673().listOf().fieldOf("filled").forGetter(c -> c.filled), (App)class_7923.field_41172.method_39673().optionalFieldOf("fill_sound").forGetter(FluidContainerList.getHackyOptional(Category::getFillSound)), (App)class_7923.field_41172.method_39673().optionalFieldOf("empty_sound").forGetter(FluidContainerList.getHackyOptional(Category::getEmptySound))).apply((Applicative)instance, Category::decode));
        private final class_1792 emptyContainer;
        private final int containerCapacity;
        private class_3414 fillSound;
        private class_3414 emptySound;
        private final List<class_1792> filled = new ArrayList<class_1792>();

        private Category(class_1792 emptyContainer, int capacity, @Nullable class_3414 fillSound, @Nullable class_3414 emptySound) {
            this.emptyContainer = emptyContainer;
            this.containerCapacity = capacity;
            this.fillSound = fillSound == null ? class_3417.field_14779 : fillSound;
            this.emptySound = emptySound == null ? class_3417.field_14826 : emptySound;
        }

        private Category(class_1792 emptyContainer, int capacity) {
            this(emptyContainer, capacity, null, null);
        }

        private static Category decode(class_1792 empty, int capacity, List<class_1792> filled) {
            return Category.decode(empty, capacity, filled, Optional.empty(), Optional.empty());
        }

        private static Category decode(class_1792 empty, int capacity, List<class_1792> filled, Optional<class_3414> fillSound, Optional<class_3414> emptySound) {
            Category category = new Category(empty, capacity, fillSound.orElse(null), emptySound.orElse(null));
            filled.forEach(category::addItem);
            if (category.isEmpty()) {
                return EMPTY.get();
            }
            return category;
        }

        public class_1792 getEmptyContainer() {
            return this.emptyContainer;
        }

        public int getCapacity() {
            return this.containerCapacity;
        }

        private void addItem(class_1792 i) {
            if (!i.method_7854().method_7960() && !this.filled.contains(i)) {
                this.filled.add(i);
            }
        }

        public int getAmount() {
            return this.containerCapacity;
        }

        public class_3414 getFillSound() {
            return this.fillSound;
        }

        public class_3414 getEmptySound() {
            return this.emptySound;
        }

        public List<class_1792> getFilledItems() {
            return this.filled;
        }

        public boolean isEmpty() {
            return this.filled.isEmpty();
        }

        public Optional<class_1792> getFirstFilled() {
            return this.filled.stream().findFirst();
        }
    }
}

