/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public abstract class ImprovedProjectileEntity
extends class_3857 {
    private static final class_2940<Byte> ID_FLAGS = class_2945.method_12791(ImprovedProjectileEntity.class, (class_2941)class_2943.field_13319);
    protected class_243 movementOld = this.method_18798();
    protected boolean isStuck = false;
    protected int stuckTime = 0;
    protected int maxAge = 300;
    protected int maxStuckTime = 20;

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, class_1937 world) {
        super(type, world);
    }

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, double x, double y, double z, class_1937 world) {
        this(type, world);
        this.method_5814(x, y, z);
    }

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, class_1309 thrower, class_1937 world) {
        this(type, thrower.method_23317(), thrower.method_23320() - (double)0.1f, thrower.method_23321(), world);
        this.method_7432((class_1297)thrower);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ID_FLAGS, (Object)0);
    }

    public boolean hasLeftOwner() {
        return this.field_23740;
    }

    public void method_5773() {
        class_243 movement;
        this.field_5960 = this.isNoPhysics();
        if (!this.field_28646) {
            this.method_32875((class_6880)class_5712.field_28161, this.method_24921());
            this.field_28646 = true;
        }
        if (!this.field_23740) {
            this.field_23740 = this.method_26961();
        }
        this.method_5670();
        if (this.hasReachedEndOfLife() && !this.method_31481()) {
            this.reachedEndOfLife();
        }
        class_1937 level = this.method_37908();
        this.movementOld = movement = this.method_18798();
        if (this.field_17046.method_1027() > 1.0E-7) {
            movement = movement.method_18806(this.field_17046);
            this.field_17046 = class_243.field_1353;
            this.method_18799(class_243.field_1353);
        }
        this.stuckTime = !this.field_5960 && this.isStuck ? ++this.stuckTime : 0;
        this.method_5784(class_1313.field_6308, movement);
        this.method_36974();
        this.updateFireState();
        float deceleration = this.method_5799() ? this.getWaterInertia() : this.getInertia();
        this.method_18799(this.method_18798().method_1021((double)deceleration));
        if (!this.method_5740() && !this.field_5960) {
            this.method_18799(this.method_18798().method_1023(0.0, this.method_56989(), 0.0));
        }
        if (!this.isStuck) {
            if (level.field_9236) {
                this.spawnTrailParticles();
            }
            this.method_26962();
        }
        this.isStuck = !this.field_5960 && this.method_19538().method_1023(this.field_6014, this.field_6036, this.field_5969).method_1027() < 1.0E-8;
    }

    private void updateFireState() {
        this.field_28629 = this.method_5809();
        if (this.method_37908().method_29556(this.method_5829().method_1011(1.0E-6)).noneMatch(arg -> arg.method_26164(class_3481.field_21952) || arg.method_27852(class_2246.field_10164))) {
            if (this.method_20802() <= 0) {
                this.method_20803(-this.method_5676());
            }
            if (this.field_28629 && (this.field_27857 || this.method_5637() || ForgeHelper.isInFluidThatCanExtinguish((class_1297)this))) {
                this.method_36975();
            }
        }
        if (this.method_5809() && (this.field_27857 || this.method_5637() || ForgeHelper.isInFluidThatCanExtinguish((class_1297)this))) {
            this.method_20803(-this.method_5676());
        }
    }

    public void method_5784(class_1313 moverType, class_243 movement) {
        class_3965 bi;
        class_2338 hitPos;
        class_2680 hitState;
        if (moverType != class_1313.field_6308 || this.field_5960) {
            super.method_5784(moverType, movement);
            return;
        }
        movement = this.method_18796(movement, moverType);
        class_1937 level = this.method_37908();
        class_243 pos = this.method_19538();
        ColliderType colliderType = this.getColliderType();
        class_3965 hitResult = switch (colliderType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> level.method_17742(new class_3959(pos, pos.method_1019(movement), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            case 1 -> MthUtils.collideWithSweptAABB((class_1297)this, movement, 2.0);
            case 2 -> {
                class_243 vec3 = this.method_17835(movement);
                class_243 sub = vec3.method_1020(movement);
                if (vec3 == movement) {
                    yield class_3965.method_17778((class_243)pos.method_1019(vec3), (class_2350)class_2350.field_11036, (class_2338)class_2338.method_49638((class_2374)pos.method_1019(vec3)));
                }
                yield new class_3965(pos.method_1019(vec3), class_2350.method_10142((double)sub.field_1352, (double)sub.field_1351, (double)sub.field_1350), class_2338.method_49638((class_2374)pos.method_1019(vec3)), false);
            }
        };
        class_243 newPos = hitResult.method_17784();
        class_243 newMovement = newPos.method_1020(pos);
        this.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        boolean bl = !class_3532.method_20390((double)newMovement.field_1352, (double)movement.field_1352);
        boolean bl2 = !class_3532.method_20390((double)newMovement.field_1350, (double)movement.field_1350);
        this.field_5976 = bl || bl2;
        this.field_5992 = newMovement.field_1351 != movement.field_1351;
        this.field_36331 = this.field_5992 && newMovement.field_1351 < 0.0;
        this.field_34927 = this.field_5976 ? this.method_39759(newMovement) : false;
        class_3966 entityHitResult = class_1675.method_18077((class_1937)level, (class_1297)this, (class_243)pos, (class_243)newPos, (class_238)this.method_5829().method_18804(newPos.method_1020(pos)).method_1014(1.0), x$0 -> this.method_26958((class_1297)x$0));
        if (entityHitResult != null) {
            hitResult = entityHitResult;
        }
        boolean portalHit = false;
        if (hitResult instanceof class_3966) {
            class_3966 ei = (class_3966)hitResult;
            class_1297 hitEntity = ei.method_17782();
            if (hitEntity == this.method_24921()) {
                if (!this.canHarmOwner()) {
                    hitResult = null;
                }
            } else if (hitEntity instanceof class_1657) {
                class_1657 p2;
                class_1657 p1 = (class_1657)hitEntity;
                class_1297 class_12972 = this.method_24921();
                if (class_12972 instanceof class_1657 && !(p2 = (class_1657)class_12972).method_7256(p1)) {
                    hitResult = null;
                }
            }
        } else if (!(hitResult instanceof class_3965) || (hitState = level.method_8320(hitPos = (bi = hitResult).method_17777())).method_27852(class_2246.field_10316) || hitState.method_27852(class_2246.field_10613)) {
            // empty if block
        }
        if (!portalHit && hitResult != null && hitResult.method_17783() != class_239.class_240.field_1333 && !ForgeHelper.onProjectileImpact((class_1676)this, (class_239)hitResult)) {
            this.method_7488((class_239)hitResult);
        }
    }

    public boolean canHarmOwner() {
        if (this.method_24921() instanceof class_1657) {
            return this.method_37908().method_8407().method_5461() >= 1;
        }
        return false;
    }

    protected float getInertia() {
        return 0.99f;
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public boolean hasReachedEndOfLife() {
        return this.field_6012 > this.maxAge || this.stuckTime > this.maxStuckTime;
    }

    public void reachedEndOfLife() {
        this.method_5650(class_1297.class_5529.field_26999);
    }

    public void spawnTrailParticles() {
        if (this.method_5799()) {
            class_243 movement = this.method_18798();
            double velX = movement.field_1352;
            double velY = movement.field_1351;
            double velZ = movement.field_1350;
            for (int j = 0; j < 4; ++j) {
                double pY = this.method_23320();
                this.method_37908().method_8406((class_2394)class_2398.field_11247, this.method_23317() - velX * 0.25, pY - velY * 0.25, this.method_23321() - velZ * 0.25, velX, velY, velZ);
            }
        }
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("stuck", this.isStuck);
        tag.method_10569("stuckTime", this.stuckTime);
        tag.method_10556("noPhysics", this.isNoPhysics());
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.isStuck = tag.method_10577("stuck");
        this.stuckTime = tag.method_10550("stuckTime");
        this.setNoPhysics(tag.method_10577("noPhysics"));
    }

    public void method_24919(class_1297 shooter, float x, float y, float z, float velocity, float inaccuracy) {
        super.method_24919(shooter, x, y, z, velocity, inaccuracy);
    }

    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        super.method_7485(x, y, z, velocity, inaccuracy);
    }

    public float getDefaultShootVelocity() {
        return 1.5f;
    }

    protected void setFlag(int id, boolean value) {
        byte b0 = (Byte)this.field_6011.method_12789(ID_FLAGS);
        if (value) {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)(b0 | id)));
        } else {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)(b0 & ~id)));
        }
    }

    protected boolean getFlag(int id) {
        return ((Byte)this.field_6011.method_12789(ID_FLAGS) & id) != 0;
    }

    public void setNoPhysics(boolean noPhysics) {
        this.field_5960 = noPhysics;
        this.setFlag(2, noPhysics);
    }

    public boolean isNoPhysics() {
        return this.getFlag(2);
    }

    protected ColliderType getColliderType() {
        return ColliderType.AABB;
    }

    protected static enum ColliderType {
        RAY,
        AABB,
        ENTITY_COLLIDE;

    }
}

