/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.component.TardisInterior;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Nullable;

public class TardisInteriorManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private Map<class_2960, TardisInterior> interiors = Map.of();

    public TardisInteriorManager() {
        super(GSON, "mini_tardis/interiors");
    }

    public class_2960 getFabricId() {
        return MiniTardis.id("tardis_interiors");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<class_2960, JsonElement> entry : prepared.entrySet()) {
            Pair pair = (Pair)TardisInterior.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow();
            TardisInterior interior = (TardisInterior)pair.getFirst();
            builder.put((Object)entry.getKey(), (Object)interior);
        }
        this.interiors = builder.build();
        MiniTardis.LOGGER.info("Loaded {} Tardis interiors", (Object)this.interiors.size());
    }

    @Nullable
    public TardisInterior getInterior(class_2960 id) {
        return this.interiors.get(id);
    }
}

