/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.element;

import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.element.PlacedElement;
import dev.enjarai.minitardis.component.screen.element.WaypointListElement;
import net.minecraft.class_3222;
import net.minecraft.class_5536;

public class WaypointElement
extends PlacedElement {
    private final WaypointListElement parent;
    private final int index;

    public WaypointElement(WaypointListElement parent, int x, int y, int index) {
        super(x, y, 8, 8);
        this.parent = parent;
        this.index = index;
    }

    @Override
    protected void drawElement(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        if (this.parent.backingMap.get(this.index) == null) {
            canvas.draw(0, 0, this.isSelected() ? TardisCanvasUtils.getSprite("waypoint_empty_selected") : TardisCanvasUtils.getSprite("waypoint_empty"));
        } else {
            canvas.draw(0, 0, this.isSelected() ? TardisCanvasUtils.getSprite("waypoint_filled_selected") : TardisCanvasUtils.getSprite("waypoint_filled"));
        }
    }

    @Override
    protected boolean onClickElement(TardisControl controls, ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
        this.parent.selected = this;
        blockEntity.playClickSound(0.9f);
        return true;
    }

    public boolean isSelected() {
        return this.parent.selected == this;
    }

    public TardisLocation getWaypointValue() {
        return this.parent.backingMap.get(this.index);
    }

    public void setWaypointValue(TardisLocation location) {
        this.parent.backingMap.put(this.index, location);
    }

    public void clearWaypointValue() {
        this.parent.backingMap.remove(this.index);
    }
}

