/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.element;

import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.SubView;
import dev.enjarai.minitardis.component.screen.element.PlacedElement;
import dev.enjarai.minitardis.component.screen.element.SnakeElement;
import net.minecraft.class_3222;
import net.minecraft.class_5536;
import org.jetbrains.annotations.Nullable;

public class SnakeTailElement
extends PlacedElement {
    private final SnakeElement snake;
    int tickCount;
    boolean isInitialized = false;
    @Nullable
    SnakeTailElement nextSnailTail = null;

    public SnakeTailElement(SnakeElement snake) {
        super(0, 0, 4, 4);
        this.snake = snake;
    }

    @Override
    protected void drawElement(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("snake_tail"));
    }

    public void drawAndPush(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas, DrawableCanvas original) {
        if (this.isInitialized) {
            this.drawElement(controls, blockEntity, canvas);
        }
        if (this.nextSnailTail != null) {
            this.nextSnailTail.drawAndPush(controls, blockEntity, new SubView(original, this.nextSnailTail.x, this.nextSnailTail.y, this.nextSnailTail.width, this.nextSnailTail.height), original);
        }
    }

    public void moveToAndPush(int x, int y, int length) {
        if (this.nextSnailTail == null) {
            if (length < this.snake.tailLength) {
                this.nextSnailTail = new SnakeTailElement(this.snake);
            }
        } else {
            this.nextSnailTail.moveToAndPush(this.x, this.y, ++length);
        }
        this.moveToAndPush(x, y);
    }

    public void moveToAndPush(int x, int y) {
        this.x = x;
        this.y = y;
        if (!this.isInitialized) {
            this.isInitialized = true;
        }
    }

    @Override
    protected boolean onClickElement(TardisControl controls, ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
        return false;
    }

    public boolean doesCollide(int x, int y) {
        if (this.snake.x == this.x && this.snake.y == this.y) {
            return true;
        }
        if (this.nextSnailTail != null) {
            return this.nextSnailTail.doesCollide(x, y);
        }
        return false;
    }
}

