/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.element;

import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.SnakeApp;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.SubView;
import dev.enjarai.minitardis.component.screen.element.PlacedElement;
import dev.enjarai.minitardis.component.screen.element.SnakeTailElement;
import net.minecraft.class_3222;
import net.minecraft.class_5536;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class SnakeElement
extends PlacedElement {
    private final SnakeApp.SnakeAppView snakeAppView;
    int tickCount;
    public int tailLength;
    public SnakeMove snakeMove = SnakeMove.RIGHT;
    @Nullable
    public SnakeTailElement snakeTail = null;

    public SnakeElement(SnakeApp.SnakeAppView snakeAppView) {
        super(2, 18, 4, 4);
        this.snakeAppView = snakeAppView;
    }

    @Override
    public void draw(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        super.draw(controls, blockEntity, canvas);
        if (this.snakeTail != null) {
            this.snakeTail.drawAndPush(controls, blockEntity, new SubView(canvas, this.snakeTail.x, this.snakeTail.y, this.snakeTail.width, this.snakeTail.height), canvas);
        }
    }

    @Override
    protected void drawElement(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("snake"));
    }

    @Override
    protected boolean onClickElement(TardisControl controls, ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
        return false;
    }

    @Override
    public void tick(TardisControl controls, ScreenBlockEntity blockEntity) {
        ++this.tickCount;
        if (this.tickCount % this.getGameSpeed() == 0) {
            this.snakeAppView.deterministicRandom.method_33650(this.snakeMove.ordinal());
            this.move(this.snakeMove);
            if (this.snakeTail != null && this.snakeTail.doesCollide(this.x, this.y)) {
                this.killedByTail(blockEntity);
                return;
            }
            if (!SnakeElement.isInBounds(this.getRelativeX(), this.getRelativeY())) {
                this.killedByWall(blockEntity);
                return;
            }
        }
    }

    public boolean doesCollide(int x, int y) {
        return x == this.x && y == this.y || this.snakeTail != null && this.snakeTail.doesCollide(x, y);
    }

    public int getGameSpeed() {
        return Math.max(Math.round(5.0f - (float)this.tailLength / 10.0f), 2);
    }

    public static boolean isInBounds(int relativeX, int relativeY) {
        return relativeX >= 0 && relativeX <= 120 && relativeY >= 0 && relativeY <= 72;
    }

    public void move(SnakeMove snakeMove) {
        if (this.snakeTail != null) {
            this.snakeTail.moveToAndPush(this.x, this.y, 1);
        }
        this.x += snakeMove.x;
        this.y += snakeMove.y;
    }

    public int getRelativeX() {
        return this.x - 2;
    }

    public int getRelativeY() {
        return this.y - 18;
    }

    public void ateApple() {
        if (this.snakeTail == null) {
            this.snakeTail = new SnakeTailElement(this);
        }
        ++this.tailLength;
    }

    public void killedByWall(ScreenBlockEntity blockEntity) {
        this.snakeAppView.snakeDied(blockEntity);
    }

    public void killedByTail(ScreenBlockEntity blockEntity) {
        this.snakeAppView.snakeDied(blockEntity);
    }

    public static enum SnakeMove {
        UP(0, 4, MoveType.HORIZONTAL),
        DOWN(0, -4, MoveType.HORIZONTAL),
        LEFT(-4, 0, MoveType.VERTICAL),
        RIGHT(4, 0, MoveType.VERTICAL);

        final int x;
        final int y;
        final MoveType moveType;

        private SnakeMove(int x, int y, MoveType moveType) {
            this.x = x;
            this.y = y;
            this.moveType = moveType;
        }

        public SnakeMove getSnakeMove(Vector2i vector2i) {
            return switch (this.moveType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (vector2i.x > 0) {
                        yield RIGHT;
                    }
                    yield LEFT;
                }
                case 1 -> vector2i.y > 0 ? UP : DOWN;
            };
        }

        public static enum MoveType {
            HORIZONTAL,
            VERTICAL;

        }
    }
}

