/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.element;

import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.element.AbstractParentElement;
import dev.enjarai.minitardis.component.screen.element.PlacedElement;
import net.minecraft.class_3222;
import net.minecraft.class_5536;

public class ScrollableContainerElement<T extends PlacedElement>
extends AbstractParentElement<T> {
    public int scrolledness;

    public ScrollableContainerElement(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    protected void drawElement(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        ScrolledView scrolledCanvas = new ScrolledView(canvas, this.getScrollableHeight());
        for (PlacedElement element : this.elements) {
            element.draw(controls, blockEntity, scrolledCanvas);
        }
        canvas.draw(this.width - 8, 0, TardisCanvasUtils.getSprite("scroll_button_up"));
        canvas.draw(this.width - 8, this.height - 38, TardisCanvasUtils.getSprite("scroll_button_down"));
    }

    @Override
    protected boolean onClickElement(TardisControl controls, ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
        if (x >= this.width - 8) {
            if (y < 38) {
                this.scrolledness = Math.max(0, this.scrolledness - 16);
            } else if (y >= this.height - 38) {
                this.scrolledness = Math.min(this.getScrollableHeight() - this.height, this.scrolledness + 16);
            }
            blockEntity.playClickSound(1.8f);
            return true;
        }
        for (PlacedElement element : this.elements) {
            if (!element.onClick(controls, blockEntity, player, type, x, y + this.scrolledness)) continue;
            return true;
        }
        return false;
    }

    public int getScrollableHeight() {
        return this.elements.stream().map(el -> el.y + el.height).max(Integer::compareTo).orElse(0);
    }

    private class ScrolledView
    implements DrawableCanvas {
        private final DrawableCanvas source;
        private final int scrollableHeight;

        private ScrolledView(DrawableCanvas source, int scrollableHeight1) {
            this.source = source;
            this.scrollableHeight = scrollableHeight1;
        }

        @Override
        public short getRaw(int x, int y) {
            return this.source.getRaw(x, y);
        }

        @Override
        public void setRaw(int x, int y, short color) {
            if ((y -= ScrollableContainerElement.this.scrolledness) >= 0 && y < ScrollableContainerElement.this.height) {
                this.source.setRaw(x, y, color);
            }
        }

        @Override
        public int getHeight() {
            return this.scrollableHeight;
        }

        @Override
        public int getWidth() {
            return ScrollableContainerElement.this.width;
        }
    }
}

