/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.element;

import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.element.PlacedElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3222;
import net.minecraft.class_5536;

public abstract class AbstractParentElement<T extends PlacedElement>
extends PlacedElement {
    protected final List<T> elements = new ArrayList<T>();

    public AbstractParentElement(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    protected void drawElement(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        for (PlacedElement element : this.elements) {
            element.draw(controls, blockEntity, canvas);
        }
    }

    @Override
    protected boolean onClickElement(TardisControl controls, ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
        for (PlacedElement element : this.elements) {
            if (!element.onClick(controls, blockEntity, player, type, x, y)) continue;
            return true;
        }
        return false;
    }

    public void addElement(T element) {
        this.elements.add(element);
    }

    public void removeElement(T element) {
        this.elements.remove(element);
    }

    public List<T> getElements() {
        return this.elements;
    }

    public void clearElements() {
        this.elements.clear();
    }
}

