/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.CanvasFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.BitmapFont;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class VanillaFontReader {
    public static CanvasFont build(ZipFile[] zipFile, class_2960 identifier) {
        ArrayList<String> lines = new ArrayList<String>();
        for (ZipFile zip : zipFile) {
            try {
                ZipEntry entry = zip.getEntry("pack.mcmeta");
                InputStream stream = zip.getInputStream(entry);
                JsonElement json = JsonParser.parseString((String)new String(stream.readAllBytes()));
                stream.close();
                lines.add(class_2561.class_2562.method_10872((JsonElement)json.getAsJsonObject().get("pack").getAsJsonObject().get("description"), (class_7225.class_7874)class_5455.method_40302((class_2378)class_7923.field_41167)).getString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return VanillaFontReader.build(zipFile, CanvasFont.Metadata.create("Resource Pack Font", List.of("Unknown"), "Generated from resource packs.\n" + String.join((CharSequence)"\n", lines)), identifier);
    }

    public static BitmapFont build(ZipFile[] files, CanvasFont.Metadata metadata, class_2960 identifier) {
        return VanillaFontReader.build(new StackedZipFile(files)::getInputSteam, metadata, identifier);
    }

    public static BitmapFont build(Function<String, @Nullable InputStream> getter, CanvasFont.Metadata metadata, class_2960 identifier) {
        BitmapFont font = new BitmapFont(BitmapFont.Glyph.INVALID, metadata);
        try {
            VanillaFontReader.parseFontFile(getter, font, identifier);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return font;
    }

    private static void parseFontFile(Function<String, @Nullable InputStream> file, BitmapFont font, class_2960 identifier) {
        block26: {
            try {
                InputStream entry = file.apply("assets/" + identifier.method_12836() + "/font/" + identifier.method_12832() + ".json");
                if (entry == null) break block26;
                JsonArray json = JsonParser.parseString((String)new String(entry.readAllBytes())).getAsJsonObject().getAsJsonArray("providers");
                for (JsonElement tmp : json) {
                    JsonObject obj = tmp.getAsJsonObject();
                    try {
                        String type;
                        switch (type = obj.getAsJsonPrimitive("type").getAsString()) {
                            case "bitmap": {
                                class_2960 path = class_2960.method_60654((String)obj.getAsJsonPrimitive("file").getAsString());
                                int ascent = obj.getAsJsonPrimitive("ascent").getAsInt();
                                int height = 8;
                                try {
                                    height = obj.getAsJsonPrimitive("height").getAsInt();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                InputStream input = file.apply("assets/" + path.method_12836() + "/textures/" + path.method_12832());
                                if (input == null) break;
                                BufferedImage texture = ImageIO.read(input);
                                JsonArray charJson = obj.getAsJsonArray("chars");
                                int charWidth = texture.getWidth() / charJson.get(0).getAsString().length();
                                int charHeight = texture.getHeight() / charJson.size();
                                for (int y = 0; y < charJson.size(); ++y) {
                                    String chars = charJson.get(y).getAsString();
                                    int[] array = chars.codePoints().toArray();
                                    for (int x = 0; x < array.length; ++x) {
                                        try {
                                            boolean[] glyphTexture = new boolean[charHeight * charWidth];
                                            int realWidth = 0;
                                            for (int xd = 0; xd < charWidth; ++xd) {
                                                for (int yd = 0; yd < charHeight; ++yd) {
                                                    if ((texture.getRGB(x * charWidth + xd, y * charHeight + yd) >> 24 & 0xFF) <= 64) continue;
                                                    glyphTexture[xd + yd * charWidth] = true;
                                                    realWidth = Math.max(realWidth, xd);
                                                }
                                            }
                                            if (font.characters.containsKey(array[x])) continue;
                                            int trueWidth = realWidth + 1;
                                            boolean[] textureCompact = new boolean[charHeight * trueWidth];
                                            for (int xd = 0; xd < trueWidth; ++xd) {
                                                for (int yd = 0; yd < charHeight; ++yd) {
                                                    textureCompact[xd + yd * trueWidth] = glyphTexture[xd + yd * charWidth];
                                                }
                                            }
                                            font.characters.put(array[x], (Object)new BitmapFont.Glyph(trueWidth, charHeight, ascent, realWidth, height, textureCompact));
                                            continue;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                break;
                            }
                            case "space": {
                                JsonObject advances = obj.get("advances").getAsJsonObject();
                                for (String key : advances.keySet()) {
                                    font.characters.put(key.codePointAt(0), (Object)new BitmapFont.Glyph(0, 0, 0, advances.getAsJsonPrimitive(key).getAsInt(), 0, new boolean[0]));
                                }
                                break;
                            }
                            case "reference": {
                                class_2960 id = class_2960.method_12829((String)obj.get("id").getAsString());
                                if (id == null) break;
                                VanillaFontReader.parseFontFile(file, font, id);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public record StackedZipFile(ZipFile[] files) {
        public ZipEntry getEntry(String path) {
            for (ZipFile file : this.files) {
                ZipEntry entry = file.getEntry(path);
                if (entry == null) continue;
                return entry;
            }
            return null;
        }

        public InputStream getInputStream(ZipEntry entry) {
            for (ZipFile file : this.files) {
                try {
                    InputStream stream = file.getInputStream(entry);
                    if (stream == null) continue;
                    return stream;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        @Nullable
        public InputStream getInputSteam(String s) {
            ZipEntry entry = this.getEntry(s);
            if (entry != null) {
                return this.getInputStream(entry);
            }
            return null;
        }
    }
}

