/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.serialization;

import com.google.common.primitives.Shorts;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.CanvasFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.BitmapFont;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class RawBitmapFontSerializer {
    private static final short MAGIC = 31919;
    private static final byte VERSION = 1;

    public static boolean write(BitmapFont font, OutputStream stream) {
        return RawBitmapFontSerializer.write(font, stream, Compression.GZIP);
    }

    public static boolean write(BitmapFont font, OutputStream stream, Compression compress) {
        try {
            stream.write(Shorts.toByteArray((short)31919));
            stream.write(1);
            stream.write(compress.ordinal());
            stream = switch (compress.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> stream;
                case 1 -> {
                    var cStream = new GZIPOutputStream(stream){

                        public void setLevel(int level) {
                            this.def.setLevel(level);
                        }
                    };
                    cStream.setLevel(9);
                    yield cStream;
                }
            };
            Object bytes = font.getMetadata().name().getBytes(StandardCharsets.UTF_8);
            RawBitmapFontSerializer.writeVarInt(((byte[])bytes).length, stream);
            stream.write((byte[])bytes);
            RawBitmapFontSerializer.writeVarInt(font.getMetadata().authors().size(), stream);
            bytes = font.getMetadata().authors().iterator();
            while (bytes.hasNext()) {
                String author = (String)bytes.next();
                byte[] bytes2 = author.getBytes(StandardCharsets.UTF_8);
                RawBitmapFontSerializer.writeVarInt(bytes2.length, stream);
                stream.write(bytes2);
            }
            if (font.getMetadata().description().isPresent()) {
                bytes = font.getMetadata().description().get().getBytes(StandardCharsets.UTF_8);
                RawBitmapFontSerializer.writeVarInt(((byte[])bytes).length, stream);
                stream.write((byte[])bytes);
            } else {
                RawBitmapFontSerializer.writeVarInt(0, stream);
            }
            RawBitmapFontSerializer.writeVarInt(font.characters.size(), stream);
            bytes = font.characters.int2ObjectEntrySet().iterator();
            while (bytes.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)bytes.next();
                RawBitmapFontSerializer.writeVarInt(entry.getIntKey(), stream);
                RawBitmapFontSerializer.writeGlyph((BitmapFont.Glyph)entry.getValue(), stream);
            }
            RawBitmapFontSerializer.writeGlyph(font.defaultGlyph, stream);
            if (stream instanceof GZIPOutputStream) {
                GZIPOutputStream gzipOutputStream = (GZIPOutputStream)stream;
                gzipOutputStream.finish();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static BitmapFont read(InputStream stream) {
        try {
            if (Shorts.fromByteArray((byte[])stream.readNBytes(2)) == 31919) {
                CanvasFont.Metadata metadata;
                int version = stream.read();
                if (version == 0) {
                    metadata = CanvasFont.Metadata.empty();
                } else if (version == 1) {
                    int compressionId = stream.read();
                    if (Compression.values().length <= compressionId || compressionId < 0) {
                        throw new RuntimeException("Unsupported font compression");
                    }
                    stream = switch (Compression.values()[compressionId].ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> stream;
                        case 1 -> new GZIPInputStream(stream);
                    };
                    String name = new String(stream.readNBytes(RawBitmapFontSerializer.readVarInt(stream)), StandardCharsets.UTF_8);
                    int size = RawBitmapFontSerializer.readVarInt(stream);
                    ArrayList<String> authors = new ArrayList<String>(size);
                    for (int i = 0; i < size; ++i) {
                        authors.add(new String(stream.readNBytes(RawBitmapFontSerializer.readVarInt(stream)), StandardCharsets.UTF_8));
                    }
                    int descSize = RawBitmapFontSerializer.readVarInt(stream);
                    String description = descSize > 0 ? new String(stream.readNBytes(descSize), StandardCharsets.UTF_8) : null;
                    metadata = CanvasFont.Metadata.create(name, authors, description);
                } else {
                    throw new RuntimeException("Unsupported font version");
                }
                Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
                int size = RawBitmapFontSerializer.readVarInt(stream);
                for (int x = 0; x < size; ++x) {
                    map.put(RawBitmapFontSerializer.readVarInt(stream), (Object)RawBitmapFontSerializer.readGlyph(stream));
                }
                BitmapFont.Glyph defaultGlyph = RawBitmapFontSerializer.readGlyph(stream);
                return new BitmapFont(defaultGlyph, (Int2ObjectMap<BitmapFont.Glyph>)map, metadata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void writeGlyph(BitmapFont.Glyph glyph, OutputStream stream) throws IOException {
        RawBitmapFontSerializer.writeVarInt(glyph.width(), stream);
        RawBitmapFontSerializer.writeVarInt(glyph.height(), stream);
        RawBitmapFontSerializer.writeVarInt(glyph.ascend(), stream);
        RawBitmapFontSerializer.writeVarInt(glyph.fontWidth(), stream);
        RawBitmapFontSerializer.writeVarInt(glyph.logicalHeight(), stream);
        BitSet set = new BitSet(glyph.texture().length);
        for (int i = 0; i < glyph.texture().length; ++i) {
            set.set(i, glyph.texture()[i]);
        }
        byte[] bytes = set.toByteArray();
        RawBitmapFontSerializer.writeVarInt(bytes.length, stream);
        stream.write(bytes);
    }

    private static BitmapFont.Glyph readGlyph(InputStream stream) throws IOException {
        int width = RawBitmapFontSerializer.readVarInt(stream);
        int height = RawBitmapFontSerializer.readVarInt(stream);
        int ascend = RawBitmapFontSerializer.readVarInt(stream);
        int fontWidth = RawBitmapFontSerializer.readVarInt(stream);
        int logicalHeight = RawBitmapFontSerializer.readVarInt(stream);
        int length = RawBitmapFontSerializer.readVarInt(stream);
        boolean[] texture = new boolean[height * width];
        BitSet set = BitSet.valueOf(stream.readNBytes(length));
        for (int i = 0; i < set.length(); ++i) {
            texture[i] = set.get(i);
        }
        return new BitmapFont.Glyph(width, height, ascend, fontWidth, logicalHeight, texture);
    }

    private static void writeVarInt(int value, OutputStream stream) throws IOException {
        while ((value & 0xFFFFFF80) != 0) {
            stream.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        stream.write(value);
    }

    public static int readVarInt(InputStream stream) throws IOException {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = (byte)stream.read();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            return Integer.MAX_VALUE;
        } while ((b & 0x80) == 128);
        return i;
    }

    public static enum Compression {
        NONE,
        GZIP;

    }
}

